/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.requerimento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItemId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import javax.validation.constraints.Positive;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;

@Entity
@Table(name="tribrequerimentoitem")
public class RequerimentoItem
implements EloEntity<RequerimentoItemId> {
    @EmbeddedId
    private RequerimentoItemId id;
    @MapsId(value="entidade,exercicio,requerimento")
    @ManyToOne
    @JsonIgnore
    @MetaModelIgnore
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="requerimento", referencedColumnName="requerimento")})
    private Requerimento requerimento;
    private String descricao;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receita", referencedColumnName="receita"))})
    private Tributo tributo;
    @Positive
    private BigDecimal quantidade = BigDecimal.ZERO;
    @Positive
    private BigDecimal valorUnitario = BigDecimal.ZERO;

    public BigDecimal getValorTotal() {
        return this.quantidade.multiply(this.valorUnitario);
    }

    @Generated
    public RequerimentoItem() {
    }

    @Generated
    public RequerimentoItemId getId() {
        return this.id;
    }

    @Generated
    public Requerimento getRequerimento() {
        return this.requerimento;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Tributo getTributo() {
        return this.tributo;
    }

    @Generated
    public BigDecimal getQuantidade() {
        return this.quantidade;
    }

    @Generated
    public BigDecimal getValorUnitario() {
        return this.valorUnitario;
    }

    @Generated
    public void setId(RequerimentoItemId id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setRequerimento(Requerimento requerimento) {
        this.requerimento = requerimento;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setTributo(Tributo tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setQuantidade(BigDecimal quantidade) {
        this.quantidade = quantidade;
    }

    @Generated
    public void setValorUnitario(BigDecimal valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    @Generated
    public String toString() {
        return "RequerimentoItem(id=" + String.valueOf(this.getId()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequerimentoItem)) {
            return false;
        }
        RequerimentoItem other = (RequerimentoItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RequerimentoItemId this$id = this.getId();
        RequerimentoItemId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequerimentoItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequerimentoItemId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

