/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.pagamentocredito;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCreditoMovimentacao;
import br.com.elotech.tributos.enums.pagamentocredito.TipoMovimentacaoCredito;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="tribpagamentocreditomovimento")
public class PagamentoCreditoMovimentacao
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="S05IDPAGAMENTOCREDITOMOVIMENTO")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pagamentocredito")
    @JsonIncludeProperties(value={"id", "pessoa"})
    private PagamentoCredito pagamentoCredito;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(column=@JoinColumn(name="iddevolucaocredito", referencedColumnName="iddevolucaocredito")), @JoinColumnOrFormula(column=@JoinColumn(name="iddevolucaocreditoitem", referencedColumnName="sequenciaitem"))})
    @JsonIgnore
    private DevolucaoCreditoItem devolucaoCreditoItem;
    @Column(name="tipo")
    @Enumerated(value=EnumType.STRING)
    private TipoMovimentacaoCredito tipoMovimentacao;
    @Column(name="datamovimentacao")
    private LocalDate dataMovimentacao;
    @Column(name="valorutilizado")
    private BigDecimal valorUtilizado;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="boletopago")
    @JsonIncludeProperties(value={"id", "bloqueto", "exercicioBloqueto"})
    private Bloqueto boletoPago;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="novocredito")
    @JsonIncludeProperties(value={"id"})
    private PagamentoCredito novoCredito;
    private String usuario;

    public static PagamentoCreditoMovimentacao makeTo(Bloqueto bloqueto, String usuarioCnpjCpf, PagamentoCredito credito) {
        return PagamentoCreditoMovimentacao.builder().boletoPago(bloqueto).valorUtilizado(bloqueto.getValorBloqueto()).usuario(usuarioCnpjCpf).dataMovimentacao(LocalDate.now()).pagamentoCredito(credito).build();
    }

    public static PagamentoCreditoMovimentacao makeTo(PagamentoCredito novoCredito, String usuarioCnpjCpf, PagamentoCredito credito) {
        return PagamentoCreditoMovimentacao.builder().valorUtilizado(credito.getSaldoDisponivel()).usuario(usuarioCnpjCpf).dataMovimentacao(LocalDate.now()).pagamentoCredito(credito).novoCredito(novoCredito).build();
    }

    public static PagamentoCreditoMovimentacao makeTo(DevolucaoCreditoItem devolucaoCreditoItem, String usuarioCnpjCpf, PagamentoCredito credito) {
        return PagamentoCreditoMovimentacao.builder().valorUtilizado(devolucaoCreditoItem.getValorDevolucao()).devolucaoCreditoItem(devolucaoCreditoItem).usuario(usuarioCnpjCpf).dataMovimentacao(LocalDate.now()).pagamentoCredito(credito).build();
    }

    public PagamentoCreditoMovimentacao pagamento() {
        this.tipoMovimentacao = TipoMovimentacaoCredito.PAGAMENTO;
        return this;
    }

    public PagamentoCreditoMovimentacao restituicao() {
        this.tipoMovimentacao = TipoMovimentacaoCredito.RESTITUICAO;
        return this;
    }

    public PagamentoCreditoMovimentacao transferenciaSaldoRemanescente() {
        this.tipoMovimentacao = TipoMovimentacaoCredito.TRANSFERENCIA_REMANESCENTE;
        return this;
    }

    public PagamentoCreditoMovimentacao estornoPagamento() {
        this.tipoMovimentacao = TipoMovimentacaoCredito.ESTORNO_PAGAMENTO;
        return this;
    }

    @Generated
    public static PagamentoCreditoMovimentacaoBuilder builder() {
        return new PagamentoCreditoMovimentacaoBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public PagamentoCredito getPagamentoCredito() {
        return this.pagamentoCredito;
    }

    @Generated
    public DevolucaoCreditoItem getDevolucaoCreditoItem() {
        return this.devolucaoCreditoItem;
    }

    @Generated
    public TipoMovimentacaoCredito getTipoMovimentacao() {
        return this.tipoMovimentacao;
    }

    @Generated
    public LocalDate getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    @Generated
    public BigDecimal getValorUtilizado() {
        return this.valorUtilizado;
    }

    @Generated
    public Bloqueto getBoletoPago() {
        return this.boletoPago;
    }

    @Generated
    public PagamentoCredito getNovoCredito() {
        return this.novoCredito;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setPagamentoCredito(PagamentoCredito pagamentoCredito) {
        this.pagamentoCredito = pagamentoCredito;
    }

    @JsonIgnore
    @Generated
    public void setDevolucaoCreditoItem(DevolucaoCreditoItem devolucaoCreditoItem) {
        this.devolucaoCreditoItem = devolucaoCreditoItem;
    }

    @Generated
    public void setTipoMovimentacao(TipoMovimentacaoCredito tipoMovimentacao) {
        this.tipoMovimentacao = tipoMovimentacao;
    }

    @Generated
    public void setDataMovimentacao(LocalDate dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Generated
    public void setValorUtilizado(BigDecimal valorUtilizado) {
        this.valorUtilizado = valorUtilizado;
    }

    @Generated
    public void setBoletoPago(Bloqueto boletoPago) {
        this.boletoPago = boletoPago;
    }

    @Generated
    public void setNovoCredito(PagamentoCredito novoCredito) {
        this.novoCredito = novoCredito;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public String toString() {
        return "PagamentoCreditoMovimentacao(id=" + this.getId() + ", pagamentoCredito=" + String.valueOf(this.getPagamentoCredito()) + ", devolucaoCreditoItem=" + String.valueOf(this.getDevolucaoCreditoItem()) + ", tipoMovimentacao=" + String.valueOf(this.getTipoMovimentacao()) + ", dataMovimentacao=" + String.valueOf(this.getDataMovimentacao()) + ", valorUtilizado=" + String.valueOf(this.getValorUtilizado()) + ", boletoPago=" + String.valueOf(this.getBoletoPago()) + ", novoCredito=" + String.valueOf(this.getNovoCredito()) + ", usuario=" + this.getUsuario() + ")";
    }

    @Generated
    public PagamentoCreditoMovimentacao(Long id, PagamentoCredito pagamentoCredito, DevolucaoCreditoItem devolucaoCreditoItem, TipoMovimentacaoCredito tipoMovimentacao, LocalDate dataMovimentacao, BigDecimal valorUtilizado, Bloqueto boletoPago, PagamentoCredito novoCredito, String usuario) {
        this.id = id;
        this.pagamentoCredito = pagamentoCredito;
        this.devolucaoCreditoItem = devolucaoCreditoItem;
        this.tipoMovimentacao = tipoMovimentacao;
        this.dataMovimentacao = dataMovimentacao;
        this.valorUtilizado = valorUtilizado;
        this.boletoPago = boletoPago;
        this.novoCredito = novoCredito;
        this.usuario = usuario;
    }

    @Generated
    public PagamentoCreditoMovimentacao() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoCreditoMovimentacao)) {
            return false;
        }
        PagamentoCreditoMovimentacao other = (PagamentoCreditoMovimentacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoCreditoMovimentacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

