/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.pagamento;

import br.com.elotech.core.annotation.EloSequence;
import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Embeddable
public class PagamentoLoteId
implements Serializable {
    @NotNull(message="Obrigat\u00f3rio a Entidade para o Pagamento Lote")
    private @NotNull(message="Obrigat\u00f3rio a Entidade para o Pagamento Lote") Long entidade;
    @NotNull(message="Obrigat\u00f3rio o Exerc\u00edcio vigente para o Pagamento Lote")
    private @NotNull(message="Obrigat\u00f3rio o Exerc\u00edcio vigente para o Pagamento Lote") Long exercicio;
    @NotNull(message="Obrigat\u00f3rio lote para o Pagamento Lote")
    @EloSequence(sequenceName="S05LOTE_#{entidade}_#{exercicio}")
    private @NotNull(message="Obrigat\u00f3rio lote para o Pagamento Lote") Long lote;

    public static PagamentoLoteId of(Long entidade, Long exercicio, Long lote) {
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        id.setLote(lote);
        return id;
    }

    public String toString() {
        return String.format("%s/%s/%s", this.entidade, this.exercicio, this.lote);
    }

    @Generated
    public PagamentoLoteId() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoLoteId)) {
            return false;
        }
        PagamentoLoteId other = (PagamentoLoteId)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        return !(this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoLoteId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        return result;
    }
}

