/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnore;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnoreProperties;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.converter.NivelProfissionalConverter;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoSocio;
import br.com.elotech.tributos.enums.NivelProfissional;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.IndexedEmbedded;

@Entity
@Table(name="TribContratoSocialPessoa")
@Audited
public class ContratoSocialPessoa
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBCONTRATOSOCIALPESSOA_ID")
    private Long id;
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="pessoa", referencedColumnName="pessoa")
    @NotNull
    @Caption(value="Pessoa")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DiffRevisionIgnoreProperties(value={"id", "enderecos", "bancos", "contatos", "rg", "orgaoEmissor", "dataEmissao", "inscricaoEstadual", "sequenciaEndereco", "sequenciaContato", "sequenciaBanco", "contribuinte", "fornecedor", "pessoal", "dataInclusao", "observacao", "usuarioInclusao", "estadoEmissor", "microEmpresa", "dataAlteracao", "estrangeiro", "autonomo", "atividadePrincipal", "inscricaoMunicipal", "dataIssqn", "fornecedorSiscop", "codigoSistemaAnterior", "inativo", "sequenciaImagem", "activeFormOrigem", "dataNascimento", "nit", "nire", "pis", "dataAberturaCnpj", "idTcePR", "idUnico", "enderecoPrincipal", "contatoPrincipal", "contaBancariaPrincipal"})
    private Pessoa pessoa;
    @ManyToOne
    @JoinColumn(name="tiposocio", referencedColumnName="tiposocio")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Tipo S\u00f3cio")
    private TipoSocio tipoSocio;
    @Caption(value="Percentual Capital")
    private BigDecimal percentualCapital = BigDecimal.ZERO;
    @Column(name="RESPONSAVEL")
    @Caption(value="Respons\u00e1vel")
    private Boolean responsavel = Boolean.FALSE;
    @DiffRevisionIgnore
    private Long idSocioIss;
    private LocalDate dataEntrada;
    private LocalDate dataSaida;
    private LocalDate dataRegistroOrgao;
    @Convert(converter=NivelProfissionalConverter.class)
    private NivelProfissional nivelProfissional;
    private Boolean ativo = Boolean.TRUE;

    @Field(analyze=Analyze.NO)
    @Facet
    @JsonIgnore
    public String getTipoSocioDescricao() {
        return Optional.ofNullable(this.getTipoSocio()).map(TipoSocio::getDescricao).orElse("");
    }

    public void merge(ContratoSocialPessoa contratoSocialPessoa) {
        this.setPessoa(contratoSocialPessoa.pessoa);
        this.setPercentualCapital(contratoSocialPessoa.getPercentualCapital());
        this.setTipoSocio(contratoSocialPessoa.getTipoSocio());
        this.setResponsavel(contratoSocialPessoa.getResponsavel());
        this.setDataEntrada(contratoSocialPessoa.getDataEntrada());
        this.setDataSaida(contratoSocialPessoa.getDataSaida());
        this.setDataRegistroOrgao(contratoSocialPessoa.getDataRegistroOrgao());
        this.setNivelProfissional(contratoSocialPessoa.getNivelProfissional());
        this.setAtivo(contratoSocialPessoa.getAtivo());
    }

    @Generated
    public ContratoSocialPessoa() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoSocio getTipoSocio() {
        return this.tipoSocio;
    }

    @Generated
    public BigDecimal getPercentualCapital() {
        return this.percentualCapital;
    }

    @Generated
    public Boolean getResponsavel() {
        return this.responsavel;
    }

    @Generated
    public Long getIdSocioIss() {
        return this.idSocioIss;
    }

    @Generated
    public LocalDate getDataEntrada() {
        return this.dataEntrada;
    }

    @Generated
    public LocalDate getDataSaida() {
        return this.dataSaida;
    }

    @Generated
    public LocalDate getDataRegistroOrgao() {
        return this.dataRegistroOrgao;
    }

    @Generated
    public NivelProfissional getNivelProfissional() {
        return this.nivelProfissional;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoSocio(TipoSocio tipoSocio) {
        this.tipoSocio = tipoSocio;
    }

    @Generated
    public void setPercentualCapital(BigDecimal percentualCapital) {
        this.percentualCapital = percentualCapital;
    }

    @Generated
    public void setResponsavel(Boolean responsavel) {
        this.responsavel = responsavel;
    }

    @Generated
    public void setIdSocioIss(Long idSocioIss) {
        this.idSocioIss = idSocioIss;
    }

    @Generated
    public void setDataEntrada(LocalDate dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    @Generated
    public void setDataSaida(LocalDate dataSaida) {
        this.dataSaida = dataSaida;
    }

    @Generated
    public void setDataRegistroOrgao(LocalDate dataRegistroOrgao) {
        this.dataRegistroOrgao = dataRegistroOrgao;
    }

    @Generated
    public void setNivelProfissional(NivelProfissional nivelProfissional) {
        this.nivelProfissional = nivelProfissional;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public String toString() {
        return "ContratoSocialPessoa(id=" + this.getId() + ", pessoa=" + String.valueOf(this.getPessoa()) + ", tipoSocio=" + String.valueOf(this.getTipoSocio()) + ", percentualCapital=" + String.valueOf(this.getPercentualCapital()) + ", responsavel=" + this.getResponsavel() + ", idSocioIss=" + this.getIdSocioIss() + ", dataEntrada=" + String.valueOf(this.getDataEntrada()) + ", dataSaida=" + String.valueOf(this.getDataSaida()) + ", dataRegistroOrgao=" + String.valueOf(this.getDataRegistroOrgao()) + ", nivelProfissional=" + String.valueOf(this.getNivelProfissional()) + ", ativo=" + this.getAtivo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContratoSocialPessoa)) {
            return false;
        }
        ContratoSocialPessoa other = (ContratoSocialPessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContratoSocialPessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

