/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnore;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnoreProperties;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.TipoCapitalSocial;
import br.com.elotech.tributos.domain.TipoRegistroMercantil;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocialPessoa;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TribContratoSocial")
@Audited
public class ContratoSocial
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBCONTRATOSOCIAL_ID")
    private Long id;
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tribcadastromobiliario_idkey", referencedColumnName="TRIBCADASTROGERAL_IDKEY")
    private CadastroMobiliario cadastroMobiliario;
    @NotNull
    @Caption(value="Sequ\u00eancia")
    private Long sequencia;
    @ManyToOne
    @JoinColumn(name="tipocapitalsocial")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Tipo Capital Social")
    private TipoCapitalSocial tipoCapitalSocial;
    @ManyToOne
    @JoinColumn(name="tiporegistromercantil")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Tipo Registro Mercantil")
    private TipoRegistroMercantil tipoRegistroMercantil;
    @Length(max=100)
    @Column(name="CONTRATO_CARTORIOALTERACAO")
    @Caption(value="Contrato Cart\u00f3rio Altera\u00e7\u00e3o")
    private @Length(max=100) String contratoCartorioAlteracao;
    @Length(max=100)
    @Column(name="CONTRATO_REGISTROALTERACAO")
    @Caption(value="Contrato Registro Altera\u00e7\u00e3o")
    private @Length(max=100) String contratoRegistroAlteracao;
    @Length(max=100)
    @Column(name="CONTRATO_AVERBACAOALTERACAO")
    @Caption(value="Contrato Averba\u00e7\u00e3o Altera\u00e7\u00e3o")
    private @Length(max=100) String contratoAverbacaoAlteracao;
    @Column(name="CONTRATO_DATAALTERACAO")
    @Caption(value="Contrato Data Altera\u00e7\u00e3o")
    private LocalDate contratoDataAlteracao;
    @Caption(value="Capital Social")
    private BigDecimal capitalSocial = BigDecimal.ZERO;
    @Caption(value="Valor Cotas")
    private BigDecimal valorCotas = BigDecimal.ZERO;
    @Column(name="USUARIO", length=250)
    @Caption(value="Usu\u00e1rio")
    private String usuario;
    @Caption(value="N\u00famero Altera\u00e7\u00e3o")
    private Long numeroAlteracao;
    @Length(max=15)
    @Caption(value="N\u00famero Junta Comercial")
    private @Length(max=15) String numeroJuntaComercial;
    @Caption(value="Data Registro Junta Comercial")
    private LocalDate dataRegistroJuntaComercial;
    @Length(max=250)
    @Caption(value="Observa\u00e7\u00e3o Descri\u00e7\u00e3o Altera\u00e7\u00e3o")
    private @Length(max=250) String observacaoDescricaoAlteracao;
    @IndexedEmbedded
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCONTRATOSOCIAL_IDKEY", nullable=false)
    @Caption(value="Contrato Social Pessoa")
    @AuditJoinTable(name="TRIB_CSOCIAL_CSOCIALPESSOA_AUD")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<ContratoSocialPessoa> pessoas = new ArrayList();

    @DiffRevisionIgnore
    public boolean isNovo() {
        return this.getId() == null || this.getSequencia() == null;
    }

    @JsonIgnore
    public BigDecimal getTotalPercentualSocios() {
        return this.getPessoas().stream().map(ContratoSocialPessoa::getPercentualCapital).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public ContratoSocial merge(ContratoSocial contratoSocialToMerge) {
        this.setSequencia(contratoSocialToMerge.getSequencia());
        this.setTipoCapitalSocial(contratoSocialToMerge.getTipoCapitalSocial());
        this.setTipoRegistroMercantil(contratoSocialToMerge.getTipoRegistroMercantil());
        this.setContratoCartorioAlteracao(contratoSocialToMerge.getContratoCartorioAlteracao());
        this.setContratoRegistroAlteracao(contratoSocialToMerge.getContratoRegistroAlteracao());
        this.setContratoAverbacaoAlteracao(contratoSocialToMerge.getContratoAverbacaoAlteracao());
        this.setContratoDataAlteracao(contratoSocialToMerge.getContratoDataAlteracao());
        this.setCapitalSocial(contratoSocialToMerge.getCapitalSocial());
        this.setValorCotas(contratoSocialToMerge.getValorCotas());
        this.setUsuario(SecurityUtils.getUserAise());
        this.setNumeroAlteracao(contratoSocialToMerge.getNumeroAlteracao());
        this.setNumeroJuntaComercial(contratoSocialToMerge.getNumeroJuntaComercial());
        this.setDataRegistroJuntaComercial(contratoSocialToMerge.getDataRegistroJuntaComercial());
        this.setObservacaoDescricaoAlteracao(contratoSocialToMerge.getObservacaoDescricaoAlteracao());
        this.mergePessoas(contratoSocialToMerge);
        return this;
    }

    private void mergePessoas(ContratoSocial contratoSocial) {
        List merged = ListUtils.merge((List)this.getPessoas(), (List)contratoSocial.getPessoas(), ContratoSocialPessoa::getId, ContratoSocialPessoa::merge);
        this.getPessoas().clear();
        this.getPessoas().addAll(merged);
    }

    @Generated
    public ContratoSocial() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CadastroMobiliario getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public TipoCapitalSocial getTipoCapitalSocial() {
        return this.tipoCapitalSocial;
    }

    @Generated
    public TipoRegistroMercantil getTipoRegistroMercantil() {
        return this.tipoRegistroMercantil;
    }

    @Generated
    public String getContratoCartorioAlteracao() {
        return this.contratoCartorioAlteracao;
    }

    @Generated
    public String getContratoRegistroAlteracao() {
        return this.contratoRegistroAlteracao;
    }

    @Generated
    public String getContratoAverbacaoAlteracao() {
        return this.contratoAverbacaoAlteracao;
    }

    @Generated
    public LocalDate getContratoDataAlteracao() {
        return this.contratoDataAlteracao;
    }

    @Generated
    public BigDecimal getCapitalSocial() {
        return this.capitalSocial;
    }

    @Generated
    public BigDecimal getValorCotas() {
        return this.valorCotas;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getNumeroAlteracao() {
        return this.numeroAlteracao;
    }

    @Generated
    public String getNumeroJuntaComercial() {
        return this.numeroJuntaComercial;
    }

    @Generated
    public LocalDate getDataRegistroJuntaComercial() {
        return this.dataRegistroJuntaComercial;
    }

    @Generated
    public String getObservacaoDescricaoAlteracao() {
        return this.observacaoDescricaoAlteracao;
    }

    @Generated
    public List<ContratoSocialPessoa> getPessoas() {
        return this.pessoas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTipoCapitalSocial(TipoCapitalSocial tipoCapitalSocial) {
        this.tipoCapitalSocial = tipoCapitalSocial;
    }

    @Generated
    public void setTipoRegistroMercantil(TipoRegistroMercantil tipoRegistroMercantil) {
        this.tipoRegistroMercantil = tipoRegistroMercantil;
    }

    @Generated
    public void setContratoCartorioAlteracao(String contratoCartorioAlteracao) {
        this.contratoCartorioAlteracao = contratoCartorioAlteracao;
    }

    @Generated
    public void setContratoRegistroAlteracao(String contratoRegistroAlteracao) {
        this.contratoRegistroAlteracao = contratoRegistroAlteracao;
    }

    @Generated
    public void setContratoAverbacaoAlteracao(String contratoAverbacaoAlteracao) {
        this.contratoAverbacaoAlteracao = contratoAverbacaoAlteracao;
    }

    @Generated
    public void setContratoDataAlteracao(LocalDate contratoDataAlteracao) {
        this.contratoDataAlteracao = contratoDataAlteracao;
    }

    @Generated
    public void setCapitalSocial(BigDecimal capitalSocial) {
        this.capitalSocial = capitalSocial;
    }

    @Generated
    public void setValorCotas(BigDecimal valorCotas) {
        this.valorCotas = valorCotas;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setNumeroAlteracao(Long numeroAlteracao) {
        this.numeroAlteracao = numeroAlteracao;
    }

    @Generated
    public void setNumeroJuntaComercial(String numeroJuntaComercial) {
        this.numeroJuntaComercial = numeroJuntaComercial;
    }

    @Generated
    public void setDataRegistroJuntaComercial(LocalDate dataRegistroJuntaComercial) {
        this.dataRegistroJuntaComercial = dataRegistroJuntaComercial;
    }

    @Generated
    public void setObservacaoDescricaoAlteracao(String observacaoDescricaoAlteracao) {
        this.observacaoDescricaoAlteracao = observacaoDescricaoAlteracao;
    }

    @Generated
    public String toString() {
        return "ContratoSocial(id=" + this.getId() + ", cadastroMobiliario=" + String.valueOf(this.getCadastroMobiliario()) + ", sequencia=" + this.getSequencia() + ", tipoCapitalSocial=" + String.valueOf(this.getTipoCapitalSocial()) + ", tipoRegistroMercantil=" + String.valueOf(this.getTipoRegistroMercantil()) + ", contratoCartorioAlteracao=" + this.getContratoCartorioAlteracao() + ", contratoRegistroAlteracao=" + this.getContratoRegistroAlteracao() + ", contratoAverbacaoAlteracao=" + this.getContratoAverbacaoAlteracao() + ", contratoDataAlteracao=" + String.valueOf(this.getContratoDataAlteracao()) + ", capitalSocial=" + String.valueOf(this.getCapitalSocial()) + ", valorCotas=" + String.valueOf(this.getValorCotas()) + ", usuario=" + this.getUsuario() + ", numeroAlteracao=" + this.getNumeroAlteracao() + ", numeroJuntaComercial=" + this.getNumeroJuntaComercial() + ", dataRegistroJuntaComercial=" + String.valueOf(this.getDataRegistroJuntaComercial()) + ", observacaoDescricaoAlteracao=" + this.getObservacaoDescricaoAlteracao() + ", pessoas=" + String.valueOf(this.getPessoas()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContratoSocial)) {
            return false;
        }
        ContratoSocial other = (ContratoSocial)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$numeroAlteracao = this.getNumeroAlteracao();
        Long other$numeroAlteracao = other.getNumeroAlteracao();
        if (this$numeroAlteracao == null ? other$numeroAlteracao != null : !((Object)this$numeroAlteracao).equals(other$numeroAlteracao)) {
            return false;
        }
        CadastroMobiliario this$cadastroMobiliario = this.getCadastroMobiliario();
        CadastroMobiliario other$cadastroMobiliario = other.getCadastroMobiliario();
        if (this$cadastroMobiliario == null ? other$cadastroMobiliario != null : !this$cadastroMobiliario.equals(other$cadastroMobiliario)) {
            return false;
        }
        TipoCapitalSocial this$tipoCapitalSocial = this.getTipoCapitalSocial();
        TipoCapitalSocial other$tipoCapitalSocial = other.getTipoCapitalSocial();
        if (this$tipoCapitalSocial == null ? other$tipoCapitalSocial != null : !this$tipoCapitalSocial.equals(other$tipoCapitalSocial)) {
            return false;
        }
        TipoRegistroMercantil this$tipoRegistroMercantil = this.getTipoRegistroMercantil();
        TipoRegistroMercantil other$tipoRegistroMercantil = other.getTipoRegistroMercantil();
        if (this$tipoRegistroMercantil == null ? other$tipoRegistroMercantil != null : !this$tipoRegistroMercantil.equals(other$tipoRegistroMercantil)) {
            return false;
        }
        String this$contratoCartorioAlteracao = this.getContratoCartorioAlteracao();
        String other$contratoCartorioAlteracao = other.getContratoCartorioAlteracao();
        if (this$contratoCartorioAlteracao == null ? other$contratoCartorioAlteracao != null : !this$contratoCartorioAlteracao.equals(other$contratoCartorioAlteracao)) {
            return false;
        }
        String this$contratoRegistroAlteracao = this.getContratoRegistroAlteracao();
        String other$contratoRegistroAlteracao = other.getContratoRegistroAlteracao();
        if (this$contratoRegistroAlteracao == null ? other$contratoRegistroAlteracao != null : !this$contratoRegistroAlteracao.equals(other$contratoRegistroAlteracao)) {
            return false;
        }
        String this$contratoAverbacaoAlteracao = this.getContratoAverbacaoAlteracao();
        String other$contratoAverbacaoAlteracao = other.getContratoAverbacaoAlteracao();
        if (this$contratoAverbacaoAlteracao == null ? other$contratoAverbacaoAlteracao != null : !this$contratoAverbacaoAlteracao.equals(other$contratoAverbacaoAlteracao)) {
            return false;
        }
        LocalDate this$contratoDataAlteracao = this.getContratoDataAlteracao();
        LocalDate other$contratoDataAlteracao = other.getContratoDataAlteracao();
        if (this$contratoDataAlteracao == null ? other$contratoDataAlteracao != null : !((Object)this$contratoDataAlteracao).equals(other$contratoDataAlteracao)) {
            return false;
        }
        BigDecimal this$capitalSocial = this.getCapitalSocial();
        BigDecimal other$capitalSocial = other.getCapitalSocial();
        if (this$capitalSocial == null ? other$capitalSocial != null : !((Object)this$capitalSocial).equals(other$capitalSocial)) {
            return false;
        }
        BigDecimal this$valorCotas = this.getValorCotas();
        BigDecimal other$valorCotas = other.getValorCotas();
        if (this$valorCotas == null ? other$valorCotas != null : !((Object)this$valorCotas).equals(other$valorCotas)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        String this$numeroJuntaComercial = this.getNumeroJuntaComercial();
        String other$numeroJuntaComercial = other.getNumeroJuntaComercial();
        if (this$numeroJuntaComercial == null ? other$numeroJuntaComercial != null : !this$numeroJuntaComercial.equals(other$numeroJuntaComercial)) {
            return false;
        }
        LocalDate this$dataRegistroJuntaComercial = this.getDataRegistroJuntaComercial();
        LocalDate other$dataRegistroJuntaComercial = other.getDataRegistroJuntaComercial();
        if (this$dataRegistroJuntaComercial == null ? other$dataRegistroJuntaComercial != null : !((Object)this$dataRegistroJuntaComercial).equals(other$dataRegistroJuntaComercial)) {
            return false;
        }
        String this$observacaoDescricaoAlteracao = this.getObservacaoDescricaoAlteracao();
        String other$observacaoDescricaoAlteracao = other.getObservacaoDescricaoAlteracao();
        return !(this$observacaoDescricaoAlteracao == null ? other$observacaoDescricaoAlteracao != null : !this$observacaoDescricaoAlteracao.equals(other$observacaoDescricaoAlteracao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContratoSocial;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $numeroAlteracao = this.getNumeroAlteracao();
        result = result * 59 + ($numeroAlteracao == null ? 43 : ((Object)$numeroAlteracao).hashCode());
        CadastroMobiliario $cadastroMobiliario = this.getCadastroMobiliario();
        result = result * 59 + ($cadastroMobiliario == null ? 43 : $cadastroMobiliario.hashCode());
        TipoCapitalSocial $tipoCapitalSocial = this.getTipoCapitalSocial();
        result = result * 59 + ($tipoCapitalSocial == null ? 43 : $tipoCapitalSocial.hashCode());
        TipoRegistroMercantil $tipoRegistroMercantil = this.getTipoRegistroMercantil();
        result = result * 59 + ($tipoRegistroMercantil == null ? 43 : $tipoRegistroMercantil.hashCode());
        String $contratoCartorioAlteracao = this.getContratoCartorioAlteracao();
        result = result * 59 + ($contratoCartorioAlteracao == null ? 43 : $contratoCartorioAlteracao.hashCode());
        String $contratoRegistroAlteracao = this.getContratoRegistroAlteracao();
        result = result * 59 + ($contratoRegistroAlteracao == null ? 43 : $contratoRegistroAlteracao.hashCode());
        String $contratoAverbacaoAlteracao = this.getContratoAverbacaoAlteracao();
        result = result * 59 + ($contratoAverbacaoAlteracao == null ? 43 : $contratoAverbacaoAlteracao.hashCode());
        LocalDate $contratoDataAlteracao = this.getContratoDataAlteracao();
        result = result * 59 + ($contratoDataAlteracao == null ? 43 : ((Object)$contratoDataAlteracao).hashCode());
        BigDecimal $capitalSocial = this.getCapitalSocial();
        result = result * 59 + ($capitalSocial == null ? 43 : ((Object)$capitalSocial).hashCode());
        BigDecimal $valorCotas = this.getValorCotas();
        result = result * 59 + ($valorCotas == null ? 43 : ((Object)$valorCotas).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        String $numeroJuntaComercial = this.getNumeroJuntaComercial();
        result = result * 59 + ($numeroJuntaComercial == null ? 43 : $numeroJuntaComercial.hashCode());
        LocalDate $dataRegistroJuntaComercial = this.getDataRegistroJuntaComercial();
        result = result * 59 + ($dataRegistroJuntaComercial == null ? 43 : ((Object)$dataRegistroJuntaComercial).hashCode());
        String $observacaoDescricaoAlteracao = this.getObservacaoDescricaoAlteracao();
        result = result * 59 + ($observacaoDescricaoAlteracao == null ? 43 : $observacaoDescricaoAlteracao.hashCode());
        return result;
    }
}

