/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Servico;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.CadastroMobiliarioServicoDTO;
import br.com.elotech.tributos.dto.ServicoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBMOBILIARIOSERVICO")
public class CadastroMobiliarioServico
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBMOBILIARIOSERVICO_ID")
    private Long id;
    @ManyToOne
    @JoinColumn(name="TRIBSERVICO_IDKEY")
    private Servico servico;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Gerar Lan\u00e7amento")
    private Boolean gerarLancamento = Boolean.TRUE;
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tribcadastromobiliario_idkey", referencedColumnName="TRIBCADASTROGERAL_IDKEY")
    private CadastroMobiliario cadastroMobiliario;

    public static CadastroMobiliarioServico from(CadastroMobiliarioServicoDTO dto, CadastroMobiliario cadastroMobiliario) {
        CadastroMobiliarioServico cadastroMobiliarioServico = new CadastroMobiliarioServico();
        cadastroMobiliarioServico.setId(dto.getId());
        cadastroMobiliarioServico.setServico(Servico.from((ServicoDTO)dto.getServico()));
        cadastroMobiliarioServico.setPrincipal(dto.getPrincipal());
        cadastroMobiliarioServico.setGerarLancamento(dto.getGerarLancamento());
        cadastroMobiliarioServico.setCadastroMobiliario(cadastroMobiliario);
        return cadastroMobiliarioServico;
    }

    public CadastroMobiliarioServico merge(CadastroMobiliarioServico cadastroMobiliarioServicoToMerge) {
        this.setGerarLancamento(cadastroMobiliarioServicoToMerge.getGerarLancamento());
        return this;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioServico(id=" + this.getId() + ", servico=" + String.valueOf(this.getServico()) + ", principal=" + this.getPrincipal() + ", gerarLancamento=" + this.getGerarLancamento() + ", cadastroMobiliario=" + String.valueOf(this.getCadastroMobiliario()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioServico)) {
            return false;
        }
        CadastroMobiliarioServico other = (CadastroMobiliarioServico)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioServico;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public CadastroMobiliarioServico() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Servico getServico() {
        return this.servico;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public Boolean getGerarLancamento() {
        return this.gerarLancamento;
    }

    @Generated
    public CadastroMobiliario getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setServico(Servico servico) {
        this.servico = servico;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setGerarLancamento(Boolean gerarLancamento) {
        this.gerarLancamento = gerarLancamento;
    }

    @JsonIgnore
    @Generated
    public void setCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }
}

