/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.ProfissionalEdicaoEmMassaDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="TRIBMOBILIARIOPROFISSIONAL")
@Audited
public class CadastroMobiliarioProfissional
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBMOBILIARIOPROFISSIONAL_I")
    private Long id;
    @ManyToOne
    @JoinColumn(name="tribcadastromobiliario_idkey", referencedColumnName="TRIBCADASTROGERAL_IDKEY")
    @JsonIgnore
    private CadastroMobiliario cadastroMobiliario;
    @ManyToOne
    @JsonIgnore
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JoinColumn(name="pessoa", referencedColumnName="pessoa", insertable=false, updatable=false)
    private Pessoa pessoa;
    @Column(name="pessoa")
    private Long profissional;
    @Column(name="cbo")
    private Long cbo;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    @Transient
    private Boolean toRemove = Boolean.FALSE;

    public static CadastroMobiliarioProfissional from(CadastroMobiliario mobiliario, Long profissional, Long cbo) {
        CadastroMobiliarioProfissional entity = new CadastroMobiliarioProfissional();
        entity.setCadastroMobiliario(mobiliario);
        entity.setProfissional(profissional);
        entity.setTipoCadastro(mobiliario.getTipoCadastro());
        entity.setCadastroGeral(mobiliario.getCadastroGeral());
        entity.setCbo(cbo);
        return entity;
    }

    public Boolean toRemove() {
        return this.toRemove;
    }

    public Boolean toSave() {
        return this.toRemove == false;
    }

    public void merge(CadastroMobiliarioProfissional cadastroMobiliarioProfissional) {
        this.setProfissional(cadastroMobiliarioProfissional.getProfissional());
        this.setCbo(cadastroMobiliarioProfissional.getCbo());
        this.setCadastroMobiliario(cadastroMobiliarioProfissional.getCadastroMobiliario());
        this.setTipoCadastro(cadastroMobiliarioProfissional.getTipoCadastro());
        this.setCadastroGeral(cadastroMobiliarioProfissional.getCadastroGeral());
    }

    public boolean dontExistIn(Map<Long, List<Long>> profissionaisParaManter) {
        return profissionaisParaManter.get(this.cadastroMobiliario.getId()).stream().noneMatch(ppm -> Objects.equals(ppm, this.profissional));
    }

    public ProfissionalEdicaoEmMassaDTO toProfissionalEdicaoEmMassaDTO() {
        ProfissionalEdicaoEmMassaDTO dto = new ProfissionalEdicaoEmMassaDTO();
        dto.setIdCadastro(this.cadastroMobiliario.getId());
        dto.setIdPessoa(this.profissional);
        dto.setNome(this.pessoa.getNome());
        return dto;
    }

    @Generated
    public CadastroMobiliarioProfissional() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CadastroMobiliario getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getProfissional() {
        return this.profissional;
    }

    @Generated
    public Long getCbo() {
        return this.cbo;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Boolean getToRemove() {
        return this.toRemove;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    @JsonIgnore
    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setProfissional(Long profissional) {
        this.profissional = profissional;
    }

    @Generated
    public void setCbo(Long cbo) {
        this.cbo = cbo;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setToRemove(Boolean toRemove) {
        this.toRemove = toRemove;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioProfissional(id=" + this.getId() + ", cadastroMobiliario=" + String.valueOf(this.getCadastroMobiliario()) + ", pessoa=" + String.valueOf(this.getPessoa()) + ", profissional=" + this.getProfissional() + ", cbo=" + this.getCbo() + ", tipoCadastro=" + String.valueOf(this.getTipoCadastro()) + ", cadastroGeral=" + this.getCadastroGeral() + ", toRemove=" + this.getToRemove() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioProfissional)) {
            return false;
        }
        CadastroMobiliarioProfissional other = (CadastroMobiliarioProfissional)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioProfissional;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

