/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.memoria;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Eixo;
import br.com.elotech.tributos.domain.Zoneamento;
import br.com.elotech.tributos.domain.memoria.CadastroImobiliarioMemoria;
import br.com.elotech.tributos.domain.memoria.ImobiliarioTestadaMemoriaId;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribimobiliariotestadamemoria")
public class ImobiliarioTestadaMemoria
implements EloEntity<ImobiliarioTestadaMemoriaId> {
    @EmbeddedId
    private ImobiliarioTestadaMemoriaId id;
    @Caption(value="Tamanho da Testada")
    private BigDecimal tamanhoTestada = BigDecimal.ZERO;
    @Caption(value="Tamanho Adicional")
    private BigDecimal tamanhoAdicional = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @Column(length=10)
    @Caption(value="N\u00famero")
    private String numero;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Utiliza Para C\u00e1lculo")
    private Boolean utilizaParaCalculo = Boolean.TRUE;
    @ManyToOne
    @JoinColumn(name="idzoneamento", referencedColumnName="idzoneamento")
    @Caption(value="Zoneamento")
    private Zoneamento zoneamento;
    @ManyToOne
    @JoinColumn(name="ideixo", referencedColumnName="ideixo")
    @Caption(value="Eixo")
    private Eixo eixo;
    @Caption(value="Tamanho Guia Rebaixada")
    private BigDecimal tamanhoGuiaRebaixada = BigDecimal.ZERO;
    @Caption(value="Guias Rebaixadas")
    private Long guiasRebaixadas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idmemoriacadastro", referencedColumnName="idmemoriacadastro", insertable=false, updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", insertable=false, updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", insertable=false, updatable=false)})
    private CadastroImobiliarioMemoria cadastroImobiliarioMemoria;

    public void merge(ImobiliarioTestadaMemoria testada) {
        this.tamanhoTestada = testada.getTamanhoTestada();
        this.tamanhoAdicional = testada.getTamanhoAdicional();
        this.principal = testada.getPrincipal();
        this.numero = testada.getNumero();
        this.utilizaParaCalculo = testada.getUtilizaParaCalculo();
        this.eixo = testada.getEixo();
        this.zoneamento = testada.getZoneamento();
    }

    @Generated
    public ImobiliarioTestadaMemoria() {
    }

    @Generated
    public ImobiliarioTestadaMemoriaId getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getTamanhoTestada() {
        return this.tamanhoTestada;
    }

    @Generated
    public BigDecimal getTamanhoAdicional() {
        return this.tamanhoAdicional;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public Boolean getUtilizaParaCalculo() {
        return this.utilizaParaCalculo;
    }

    @Generated
    public Zoneamento getZoneamento() {
        return this.zoneamento;
    }

    @Generated
    public Eixo getEixo() {
        return this.eixo;
    }

    @Generated
    public BigDecimal getTamanhoGuiaRebaixada() {
        return this.tamanhoGuiaRebaixada;
    }

    @Generated
    public Long getGuiasRebaixadas() {
        return this.guiasRebaixadas;
    }

    @Generated
    public CadastroImobiliarioMemoria getCadastroImobiliarioMemoria() {
        return this.cadastroImobiliarioMemoria;
    }

    @Generated
    public void setId(ImobiliarioTestadaMemoriaId id) {
        this.id = id;
    }

    @Generated
    public void setTamanhoTestada(BigDecimal tamanhoTestada) {
        this.tamanhoTestada = tamanhoTestada;
    }

    @Generated
    public void setTamanhoAdicional(BigDecimal tamanhoAdicional) {
        this.tamanhoAdicional = tamanhoAdicional;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setUtilizaParaCalculo(Boolean utilizaParaCalculo) {
        this.utilizaParaCalculo = utilizaParaCalculo;
    }

    @Generated
    public void setZoneamento(Zoneamento zoneamento) {
        this.zoneamento = zoneamento;
    }

    @Generated
    public void setEixo(Eixo eixo) {
        this.eixo = eixo;
    }

    @Generated
    public void setTamanhoGuiaRebaixada(BigDecimal tamanhoGuiaRebaixada) {
        this.tamanhoGuiaRebaixada = tamanhoGuiaRebaixada;
    }

    @Generated
    public void setGuiasRebaixadas(Long guiasRebaixadas) {
        this.guiasRebaixadas = guiasRebaixadas;
    }

    @Generated
    public void setCadastroImobiliarioMemoria(CadastroImobiliarioMemoria cadastroImobiliarioMemoria) {
        this.cadastroImobiliarioMemoria = cadastroImobiliarioMemoria;
    }

    @Generated
    public String toString() {
        return "ImobiliarioTestadaMemoria(id=" + String.valueOf(this.getId()) + ", tamanhoTestada=" + String.valueOf(this.getTamanhoTestada()) + ", tamanhoAdicional=" + String.valueOf(this.getTamanhoAdicional()) + ", principal=" + this.getPrincipal() + ", numero=" + this.getNumero() + ", utilizaParaCalculo=" + this.getUtilizaParaCalculo() + ", zoneamento=" + String.valueOf(this.getZoneamento()) + ", eixo=" + String.valueOf(this.getEixo()) + ", tamanhoGuiaRebaixada=" + String.valueOf(this.getTamanhoGuiaRebaixada()) + ", guiasRebaixadas=" + this.getGuiasRebaixadas() + ", cadastroImobiliarioMemoria=" + String.valueOf(this.getCadastroImobiliarioMemoria()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImobiliarioTestadaMemoria)) {
            return false;
        }
        ImobiliarioTestadaMemoria other = (ImobiliarioTestadaMemoria)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ImobiliarioTestadaMemoriaId this$id = this.getId();
        ImobiliarioTestadaMemoriaId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImobiliarioTestadaMemoria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImobiliarioTestadaMemoriaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

