/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.memoria;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Eixo;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.memoria.CadastroImobiliarioMemoria;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBIMOBILIARIOTESTADAGENMEM")
public class ImobiliarioTestadaGenericaMemoria
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOTESTADAGENMEM")
    private Long id;
    private Long idMemoriaCadastro;
    private Long tipoCadastro;
    private Long cadastroGeral;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="cidade", referencedColumnName="cidade"), @JoinColumn(name="logradouro", referencedColumnName="logradouro")})
    @Caption(value="Logradouro")
    private Logradouro logradouro;
    @Caption(value="Tamanho")
    private BigDecimal tamanho = BigDecimal.ZERO;
    @Caption(value="Profundidade")
    private BigDecimal profundidade = BigDecimal.ZERO;
    @Column(length=10)
    @Caption(value="Face")
    private String face;
    @Caption(value="Valor do metro quadrado")
    private BigDecimal valorM2 = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="IDEIXO")
    @Caption(value="Eixo")
    private Eixo eixo;
    @Column(length=10)
    @Caption(value="N\u00famero")
    private String numero;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idmemoriacadastro", referencedColumnName="idmemoriacadastro", insertable=false, updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", insertable=false, updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", insertable=false, updatable=false)})
    private CadastroImobiliarioMemoria cadastroImobiliarioMemoria;

    public void merge(ImobiliarioTestadaGenericaMemoria testadaGenerica) {
        this.logradouro = testadaGenerica.getLogradouro();
        this.tamanho = testadaGenerica.getTamanho();
        this.profundidade = testadaGenerica.getProfundidade();
        this.face = testadaGenerica.getFace();
        this.valorM2 = testadaGenerica.getValorM2();
        this.principal = testadaGenerica.getPrincipal();
        this.eixo = testadaGenerica.getEixo();
        this.numero = testadaGenerica.getNumero();
    }

    @Generated
    public String toString() {
        return "ImobiliarioTestadaGenericaMemoria(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImobiliarioTestadaGenericaMemoria)) {
            return false;
        }
        ImobiliarioTestadaGenericaMemoria other = (ImobiliarioTestadaGenericaMemoria)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImobiliarioTestadaGenericaMemoria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public ImobiliarioTestadaGenericaMemoria() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdMemoriaCadastro() {
        return this.idMemoriaCadastro;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public BigDecimal getTamanho() {
        return this.tamanho;
    }

    @Generated
    public BigDecimal getProfundidade() {
        return this.profundidade;
    }

    @Generated
    public String getFace() {
        return this.face;
    }

    @Generated
    public BigDecimal getValorM2() {
        return this.valorM2;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public Eixo getEixo() {
        return this.eixo;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public CadastroImobiliarioMemoria getCadastroImobiliarioMemoria() {
        return this.cadastroImobiliarioMemoria;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdMemoriaCadastro(Long idMemoriaCadastro) {
        this.idMemoriaCadastro = idMemoriaCadastro;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setTamanho(BigDecimal tamanho) {
        this.tamanho = tamanho;
    }

    @Generated
    public void setProfundidade(BigDecimal profundidade) {
        this.profundidade = profundidade;
    }

    @Generated
    public void setFace(String face) {
        this.face = face;
    }

    @Generated
    public void setValorM2(BigDecimal valorM2) {
        this.valorM2 = valorM2;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setEixo(Eixo eixo) {
        this.eixo = eixo;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setCadastroImobiliarioMemoria(CadastroImobiliarioMemoria cadastroImobiliarioMemoria) {
        this.cadastroImobiliarioMemoria = cadastroImobiliarioMemoria;
    }
}

