/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.integracoes;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribintegracaotoken")
public class IntegracaoToken
implements EloEntity<Long> {
    @Id
    @EloSequence
    @Column(name="id")
    private Long id;
    @Column(name="banco")
    private Long banco;
    @Column(name="operation")
    @Enumerated(value=EnumType.STRING)
    private IntegracaoTokenOperation operation;
    @Column(name="valor")
    private String valor;
    @Column(name="expiracao")
    private LocalDateTime expiracao;
    @Column(name="valorRefreshToken")
    private String valorRefreshToken;
    @Column(name="expiracaoRefreshToken")
    private LocalDateTime expiracaoRefreshToken;

    public boolean isValid() {
        LocalDateTime now = LocalDateTime.now();
        return now.isBefore(this.expiracao);
    }

    public boolean isValidRefreshToken() {
        LocalDateTime now = LocalDateTime.now();
        return now.isBefore(this.expiracaoRefreshToken);
    }

    public void setExpiracaoRefreshToken(String seconds) {
        this.expiracaoRefreshToken = Instant.ofEpochSecond(Long.parseLong(seconds)).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void setExpiracaoRefreshToken(LocalDateTime expiracaoRefreshToken) {
        this.expiracaoRefreshToken = expiracaoRefreshToken;
    }

    public void setExpiracao(String seconds) {
        this.expiracao = Instant.ofEpochSecond(Long.parseLong(seconds)).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void setExpiracao(LocalDateTime localDateTime) {
        this.expiracao = localDateTime;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getBanco() {
        return this.banco;
    }

    @Generated
    public IntegracaoTokenOperation getOperation() {
        return this.operation;
    }

    @Generated
    public String getValor() {
        return this.valor;
    }

    @Generated
    public LocalDateTime getExpiracao() {
        return this.expiracao;
    }

    @Generated
    public String getValorRefreshToken() {
        return this.valorRefreshToken;
    }

    @Generated
    public LocalDateTime getExpiracaoRefreshToken() {
        return this.expiracaoRefreshToken;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setBanco(Long banco) {
        this.banco = banco;
    }

    @Generated
    public void setOperation(IntegracaoTokenOperation operation) {
        this.operation = operation;
    }

    @Generated
    public void setValor(String valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorRefreshToken(String valorRefreshToken) {
        this.valorRefreshToken = valorRefreshToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegracaoToken)) {
            return false;
        }
        IntegracaoToken other = (IntegracaoToken)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$banco = this.getBanco();
        Long other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !((Object)this$banco).equals(other$banco)) {
            return false;
        }
        IntegracaoTokenOperation this$operation = this.getOperation();
        IntegracaoTokenOperation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        String this$valor = this.getValor();
        String other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !this$valor.equals(other$valor)) {
            return false;
        }
        LocalDateTime this$expiracao = this.getExpiracao();
        LocalDateTime other$expiracao = other.getExpiracao();
        if (this$expiracao == null ? other$expiracao != null : !((Object)this$expiracao).equals(other$expiracao)) {
            return false;
        }
        String this$valorRefreshToken = this.getValorRefreshToken();
        String other$valorRefreshToken = other.getValorRefreshToken();
        if (this$valorRefreshToken == null ? other$valorRefreshToken != null : !this$valorRefreshToken.equals(other$valorRefreshToken)) {
            return false;
        }
        LocalDateTime this$expiracaoRefreshToken = this.getExpiracaoRefreshToken();
        LocalDateTime other$expiracaoRefreshToken = other.getExpiracaoRefreshToken();
        return !(this$expiracaoRefreshToken == null ? other$expiracaoRefreshToken != null : !((Object)this$expiracaoRefreshToken).equals(other$expiracaoRefreshToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegracaoToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : ((Object)$banco).hashCode());
        IntegracaoTokenOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        String $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        LocalDateTime $expiracao = this.getExpiracao();
        result = result * 59 + ($expiracao == null ? 43 : ((Object)$expiracao).hashCode());
        String $valorRefreshToken = this.getValorRefreshToken();
        result = result * 59 + ($valorRefreshToken == null ? 43 : $valorRefreshToken.hashCode());
        LocalDateTime $expiracaoRefreshToken = this.getExpiracaoRefreshToken();
        result = result * 59 + ($expiracaoRefreshToken == null ? 43 : ((Object)$expiracaoRefreshToken).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntegracaoToken(id=" + this.getId() + ", banco=" + this.getBanco() + ", operation=" + String.valueOf(this.getOperation()) + ", valor=" + this.getValor() + ", expiracao=" + String.valueOf(this.getExpiracao()) + ", valorRefreshToken=" + this.getValorRefreshToken() + ", expiracaoRefreshToken=" + String.valueOf(this.getExpiracaoRefreshToken()) + ")";
    }

    @Generated
    public IntegracaoToken(Long id, Long banco, IntegracaoTokenOperation operation, String valor, LocalDateTime expiracao, String valorRefreshToken, LocalDateTime expiracaoRefreshToken) {
        this.id = id;
        this.banco = banco;
        this.operation = operation;
        this.valor = valor;
        this.expiracao = expiracao;
        this.valorRefreshToken = valorRefreshToken;
        this.expiracaoRefreshToken = expiracaoRefreshToken;
    }

    @Generated
    public IntegracaoToken() {
    }
}

