/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnoreProperties;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Eixo;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenericaExercicio;
import br.com.elotech.tributos.util.HibernateSearchDummyStringBridge;
import br.com.elotech.tributos.util.ListUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBIMOBILIARIOTESTADAGENERICA")
@Audited
@AuditTable(value="TRIBIMOBTESTADAGENERICA_AUD")
public class CadastroImobiliarioTestadaGenerica
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOTESTADAGENERI")
    private Long id;
    @Caption(value="C\u00f3digo da Testada Gen\u00e9rica")
    private Long codigoTestadaGenerica;
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="LOGRADOURO_IDKEY")
    @Caption(value="Logradouro")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DiffRevisionIgnoreProperties(value={"id", "descLogradouroInicio", "inativo", "descricaoAnterior", "logradouroInicio", "dataCriacao", "programa", "usuario", "idUnico"})
    private Logradouro logradouro;
    @Caption(value="Tamanho")
    private BigDecimal tamanho = BigDecimal.ZERO;
    @Caption(value="Profundidade")
    private BigDecimal profundidade = BigDecimal.ZERO;
    @Column(length=10)
    @Caption(value="Face")
    private String face;
    @Caption(value="Valor do metro quadrado")
    private BigDecimal valorM2 = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="IDEIXO")
    @Caption(value="Eixo")
    private Eixo eixo;
    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco_index")), @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco_query"), bridge=@FieldBridge(impl=HibernateSearchDummyStringBridge.class)), @Field(name="numero_sort", analyze=Analyze.NO)})
    @SortableField(forField="numero_sort")
    @Column(length=10)
    @Caption(value="N\u00famero")
    private String numero;
    @NotAudited
    @Caption(value="Valores por Exerc\u00edcio")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="testadagenerica_idkey", referencedColumnName="idkey", updatable=false, nullable=false)
    @OrderBy(value="exercicio DESC, id DESC")
    private List<CadastroImobiliarioTestadaGenericaExercicio> exercicios = new ArrayList();

    public BigDecimal getValorM2ByExercicio() {
        return this.getValorM2ByExercicio(Long.valueOf(LocalDate.now().getYear()));
    }

    public BigDecimal getValorM2ByExercicio(Long exercicio) {
        if (!this.exercicios.isEmpty()) {
            return this.exercicios.stream().filter(ex -> ex.getExercicio().compareTo(exercicio) == 0).map(CadastroImobiliarioTestadaGenericaExercicio::getValorM2).findFirst().orElse(BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }

    public void merge(CadastroImobiliarioTestadaGenerica testadaGenerica) {
        this.codigoTestadaGenerica = testadaGenerica.getCodigoTestadaGenerica();
        this.logradouro = testadaGenerica.getLogradouro();
        this.tamanho = testadaGenerica.getTamanho();
        this.profundidade = testadaGenerica.getProfundidade();
        this.face = testadaGenerica.getFace();
        this.valorM2 = testadaGenerica.getValorM2();
        this.principal = testadaGenerica.getPrincipal();
        this.eixo = testadaGenerica.getEixo();
        this.numero = testadaGenerica.getNumero();
        this.mergeExercicios(this.exercicios);
    }

    private void updateReferenciaExercicios() {
        this.exercicios.forEach(ex -> {
            if (Objects.isNull(ex.getTestadaGenerica())) {
                ex.setTestadaGenerica(this);
            }
        });
    }

    private CadastroImobiliarioTestadaGenerica mergeExercicios(List<CadastroImobiliarioTestadaGenericaExercicio> exercicios) {
        List respostasMerged = ListUtils.merge((List)this.exercicios, exercicios, CadastroImobiliarioTestadaGenericaExercicio::getId, CadastroImobiliarioTestadaGenericaExercicio::merge);
        this.getExercicios().clear();
        this.getExercicios().addAll(respostasMerged);
        this.updateReferenciaExercicios();
        return this;
    }

    public CadastroImobiliarioTestadaGenerica copy() {
        return this.copyIgnoringProperties(new String[]{"id", "exercicios"});
    }

    private void addExercicio(CadastroImobiliarioTestadaGenericaExercicio exercicio) {
        exercicio.setTestadaGenerica(this);
        this.exercicios.add(exercicio);
    }

    public CadastroImobiliarioTestadaGenerica copyIgnoringProperties(String ... ignoreProperties) {
        CadastroImobiliarioTestadaGenerica testadaGenerica = new CadastroImobiliarioTestadaGenerica();
        BeanUtils.copyProperties((Object)this, (Object)testadaGenerica, (String[])ignoreProperties);
        this.exercicios.stream().map(CadastroImobiliarioTestadaGenericaExercicio::copy).forEach(arg_0 -> testadaGenerica.addExercicio(arg_0));
        return testadaGenerica;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioTestadaGenerica(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioTestadaGenerica)) {
            return false;
        }
        CadastroImobiliarioTestadaGenerica other = (CadastroImobiliarioTestadaGenerica)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioTestadaGenerica;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public CadastroImobiliarioTestadaGenerica() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCodigoTestadaGenerica() {
        return this.codigoTestadaGenerica;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public BigDecimal getTamanho() {
        return this.tamanho;
    }

    @Generated
    public BigDecimal getProfundidade() {
        return this.profundidade;
    }

    @Generated
    public String getFace() {
        return this.face;
    }

    @Generated
    public BigDecimal getValorM2() {
        return this.valorM2;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public Eixo getEixo() {
        return this.eixo;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public List<CadastroImobiliarioTestadaGenericaExercicio> getExercicios() {
        return this.exercicios;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigoTestadaGenerica(Long codigoTestadaGenerica) {
        this.codigoTestadaGenerica = codigoTestadaGenerica;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setTamanho(BigDecimal tamanho) {
        this.tamanho = tamanho;
    }

    @Generated
    public void setProfundidade(BigDecimal profundidade) {
        this.profundidade = profundidade;
    }

    @Generated
    public void setFace(String face) {
        this.face = face;
    }

    @Generated
    public void setValorM2(BigDecimal valorM2) {
        this.valorM2 = valorM2;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setEixo(Eixo eixo) {
        this.eixo = eixo;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setExercicios(List<CadastroImobiliarioTestadaGenericaExercicio> exercicios) {
        this.exercicios = exercicios;
    }
}

