/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnore;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnoreProperties;
import br.com.elotech.core.metamodel.annotation.CalculatedModel;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralObservacao;
import br.com.elotech.tributos.domain.Condominio;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Eixo;
import br.com.elotech.tributos.domain.Imobiliaria;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.SituacaoImobiliario;
import br.com.elotech.tributos.domain.TipoImovel;
import br.com.elotech.tributos.domain.TipoLote;
import br.com.elotech.tributos.domain.Zoneamento;
import br.com.elotech.tributos.domain.camposdinamicos.DynamicValidation;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAreaVerde;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAvaliacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioDesapropriacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioEnglobado;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioGeminada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioProfundidade;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenerica;
import br.com.elotech.tributos.domain.sanepar.SaneparMatricula;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import br.com.elotech.tributos.hibernatesearch.bridge.BigDecimalToIntegerFieldBridge;
import br.com.elotech.tributos.hibernatesearch.bridge.BigDecimalToStringFieldBridge;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.DecimalMin;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.validator.constraints.Length;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

@Entity
@Indexed
@Table(name="TRIBCADASTROIMOBILIARIO")
@Audited
@PrimaryKeyJoinColumn(name="TRIBCADASTROGERAL_IDKEY")
@DynamicInsert
@DynamicUpdate
public class CadastroImobiliario
extends CadastroGeral {
    @Field(analyzer=@Analyzer(definition="consideraSomenteAlfaNumericos"))
    @Column(length=40)
    @Caption(value="Inscri\u00e7\u00e3o Cadastral")
    private String inscricaoCadastral;
    @Field(analyzer=@Analyzer(definition="consideraSomenteAlfaNumericos"))
    @Column(length=50)
    @Caption(value="Inscri\u00e7\u00e3o Cadastral Anterior")
    private String inscricaoCadastralAnterior;
    @Column(name="TRECHO_INSCRICAOCADASTRAL")
    @Caption(value="Trecho Inscri\u00e7\u00e3o Cadastral")
    private Long trechoInscricaoCadastral;
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="QUADRICULA_INSCRICAOCADASTRAL", referencedColumnName="QUADRICULA")
    @Caption(value="Quadr\u00edcula Inscri\u00e7\u00e3o Cadastral")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Quadricula quadriculaLocalizacao;
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="DISTRITO_INSCRICAOCADASTRAL", referencedColumnName="DISTRITO")
    @Caption(value="Distrito Inscri\u00e7\u00e3o Cadastral")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DiffRevisionIgnoreProperties(value={"setores", "id"})
    @JsonIgnore
    private Distrito distritoLocalizacao;
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="TRIBSETOR_IDKEY")
    @Caption(value="Setor Inscri\u00e7\u00e3o Cadastral")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JsonIgnoreProperties(value={"quadras"})
    @DiffRevisionIgnoreProperties(value={"id", "distrito", "quadras"})
    @JsonIgnore
    private Setor setorLocalizacao;
    @IndexedEmbedded
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="TRIBSETOR_IDKEY", referencedColumnName="TRIBSETOR_IDKEY")), @JoinColumnOrFormula(column=@JoinColumn(name="QUADRA_INSCRICAOCADASTRAL", referencedColumnName="QUADRA"))})
    @Caption(value="Quadra Inscri\u00e7\u00e3o Cadastral")
    @NotAudited
    @JsonIgnoreProperties(value={"setor"})
    @DiffRevisionIgnoreProperties(value={"id", "aprovada", "quadraFiscal", "codigoDistrito", "codigoSetor", "loteamento", "observacao"})
    @JsonIgnore
    private SetorQuadra quadraLocalizacao;
    @Column(length=20, name="LOTE_INSCRICAOCADASTRAL")
    @Caption(value="Lote Inscri\u00e7\u00e3o Cadastral")
    @Field(name="loteLocalizacao_sort", analyze=Analyze.NO)
    @SortableField(forField="loteLocalizacao_sort")
    private String loteLocalizacao;
    @Column(length=15, name="UNIDADE_INSCRICAOCADASTRAL")
    @Caption(value="Unidade Inscri\u00e7\u00e3o Cadastral")
    @Field(name="unidadeLocalizacao_sort", analyze=Analyze.NO)
    @SortableField(forField="unidadeLocalizacao_sort")
    private String unidadeLocalizacao;
    @Column(length=15, name="UNIDADE_DESCR")
    @Caption(value="Unidade Inscri\u00e7\u00e3o Cadastral")
    private String unidadeFiscalizacao;
    @Column(length=15, name="DISTRITO_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Distrito")
    private String distritoFiscalizacao;
    @Column(length=15, name="SETOR_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Setor")
    private String setorFiscalizacao;
    @Column(length=15, name="TRECHO_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Trecho")
    private String trechoDescr;
    @Column(length=15, name="QUADRA_DESCR")
    @Caption(value="Quadra Setor")
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao"))
    @SortableField(forField="quadraFiscalizacao")
    private String quadraFiscalizacao;
    @Column(length=50, name="LOTE_DESCR")
    @Caption(value="Lote Setor")
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao"))
    @SortableField(forField="loteFiscalizacao")
    private String loteFiscalizacao;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Imobili\u00e1ria")
    @DiffRevisionIgnoreProperties(value={"cadastroGeral", "cadastros", "ativo"})
    private Imobiliaria imobiliaria;
    @IndexedEmbedded
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JoinColumn(name="TRIBCONDOMINIO_IDKEY")
    @Caption(value="Condom\u00ednio")
    @DiffRevisionIgnoreProperties(value={"id", "setor", "quadra", "setorCodigo", "distritoCodigo", "tipoCondominio", "areaTerreno", "areaConstruida", "areaPrivativa", "areaComum", "numeroAndares", "numeroGaragem", "numeroSalas", "numeroAptos", "numeroUnidades", "ato", "logradouro", "numero", "observacao", "lote", "utilizacaoCondominio", "numeroAlvara", "anoConstrucao", "dataAprovacao", "numeroHabitese", "dataHabitese", "situacaoCondominio", "dataDesmembramento", "areaAlvara", "areaHabiteseTotal", "areaHabiteseParcial", "dataHabiteseParcial", "numeroHabiteseParcial", "quadricula"})
    private Condominio condominio;
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="TRIBLOTEAMENTO_IDKEY")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @JsonIgnoreProperties(value={"setor"})
    @Caption(value="Loteamento")
    @DiffRevisionIgnoreProperties(value={"id", "distrito", "setor", "loteador", "proprietario", "bairro", "apelido", "numeroLotes", "numeroQuadras", "areaLoteada", "ato", "areaSistemaViario", "gleba", "irregular", "dataInclusao", "dataAlteracao", "usuario"})
    private Loteamento loteamento;
    @Caption(value="Ano Al\u00edquota Progressiva")
    private Long anoAliquotaProgressiva;
    @DecimalMin(value="0", inclusive=false)
    @Fields(value={@Field(analyze=Analyze.NO), @Field(name="areaLoteValor", analyze=Analyze.NO, bridge=@FieldBridge(impl=BigDecimalToStringFieldBridge.class))})
    @FieldBridge(impl=BigDecimalToIntegerFieldBridge.class)
    @Facet(encoding=FacetEncodingType.LONG)
    @Caption(value="\u00c1rea do Lote")
    private @DecimalMin(value="0", inclusive=false) BigDecimal areaLote = BigDecimal.ZERO;
    @Caption(value="Profundidade M\u00e9dia")
    private BigDecimal profundidadeMedia = BigDecimal.ZERO;
    @Fields(value={@Field(analyze=Analyze.NO), @Field(name="areaTotalConstruidaValor", analyze=Analyze.NO, bridge=@FieldBridge(impl=BigDecimalToStringFieldBridge.class))})
    @FieldBridge(impl=BigDecimalToIntegerFieldBridge.class)
    @Facet(encoding=FacetEncodingType.LONG)
    @Caption(value="\u00c1rea Total Constru\u00edda")
    private BigDecimal areaTotalConstruida = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Limita Cerca Muro")
    private Boolean limitaCercaMuro = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Im\u00f3vel Pr\u00f3prio")
    private Boolean imovelProprio = Boolean.FALSE;
    @Field(analyzer=@Analyzer(definition="consideraSomenteAlfaNumericos"))
    @Column(length=15)
    @Caption(value="Matr\u00edcula")
    private String matricula;
    @Column(length=60)
    @Caption(value="Cart\u00f3rio")
    private String cartorio;
    @Column
    @Caption(value="Data da Matr\u00edcula")
    private LocalDate dataMatricula;
    @Column(length=15)
    @Caption(value="Livro")
    private String livro;
    @Column(length=15)
    @Caption(value="Folha")
    private String folha;
    @Column(length=15)
    @Caption(value="Face Quadra")
    private String faceQuadra;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Caucionado")
    private Boolean caucionado = Boolean.FALSE;
    @Column(length=60)
    @Caption(value="Latitude")
    private String latitude;
    @Column(length=60)
    @Caption(value="Longitude")
    private String longitude;
    @Caption(value="\u00c1rea Constru\u00edda")
    private BigDecimal areaUnidadeConstruida = BigDecimal.ZERO;
    @Caption(value="\u00c1rea \u00datil do Lote")
    private BigDecimal areaUtilLote = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Privativa")
    private BigDecimal areaPrivativa = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Comum")
    private BigDecimal areaComum = BigDecimal.ZERO;
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao"))
    @Column(length=1000)
    @Caption(value="Complemento Lote")
    @SortableField(forField="complementoLote")
    private String complementoLote;
    @Caption(value="Tipo do Im\u00f3vel")
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao"))
    @SortableField(forField="tipoImovel")
    private TipoImovel tipoImovel = TipoImovel.TERRITORIAL;
    @Caption(value="Notifica\u00e7\u00e3o de Al\u00edquota Progressiva")
    private Long notificacaoAliquotaProgressiva;
    @Caption(value="Grau sul")
    private Long grauSul;
    @Caption(value="Minuto sul")
    private Long minutoSul;
    @Caption(value="Segundo sul")
    private BigDecimal segundoSul = BigDecimal.ZERO;
    @Caption(value="Grau sul")
    private Long grauOeste;
    @Caption(value="Minuto sul")
    private Long minutoOeste;
    @Caption(value="Segundo oeste")
    private BigDecimal segundoOeste = BigDecimal.ZERO;
    @Caption(value="Data Of\u00edcio Al\u00edquota Progressiva")
    private LocalDate dataOficioAliquotaProgressiva;
    @Column(length=20)
    @Caption(value="N\u00famero Incra")
    private String numeroIncra;
    @DynamicValidation(label="Tipo de Lote")
    @Caption(value="Tipo de Lote")
    @Field
    @SortableField(forField="tipoLote")
    private TipoLote tipoLote;
    @Length(max=1)
    @Caption(value="Situa\u00e7\u00e3o Desapropriado")
    private @Length(max=1) String situacaoDesapropriado;
    @ManyToOne
    @JoinColumn(name="idzoneamento", referencedColumnName="idzoneamento")
    @Caption(value="Zoneamento")
    private Zoneamento zoneamento;
    @ManyToOne
    @JoinColumn(name="ideixo", referencedColumnName="ideixo")
    @Caption(value="Eixo")
    private Eixo eixo;
    @Column(name="QUADRICULA_DESCRI", length=15)
    @Caption(value="Descri\u00e7\u00e3o Quadr\u00edcula")
    private String quadriculaFiscalizacao;
    @Column(name="convencaocondominio")
    @Caption(value="Conven\u00e7\u00e3o Condom\u00edmio")
    private Boolean convencaoCondominio;
    @Column(name="AREATOTALINSCRICAO")
    @Caption(value="\u00c1rea Total N\u00e3o Lan\u00e7ada")
    private BigDecimal areaTotalInscricao = BigDecimal.ZERO;
    @Transient
    @NotAudited
    @IndexedEmbedded
    @Caption(value="Situa\u00e7\u00e3o")
    private SituacaoImobiliario situacaoImobiliario;
    @AuditJoinTable(name="TRIBIMOBSITUACAO_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Situa\u00e7\u00f5es")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroImobiliarioSituacao> situacoes = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBAREAVERDE_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="\u00c1reas Verdes")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroImobiliarioAreaVerde> areasVerde = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBAVALIACAO_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY, mappedBy="cadastroGeral")
    @Caption(value="Avalia\u00e7\u00f5es")
    private final List<CadastroImobiliarioAvaliacao> avaliacoes = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Desapropria\u00e7\u00f5es")
    private final List<CadastroImobiliarioDesapropriacao> desapropriacoes = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBPROFUNDIDADE_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Profundidades")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroImobiliarioProfundidade> profundidades = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBSEGMENTO_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Segmentos")
    @OrderBy(value="sequencia")
    private final List<CadastroImobiliarioSegmento> segmentos = new ArrayList();
    @IndexedEmbedded
    @AuditJoinTable(name="TRIBIMOBTESTADA_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Testadas")
    private final List<CadastroImobiliarioTestada> testadas = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cadastroImobiliario")
    @Caption(value="Boletim Terreno")
    private final List<RespostaTerreno> respostaTerrenos = new ArrayList();
    @IndexedEmbedded
    @AuditJoinTable(name="TRIBIMOBTESTADAGEN_IMOB_AUD")
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROIMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Testada Gen\u00e9rica")
    @DiffRevisionIgnoreProperties(value={"id"})
    private final List<CadastroImobiliarioTestadaGenerica> testadasGenericas = new ArrayList();
    @NotAudited
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Geminadas")
    private final List<CadastroImobiliarioGeminada> imobiliarioGeminadas = new ArrayList();
    @AuditJoinTable(name="TRIBIMOBILIARIOENGLOBADO_AUD")
    @DiffRevisionIgnoreProperties(value={"cadastroOrigem"})
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY, mappedBy="cadastroOrigem")
    @Caption(value="Cadastros Englobados")
    private final List<CadastroImobiliarioEnglobado> cadastrosEnglobados = new ArrayList();
    @NotAudited
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cadastroEnglobado")
    @DiffRevisionIgnoreProperties(value={"cadastroEnglobado"})
    @Caption(value="Cadastro Englobado Origem")
    private CadastroImobiliarioEnglobado cadastroEnglobadoOrigem;

    @CalculatedModel(fieldPath="situacaoAtual", caption="Situa\u00e7\u00e3o Atual")
    public CadastroImobiliarioSituacao getSituacaoAtual() {
        for (CadastroImobiliarioSituacao situacao : this.situacoes) {
            if (!situacao.getAtual().booleanValue()) continue;
            return situacao;
        }
        return null;
    }

    @Field(name="tipoImovelDescricao", analyze=Analyze.NO)
    @Facet
    @JsonIgnore
    public String getTipoImovelDescricao() {
        return Optional.ofNullable(this.getTipoImovel()).map(TipoImovel::getDescricao).orElse("");
    }

    @Field(name="tipoLoteDescricao", analyze=Analyze.NO)
    @Facet
    @JsonIgnore
    public String getTipoLoteDescricao() {
        return Optional.ofNullable(this.getTipoLote()).map(TipoLote::getDescricao).orElse("");
    }

    @DiffRevisionIgnore
    @JsonIgnore
    @Facet(name="situacaoDescricao", forField="situacaoDescricao")
    @Field(name="situacaoDescricao", analyze=Analyze.NO)
    @SortableField(forField="situacaoDescricao")
    public String getSituacaoImobiliarioDescricao() {
        return Optional.ofNullable(this.getSituacaoAtual()).map(CadastroImobiliarioSituacao::getSituacaoImobiliario).map(SituacaoImobiliario::getDescricao).orElse("");
    }

    @DiffRevisionIgnore
    @JsonIgnore
    public String getPossuiAreaVerdeRelacionada() {
        return Optional.ofNullable(this.getAreasVerde()).map(itens -> br.com.elotech.core.utils.ListUtils.safeIsEmpty((List)itens) == false).map(SimNao::fromBoolean).orElse(SimNao.NAO.getSigla());
    }

    public CadastroImobiliario merge(CadastroImobiliario cadastroImobiliarioToMerge) {
        Assert.isTrue((boolean)cadastroImobiliarioToMerge.getId().equals(this.getId()), (String)"Para fazer o merge, os cadastros devem ter o mesmo id");
        this.setCadastroGeralAnterior(cadastroImobiliarioToMerge.getCadastroGeralAnterior());
        this.setTipoImovel(cadastroImobiliarioToMerge.getTipoImovel());
        this.setTipoLote(cadastroImobiliarioToMerge.getTipoLote());
        this.setSituacaoImobiliario(cadastroImobiliarioToMerge.getSituacaoImobiliario());
        this.setQuadriculaLocalizacao(cadastroImobiliarioToMerge.getQuadriculaLocalizacao());
        this.setDistritoLocalizacao(cadastroImobiliarioToMerge.getDistritoLocalizacao());
        this.setSetorLocalizacao(cadastroImobiliarioToMerge.getSetorLocalizacao());
        this.setQuadraLocalizacao(cadastroImobiliarioToMerge.getQuadraLocalizacao());
        this.setLoteLocalizacao(cadastroImobiliarioToMerge.getLoteLocalizacao());
        this.setUnidadeLocalizacao(cadastroImobiliarioToMerge.getUnidadeLocalizacao());
        this.setInscricaoCadastral(cadastroImobiliarioToMerge.getInscricaoCadastral());
        this.setInscricaoCadastralAnterior(cadastroImobiliarioToMerge.getInscricaoCadastralAnterior());
        this.setLoteamento(cadastroImobiliarioToMerge.getLoteamento());
        this.setBairro(cadastroImobiliarioToMerge.getBairro());
        this.setCep(cadastroImobiliarioToMerge.getCep());
        this.setComplemento(cadastroImobiliarioToMerge.getComplemento());
        this.setFaceQuadra(cadastroImobiliarioToMerge.getFaceQuadra());
        this.setCondominio(cadastroImobiliarioToMerge.getCondominio());
        this.setFaceQuadra(cadastroImobiliarioToMerge.getFaceQuadra());
        this.setDataMatricula(cadastroImobiliarioToMerge.getDataMatricula());
        this.setCartorio(cadastroImobiliarioToMerge.getCartorio());
        this.setLivro(cadastroImobiliarioToMerge.getLivro());
        this.setFolha(cadastroImobiliarioToMerge.getFolha());
        this.setQuadraFiscalizacao(cadastroImobiliarioToMerge.getQuadraFiscalizacao());
        this.setLoteFiscalizacao(cadastroImobiliarioToMerge.getLoteFiscalizacao());
        this.setComplementoLote(cadastroImobiliarioToMerge.getComplementoLote());
        this.setMatricula(cadastroImobiliarioToMerge.getMatricula());
        this.setConvencaoCondominio(cadastroImobiliarioToMerge.getConvencaoCondominio());
        this.setAreaLote(cadastroImobiliarioToMerge.getAreaLote());
        this.setAreaUtilLote(cadastroImobiliarioToMerge.getAreaUtilLote());
        this.setAreaComum(cadastroImobiliarioToMerge.getAreaComum());
        this.setAreaPrivativa(cadastroImobiliarioToMerge.getAreaPrivativa());
        this.setAreaTotalConstruida(cadastroImobiliarioToMerge.getAreaTotalConstruida());
        this.setAreaTotalInscricao(cadastroImobiliarioToMerge.getAreaTotalInscricao());
        this.setAreaUnidadeConstruida(cadastroImobiliarioToMerge.getAreaUnidadeConstruida());
        this.mergeProprietarios(cadastroImobiliarioToMerge.getProprietarios());
        this.mergeProfundidades(cadastroImobiliarioToMerge.getProfundidades());
        this.mergeTestadas(cadastroImobiliarioToMerge.getTestadas());
        this.mergeTestadasGenericas(cadastroImobiliarioToMerge.getTestadasGenericas());
        this.mergeSegmentos(cadastroImobiliarioToMerge.getSegmentos());
        this.addObservacoes(cadastroImobiliarioToMerge.getObservacoes());
        this.mergeRespostasTerreno(cadastroImobiliarioToMerge.getRespostaTerrenos());
        this.mergeAreasVerde(cadastroImobiliarioToMerge.getAreasVerde());
        this.mergeSaneparMatriculas(cadastroImobiliarioToMerge.getSaneparMatriculas());
        this.atualizaReferenciaCamposDinamicos();
        this.setTipoEnderecoCorrespondencia(cadastroImobiliarioToMerge.getTipoEnderecoCorrespondencia());
        this.setCepCorrespondencia(cadastroImobiliarioToMerge.getCepCorrespondencia());
        this.setEnderecoCorrespondencia(cadastroImobiliarioToMerge.getEnderecoCorrespondencia());
        this.setNumeroCorrespondencia(cadastroImobiliarioToMerge.getNumeroCorrespondencia());
        this.setComplementoCorrespondencia(cadastroImobiliarioToMerge.getComplementoCorrespondencia());
        this.setBairroCorrespondencia(cadastroImobiliarioToMerge.getBairroCorrespondencia());
        this.setCidadeUfCorrespondencia(cadastroImobiliarioToMerge.getCidadeUfCorrespondencia());
        this.setUfCorrespondencia(cadastroImobiliarioToMerge.getUfCorrespondencia());
        return this;
    }

    public void mergeRespostasTerreno(List<RespostaTerreno> respostas) {
        List merged = ListUtils.merge((List)this.getRespostaTerrenos(), respostas, Resposta::getId, RespostaTerreno::merge);
        this.getRespostaTerrenos().clear();
        this.getRespostaTerrenos().addAll(merged);
    }

    public void mergeSegmentos(List<CadastroImobiliarioSegmento> novosSegmentos) {
        List merged = ListUtils.merge((List)this.getSegmentos(), novosSegmentos, CadastroImobiliarioSegmento::getSequencia, CadastroImobiliarioSegmento::merge);
        this.getSegmentos().clear();
        this.getSegmentos().addAll(merged);
    }

    private void mergeTestadasGenericas(List<CadastroImobiliarioTestadaGenerica> novasTestadasGenericas) {
        List merged = ListUtils.merge((List)this.getTestadasGenericas(), novasTestadasGenericas, CadastroImobiliarioTestadaGenerica::getCodigoTestadaGenerica, CadastroImobiliarioTestadaGenerica::merge);
        this.getTestadasGenericas().clear();
        this.getTestadasGenericas().addAll(merged);
    }

    private void mergeProfundidades(List<CadastroImobiliarioProfundidade> novasProfundidades) {
        List merged = ListUtils.merge((List)this.getProfundidades(), novasProfundidades, CadastroImobiliarioProfundidade::getSequencia, CadastroImobiliarioProfundidade::merge);
        this.getProfundidades().clear();
        this.getProfundidades().addAll(merged);
    }

    private void mergeAreasVerde(List<CadastroImobiliarioAreaVerde> novasAreasVerde) {
        List merged = ListUtils.merge((List)this.getAreasVerde(), novasAreasVerde, CadastroImobiliarioAreaVerde::getSequencia, CadastroImobiliarioAreaVerde::merge);
        this.getAreasVerde().clear();
        this.getAreasVerde().addAll(merged);
    }

    private void mergeTestadas(List<CadastroImobiliarioTestada> novasTestadas) {
        List merged = ListUtils.merge((List)this.getTestadas(), novasTestadas, CadastroImobiliarioTestada::getId, CadastroImobiliarioTestada::merge);
        this.getTestadas().clear();
        this.getTestadas().addAll(merged);
    }

    public void atualizaReferenciaCamposDinamicos() {
        this.atualizaReferenciaRespostaTerreno();
        this.atualizaReferenciaRespostaSegmento();
    }

    private void atualizaReferenciaRespostaTerreno() {
        this.respostaTerrenos.forEach(respostaTerreno -> {
            if (Objects.isNull(respostaTerreno.getCadastroImobiliario())) {
                respostaTerreno.setCadastroImobiliario(this);
            }
        });
    }

    private void atualizaReferenciaRespostaSegmento() {
        this.segmentos.forEach(segmento -> segmento.getRespostasSegmento().forEach(respostaSegmento -> {
            if (Objects.isNull(respostaSegmento.getSegmento())) {
                respostaSegmento.setSegmento(segmento);
            }
        }));
    }

    @DiffRevisionIgnore
    public Long getUltimaSequenciaSituacao() {
        return this.situacoes.stream().filter(situacao -> situacao.getSequencia() != null).mapToLong(CadastroImobiliarioSituacao::getSequencia).max().orElse(0L);
    }

    public CadastroImobiliario copy(Long cadastroGeral) {
        CadastroImobiliario cadastroImobiliario = new CadastroImobiliario();
        cadastroImobiliario.setCadastroGeral(cadastroGeral);
        cadastroImobiliario.setUsuario(SecurityUtils.getUserAise());
        BeanUtils.copyProperties((Object)this, (Object)cadastroImobiliario, (String[])new String[]{"id", "cadastroGeralIsencoes", "cadastroGeralISS", "dataInclusao", "dataAlteracao", "usuario", "proprietarios", "regimeFiscalPeriodo", "observacoes", "respostasAvulso", "cadastroGeral", "cadastroGeralAnterior", "situacoes", "areasVerde", "saneparMatriculas", "avaliacoes", "desapropriacoes", "profundidades", "segmentos", "testadas", "respostaTerrenos", "testadasGenericas", "imobiliarioGeminadas"});
        this.getProprietarios().stream().map(Proprietario::copy).forEach(x$0 -> cadastroImobiliario.addProprietarios(x$0));
        this.getObservacoes().stream().map(CadastroGeralObservacao::copy).forEach(x$0 -> cadastroImobiliario.addObservacoes(x$0));
        this.profundidades.stream().map(CadastroImobiliarioProfundidade::copy).forEach(arg_0 -> cadastroImobiliario.addProfundidades(arg_0));
        this.segmentos.stream().map(CadastroImobiliarioSegmento::copy).forEach(arg_0 -> cadastroImobiliario.addSegmentos(arg_0));
        this.testadas.stream().map(CadastroImobiliarioTestada::copy).forEach(arg_0 -> cadastroImobiliario.addTestadas(arg_0));
        this.testadasGenericas.stream().map(CadastroImobiliarioTestadaGenerica::copy).forEach(arg_0 -> cadastroImobiliario.addTestadaGenerica(arg_0));
        this.respostaTerrenos.stream().map(RespostaTerreno::copy).forEach(arg_0 -> cadastroImobiliario.addRespostaTerreno(arg_0));
        this.areasVerde.stream().map(CadastroImobiliarioAreaVerde::copy).forEach(arg_0 -> cadastroImobiliario.addAreasVerde(arg_0));
        this.getSaneparMatriculas().stream().map(SaneparMatricula::copy).forEach(arg_0 -> cadastroImobiliario.addSaneparMatricula(arg_0));
        return cadastroImobiliario;
    }

    private void addProfundidades(CadastroImobiliarioProfundidade profundidade) {
        this.profundidades.add(profundidade);
    }

    private void addSegmentos(CadastroImobiliarioSegmento segmento) {
        segmento.setCadastroGeral(this.getCadastroGeral());
        this.segmentos.add(segmento);
    }

    private void addTestadas(CadastroImobiliarioTestada testada) {
        this.testadas.add(testada);
    }

    private void addAreasVerde(CadastroImobiliarioAreaVerde areasVerde) {
        this.areasVerde.add(areasVerde);
    }

    private void addSaneparMatricula(SaneparMatricula saneparMatricula) {
        saneparMatricula.setCadastroGeral((CadastroGeral)this);
        this.getSaneparMatriculas().add(saneparMatricula);
    }

    private void addTestadaGenerica(CadastroImobiliarioTestadaGenerica testadaGenerica) {
        this.testadasGenericas.add(testadaGenerica);
    }

    private void addRespostaTerreno(RespostaTerreno respostaTerreno) {
        respostaTerreno.setCadastroImobiliario(this);
        this.respostaTerrenos.add(respostaTerreno);
    }

    public void atualizaReferenciaSegmentos() {
        this.getSegmentos().forEach(segmento -> {
            segmento.setTipoCadastro(this.getTipoCadastro());
            segmento.setCadastroGeral(this.getCadastroGeral());
        });
    }

    @JsonIgnore
    public BigDecimal getAreaTotalSegmentos(Boolean somenteLancaImposto) {
        return this.segmentos.stream().filter(segmento -> somenteLancaImposto == false || segmento.lancaImposto() != false).reduce(BigDecimal.ZERO, (acc, curr) -> acc.add(curr.getAreaConstruida()), BigDecimal::add);
    }

    @JsonIgnore
    public BigDecimal getAreaTotalSegmentosAreaCoberta(Boolean somenteLancaImposto) {
        return this.segmentos.stream().filter(segmento -> somenteLancaImposto == false || segmento.lancaImposto() != false).map(s -> Optional.ofNullable(s.getAreaCoberta()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public CadastroImobiliario mergeElogeo(CadastroImobiliario cadastroImobiliarioToMerge) {
        Assert.isTrue((boolean)cadastroImobiliarioToMerge.getCadastroGeral().equals(this.getCadastroGeral()), (String)"Para fazer o merge, os cadastros devem ter o mesmo c\u00f3digo");
        this.setComplemento(cadastroImobiliarioToMerge.getComplemento());
        this.setCep(cadastroImobiliarioToMerge.getCep());
        this.setCorrespondenciaLocal(cadastroImobiliarioToMerge.getCorrespondenciaLocal());
        this.setTipoLote(cadastroImobiliarioToMerge.getTipoLote());
        this.setTipoImovel(cadastroImobiliarioToMerge.getTipoImovel());
        this.setBairro(cadastroImobiliarioToMerge.getBairro());
        this.setDistritoLocalizacao(cadastroImobiliarioToMerge.getDistritoLocalizacao());
        this.setSetorLocalizacao(cadastroImobiliarioToMerge.getSetorLocalizacao());
        this.setQuadraLocalizacao(cadastroImobiliarioToMerge.getQuadraLocalizacao());
        this.setLoteLocalizacao(cadastroImobiliarioToMerge.getLoteLocalizacao());
        this.setUnidadeLocalizacao(cadastroImobiliarioToMerge.getUnidadeLocalizacao());
        this.setDistritoFiscalizacao(cadastroImobiliarioToMerge.getDistritoFiscalizacao());
        this.setSetorFiscalizacao(cadastroImobiliarioToMerge.getSetorFiscalizacao());
        this.setQuadraFiscalizacao(cadastroImobiliarioToMerge.getQuadraFiscalizacao());
        this.setLoteFiscalizacao(cadastroImobiliarioToMerge.getLoteFiscalizacao());
        this.setUnidadeFiscalizacao(cadastroImobiliarioToMerge.getUnidadeFiscalizacao());
        this.setMatricula(cadastroImobiliarioToMerge.getMatricula());
        this.setCartorio(cadastroImobiliarioToMerge.getCartorio());
        this.setDataMatricula(cadastroImobiliarioToMerge.getDataMatricula());
        this.setFolha(cadastroImobiliarioToMerge.getFolha());
        this.setLivro(cadastroImobiliarioToMerge.getLivro());
        this.setAreaComum(cadastroImobiliarioToMerge.getAreaComum());
        this.setAreaUtilLote(cadastroImobiliarioToMerge.getAreaUtilLote());
        this.setAreaPrivativa(cadastroImobiliarioToMerge.getAreaPrivativa());
        this.setAreaLote(cadastroImobiliarioToMerge.getAreaLote());
        this.setAreaTotalConstruida(cadastroImobiliarioToMerge.getAreaTotalConstruida());
        this.setComplementoLote(cadastroImobiliarioToMerge.getComplementoLote());
        this.setCondominio(cadastroImobiliarioToMerge.getCondominio());
        this.setLoteamento(cadastroImobiliarioToMerge.getLoteamento());
        this.mergeTestadas(cadastroImobiliarioToMerge.getTestadas());
        this.mergeTestadasGenericas(cadastroImobiliarioToMerge.getTestadasGenericas());
        this.mergeSegmentos(cadastroImobiliarioToMerge.getSegmentos());
        return this;
    }

    public void validaCamposFiscalizacao() {
        if (Objects.isNull(this.getDistritoFiscalizacao())) {
            this.setDistritoFiscalizacao(this.getDistritoLocalizacao().getDistrito());
        }
        if (Objects.isNull(this.getSetorFiscalizacao())) {
            this.setSetorFiscalizacao(this.getSetorLocalizacao().getSetor());
        }
        if (Objects.isNull(this.getQuadraFiscalizacao())) {
            this.setQuadraFiscalizacao(this.getQuadraLocalizacao().getQuadra());
        }
        if (Objects.isNull(this.getLoteFiscalizacao())) {
            this.setLoteFiscalizacao(this.getLoteLocalizacao());
        }
        if (Objects.isNull(this.getUnidadeFiscalizacao())) {
            this.setUnidadeFiscalizacao(this.getUnidadeLocalizacao());
        }
    }

    public EnderecoCadastroGeralDTO toEnderecoCadastroGeralDTO() {
        EnderecoCadastroGeralDTO dto = super.toEnderecoCadastroGeralDTO();
        Optional.ofNullable(this.getSetorLocalizacao()).map(Setor::getSetor).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setSetor(arg_0));
        Optional.ofNullable(this.getQuadraLocalizacao()).map(SetorQuadra::getQuadra).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setQuadra(arg_0));
        Optional.ofNullable(this.getQuadraFiscalizacao()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setQuadraFiscalizacao(arg_0));
        Optional.ofNullable(this.getLoteFiscalizacao()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setLoteFiscalizacao(arg_0));
        Optional.ofNullable(this.getTipoImovelDescricao()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setTipoImovel(arg_0));
        Optional.ofNullable(this.getTipoLoteDescricao()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setTipoLote(arg_0));
        Optional.ofNullable(this.getComplementoLote()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setComplementoLote(arg_0));
        Optional.ofNullable(this.getSituacaoImobiliarioDescricao()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setSituacao(arg_0));
        Optional.ofNullable(this.getDistritoLocalizacao()).map(Distrito::getId).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setDistrito(arg_0));
        Optional.ofNullable(this.getUnidadeLocalizacao()).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setUnidade(arg_0));
        Optional.ofNullable(this.getQuadriculaLocalizacao()).map(Quadricula::getId).ifPresent(arg_0 -> ((EnderecoCadastroGeralDTO)dto).setQuadricula(arg_0));
        dto.setLote(this.getLoteLocalizacao());
        return dto;
    }

    @JsonIgnore
    public void setEnderecoCadastroGeralDTO(CadastroGeralDTO dto) {
        Optional.ofNullable(this.getComplementoLote()).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setComplementoLoteCadastro(arg_0));
        Optional.ofNullable(this.getSetorLocalizacao()).map(Setor::getSetor).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setZona(arg_0));
        Optional.ofNullable(this.getQuadraLocalizacao()).map(SetorQuadra::getQuadra).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setQuadra(arg_0));
        Optional.ofNullable(this.getLoteLocalizacao()).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setData(arg_0));
        Optional.ofNullable(this.getInscricaoCadastral()).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setInscricaoCadastral(arg_0));
        Optional.ofNullable(this.getTipoImovel()).map(TipoImovel::getValue).ifPresent(arg_0 -> ((CadastroGeralDTO)dto).setTipoImovel(arg_0));
    }

    @JsonIgnore
    public CadastroGeralDTO toCadastroGeralDTO() {
        CadastroGeralDTO cadastroGeralDTO = super.toCadastroGeralDTO();
        this.setEnderecoCadastroGeralDTO(cadastroGeralDTO);
        return cadastroGeralDTO;
    }

    @JsonIgnore
    public Long getLastSequencia() {
        if (this.segmentos.isEmpty()) {
            return 0L;
        }
        return this.segmentos.stream().map(CadastroImobiliarioSegmento::getSequencia).max(Long::compareTo).orElse(0L);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliario)) {
            return false;
        }
        CadastroImobiliario other = (CadastroImobiliario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliario;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public CadastroImobiliario() {
    }

    @Generated
    public String getInscricaoCadastral() {
        return this.inscricaoCadastral;
    }

    @Generated
    public String getInscricaoCadastralAnterior() {
        return this.inscricaoCadastralAnterior;
    }

    @Generated
    public Long getTrechoInscricaoCadastral() {
        return this.trechoInscricaoCadastral;
    }

    @Generated
    public Quadricula getQuadriculaLocalizacao() {
        return this.quadriculaLocalizacao;
    }

    @Generated
    public Distrito getDistritoLocalizacao() {
        return this.distritoLocalizacao;
    }

    @Generated
    public Setor getSetorLocalizacao() {
        return this.setorLocalizacao;
    }

    @Generated
    public SetorQuadra getQuadraLocalizacao() {
        return this.quadraLocalizacao;
    }

    @Generated
    public String getLoteLocalizacao() {
        return this.loteLocalizacao;
    }

    @Generated
    public String getUnidadeLocalizacao() {
        return this.unidadeLocalizacao;
    }

    @Generated
    public String getUnidadeFiscalizacao() {
        return this.unidadeFiscalizacao;
    }

    @Generated
    public String getDistritoFiscalizacao() {
        return this.distritoFiscalizacao;
    }

    @Generated
    public String getSetorFiscalizacao() {
        return this.setorFiscalizacao;
    }

    @Generated
    public String getTrechoDescr() {
        return this.trechoDescr;
    }

    @Generated
    public String getQuadraFiscalizacao() {
        return this.quadraFiscalizacao;
    }

    @Generated
    public String getLoteFiscalizacao() {
        return this.loteFiscalizacao;
    }

    @Generated
    public Imobiliaria getImobiliaria() {
        return this.imobiliaria;
    }

    @Generated
    public Condominio getCondominio() {
        return this.condominio;
    }

    @Generated
    public Loteamento getLoteamento() {
        return this.loteamento;
    }

    @Generated
    public Long getAnoAliquotaProgressiva() {
        return this.anoAliquotaProgressiva;
    }

    @Generated
    public BigDecimal getAreaLote() {
        return this.areaLote;
    }

    @Generated
    public BigDecimal getProfundidadeMedia() {
        return this.profundidadeMedia;
    }

    @Generated
    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    @Generated
    public Boolean getLimitaCercaMuro() {
        return this.limitaCercaMuro;
    }

    @Generated
    public Boolean getImovelProprio() {
        return this.imovelProprio;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public String getCartorio() {
        return this.cartorio;
    }

    @Generated
    public LocalDate getDataMatricula() {
        return this.dataMatricula;
    }

    @Generated
    public String getLivro() {
        return this.livro;
    }

    @Generated
    public String getFolha() {
        return this.folha;
    }

    @Generated
    public String getFaceQuadra() {
        return this.faceQuadra;
    }

    @Generated
    public Boolean getCaucionado() {
        return this.caucionado;
    }

    @Generated
    public String getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getLongitude() {
        return this.longitude;
    }

    @Generated
    public BigDecimal getAreaUnidadeConstruida() {
        return this.areaUnidadeConstruida;
    }

    @Generated
    public BigDecimal getAreaUtilLote() {
        return this.areaUtilLote;
    }

    @Generated
    public BigDecimal getAreaPrivativa() {
        return this.areaPrivativa;
    }

    @Generated
    public BigDecimal getAreaComum() {
        return this.areaComum;
    }

    @Generated
    public String getComplementoLote() {
        return this.complementoLote;
    }

    @Generated
    public TipoImovel getTipoImovel() {
        return this.tipoImovel;
    }

    @Generated
    public Long getNotificacaoAliquotaProgressiva() {
        return this.notificacaoAliquotaProgressiva;
    }

    @Generated
    public Long getGrauSul() {
        return this.grauSul;
    }

    @Generated
    public Long getMinutoSul() {
        return this.minutoSul;
    }

    @Generated
    public BigDecimal getSegundoSul() {
        return this.segundoSul;
    }

    @Generated
    public Long getGrauOeste() {
        return this.grauOeste;
    }

    @Generated
    public Long getMinutoOeste() {
        return this.minutoOeste;
    }

    @Generated
    public BigDecimal getSegundoOeste() {
        return this.segundoOeste;
    }

    @Generated
    public LocalDate getDataOficioAliquotaProgressiva() {
        return this.dataOficioAliquotaProgressiva;
    }

    @Generated
    public String getNumeroIncra() {
        return this.numeroIncra;
    }

    @Generated
    public TipoLote getTipoLote() {
        return this.tipoLote;
    }

    @Generated
    public String getSituacaoDesapropriado() {
        return this.situacaoDesapropriado;
    }

    @Generated
    public Zoneamento getZoneamento() {
        return this.zoneamento;
    }

    @Generated
    public Eixo getEixo() {
        return this.eixo;
    }

    @Generated
    public String getQuadriculaFiscalizacao() {
        return this.quadriculaFiscalizacao;
    }

    @Generated
    public Boolean getConvencaoCondominio() {
        return this.convencaoCondominio;
    }

    @Generated
    public BigDecimal getAreaTotalInscricao() {
        return this.areaTotalInscricao;
    }

    @Generated
    public SituacaoImobiliario getSituacaoImobiliario() {
        return this.situacaoImobiliario;
    }

    @Generated
    public List<CadastroImobiliarioSituacao> getSituacoes() {
        return this.situacoes;
    }

    @Generated
    public List<CadastroImobiliarioAreaVerde> getAreasVerde() {
        return this.areasVerde;
    }

    @Generated
    public List<CadastroImobiliarioAvaliacao> getAvaliacoes() {
        return this.avaliacoes;
    }

    @Generated
    public List<CadastroImobiliarioDesapropriacao> getDesapropriacoes() {
        return this.desapropriacoes;
    }

    @Generated
    public List<CadastroImobiliarioProfundidade> getProfundidades() {
        return this.profundidades;
    }

    @Generated
    public List<CadastroImobiliarioSegmento> getSegmentos() {
        return this.segmentos;
    }

    @Generated
    public List<CadastroImobiliarioTestada> getTestadas() {
        return this.testadas;
    }

    @Generated
    public List<RespostaTerreno> getRespostaTerrenos() {
        return this.respostaTerrenos;
    }

    @Generated
    public List<CadastroImobiliarioTestadaGenerica> getTestadasGenericas() {
        return this.testadasGenericas;
    }

    @Generated
    public List<CadastroImobiliarioGeminada> getImobiliarioGeminadas() {
        return this.imobiliarioGeminadas;
    }

    @Generated
    public List<CadastroImobiliarioEnglobado> getCadastrosEnglobados() {
        return this.cadastrosEnglobados;
    }

    @Generated
    public CadastroImobiliarioEnglobado getCadastroEnglobadoOrigem() {
        return this.cadastroEnglobadoOrigem;
    }

    @Generated
    public void setInscricaoCadastral(String inscricaoCadastral) {
        this.inscricaoCadastral = inscricaoCadastral;
    }

    @Generated
    public void setInscricaoCadastralAnterior(String inscricaoCadastralAnterior) {
        this.inscricaoCadastralAnterior = inscricaoCadastralAnterior;
    }

    @Generated
    public void setTrechoInscricaoCadastral(Long trechoInscricaoCadastral) {
        this.trechoInscricaoCadastral = trechoInscricaoCadastral;
    }

    @Generated
    public void setQuadriculaLocalizacao(Quadricula quadriculaLocalizacao) {
        this.quadriculaLocalizacao = quadriculaLocalizacao;
    }

    @JsonIgnore
    @Generated
    public void setDistritoLocalizacao(Distrito distritoLocalizacao) {
        this.distritoLocalizacao = distritoLocalizacao;
    }

    @JsonIgnoreProperties(value={"quadras"})
    @JsonIgnore
    @Generated
    public void setSetorLocalizacao(Setor setorLocalizacao) {
        this.setorLocalizacao = setorLocalizacao;
    }

    @JsonIgnoreProperties(value={"setor"})
    @JsonIgnore
    @Generated
    public void setQuadraLocalizacao(SetorQuadra quadraLocalizacao) {
        this.quadraLocalizacao = quadraLocalizacao;
    }

    @Generated
    public void setLoteLocalizacao(String loteLocalizacao) {
        this.loteLocalizacao = loteLocalizacao;
    }

    @Generated
    public void setUnidadeLocalizacao(String unidadeLocalizacao) {
        this.unidadeLocalizacao = unidadeLocalizacao;
    }

    @Generated
    public void setUnidadeFiscalizacao(String unidadeFiscalizacao) {
        this.unidadeFiscalizacao = unidadeFiscalizacao;
    }

    @Generated
    public void setDistritoFiscalizacao(String distritoFiscalizacao) {
        this.distritoFiscalizacao = distritoFiscalizacao;
    }

    @Generated
    public void setSetorFiscalizacao(String setorFiscalizacao) {
        this.setorFiscalizacao = setorFiscalizacao;
    }

    @Generated
    public void setTrechoDescr(String trechoDescr) {
        this.trechoDescr = trechoDescr;
    }

    @Generated
    public void setQuadraFiscalizacao(String quadraFiscalizacao) {
        this.quadraFiscalizacao = quadraFiscalizacao;
    }

    @Generated
    public void setLoteFiscalizacao(String loteFiscalizacao) {
        this.loteFiscalizacao = loteFiscalizacao;
    }

    @Generated
    public void setImobiliaria(Imobiliaria imobiliaria) {
        this.imobiliaria = imobiliaria;
    }

    @Generated
    public void setCondominio(Condominio condominio) {
        this.condominio = condominio;
    }

    @JsonIgnoreProperties(value={"setor"})
    @Generated
    public void setLoteamento(Loteamento loteamento) {
        this.loteamento = loteamento;
    }

    @Generated
    public void setAnoAliquotaProgressiva(Long anoAliquotaProgressiva) {
        this.anoAliquotaProgressiva = anoAliquotaProgressiva;
    }

    @Generated
    public void setAreaLote(BigDecimal areaLote) {
        this.areaLote = areaLote;
    }

    @Generated
    public void setProfundidadeMedia(BigDecimal profundidadeMedia) {
        this.profundidadeMedia = profundidadeMedia;
    }

    @Generated
    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    @Generated
    public void setLimitaCercaMuro(Boolean limitaCercaMuro) {
        this.limitaCercaMuro = limitaCercaMuro;
    }

    @Generated
    public void setImovelProprio(Boolean imovelProprio) {
        this.imovelProprio = imovelProprio;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setCartorio(String cartorio) {
        this.cartorio = cartorio;
    }

    @Generated
    public void setDataMatricula(LocalDate dataMatricula) {
        this.dataMatricula = dataMatricula;
    }

    @Generated
    public void setLivro(String livro) {
        this.livro = livro;
    }

    @Generated
    public void setFolha(String folha) {
        this.folha = folha;
    }

    @Generated
    public void setFaceQuadra(String faceQuadra) {
        this.faceQuadra = faceQuadra;
    }

    @Generated
    public void setCaucionado(Boolean caucionado) {
        this.caucionado = caucionado;
    }

    @Generated
    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setAreaUnidadeConstruida(BigDecimal areaUnidadeConstruida) {
        this.areaUnidadeConstruida = areaUnidadeConstruida;
    }

    @Generated
    public void setAreaUtilLote(BigDecimal areaUtilLote) {
        this.areaUtilLote = areaUtilLote;
    }

    @Generated
    public void setAreaPrivativa(BigDecimal areaPrivativa) {
        this.areaPrivativa = areaPrivativa;
    }

    @Generated
    public void setAreaComum(BigDecimal areaComum) {
        this.areaComum = areaComum;
    }

    @Generated
    public void setComplementoLote(String complementoLote) {
        this.complementoLote = complementoLote;
    }

    @Generated
    public void setTipoImovel(TipoImovel tipoImovel) {
        this.tipoImovel = tipoImovel;
    }

    @Generated
    public void setNotificacaoAliquotaProgressiva(Long notificacaoAliquotaProgressiva) {
        this.notificacaoAliquotaProgressiva = notificacaoAliquotaProgressiva;
    }

    @Generated
    public void setGrauSul(Long grauSul) {
        this.grauSul = grauSul;
    }

    @Generated
    public void setMinutoSul(Long minutoSul) {
        this.minutoSul = minutoSul;
    }

    @Generated
    public void setSegundoSul(BigDecimal segundoSul) {
        this.segundoSul = segundoSul;
    }

    @Generated
    public void setGrauOeste(Long grauOeste) {
        this.grauOeste = grauOeste;
    }

    @Generated
    public void setMinutoOeste(Long minutoOeste) {
        this.minutoOeste = minutoOeste;
    }

    @Generated
    public void setSegundoOeste(BigDecimal segundoOeste) {
        this.segundoOeste = segundoOeste;
    }

    @Generated
    public void setDataOficioAliquotaProgressiva(LocalDate dataOficioAliquotaProgressiva) {
        this.dataOficioAliquotaProgressiva = dataOficioAliquotaProgressiva;
    }

    @Generated
    public void setNumeroIncra(String numeroIncra) {
        this.numeroIncra = numeroIncra;
    }

    @Generated
    public void setTipoLote(TipoLote tipoLote) {
        this.tipoLote = tipoLote;
    }

    @Generated
    public void setSituacaoDesapropriado(String situacaoDesapropriado) {
        this.situacaoDesapropriado = situacaoDesapropriado;
    }

    @Generated
    public void setZoneamento(Zoneamento zoneamento) {
        this.zoneamento = zoneamento;
    }

    @Generated
    public void setEixo(Eixo eixo) {
        this.eixo = eixo;
    }

    @Generated
    public void setQuadriculaFiscalizacao(String quadriculaFiscalizacao) {
        this.quadriculaFiscalizacao = quadriculaFiscalizacao;
    }

    @Generated
    public void setConvencaoCondominio(Boolean convencaoCondominio) {
        this.convencaoCondominio = convencaoCondominio;
    }

    @Generated
    public void setAreaTotalInscricao(BigDecimal areaTotalInscricao) {
        this.areaTotalInscricao = areaTotalInscricao;
    }

    @Generated
    public void setSituacaoImobiliario(SituacaoImobiliario situacaoImobiliario) {
        this.situacaoImobiliario = situacaoImobiliario;
    }

    @Generated
    public void setCadastroEnglobadoOrigem(CadastroImobiliarioEnglobado cadastroEnglobadoOrigem) {
        this.cadastroEnglobadoOrigem = cadastroEnglobadoOrigem;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliario(super=" + super.toString() + ")";
    }
}

