/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.cancelamento;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItemPk;
import br.com.elotech.tributos.dto.SituacaoLegal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCANCELAMENTODEBITOITEM")
public class CancelamentoDebitoItem
implements EloEntity<CancelamentoDebitoItemPk>,
Serializable {
    @EmbeddedId
    private CancelamentoDebitoItemPk id;
    @NotNull
    private BigDecimal valor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean estornado = Boolean.FALSE;
    private LocalDate dataEstorno;
    @Length(max=250)
    private @Length(max=250) String usuarioEstorno;
    @Length(max=50)
    private @Length(max=50) String programaEstorno;
    private Long exercicioProcesso;
    private Long idProcesso;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    @ManyToOne
    @JoinColumn(name="motivodesconto", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoDesconto;
    private SituacaoLegal situacaoLegal;
    private BigDecimal valorAtualizado = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;

    @Generated
    public CancelamentoDebitoItem() {
    }

    @Generated
    public CancelamentoDebitoItemPk getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public Boolean getEstornado() {
        return this.estornado;
    }

    @Generated
    public LocalDate getDataEstorno() {
        return this.dataEstorno;
    }

    @Generated
    public String getUsuarioEstorno() {
        return this.usuarioEstorno;
    }

    @Generated
    public String getProgramaEstorno() {
        return this.programaEstorno;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public MotivoDeducao getMotivoDesconto() {
        return this.motivoDesconto;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public BigDecimal getValorAtualizado() {
        return this.valorAtualizado;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public void setId(CancelamentoDebitoItemPk id) {
        this.id = id;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    @Generated
    public void setDataEstorno(LocalDate dataEstorno) {
        this.dataEstorno = dataEstorno;
    }

    @Generated
    public void setUsuarioEstorno(String usuarioEstorno) {
        this.usuarioEstorno = usuarioEstorno;
    }

    @Generated
    public void setProgramaEstorno(String programaEstorno) {
        this.programaEstorno = programaEstorno;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setMotivoDesconto(MotivoDeducao motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setValorAtualizado(BigDecimal valorAtualizado) {
        this.valorAtualizado = valorAtualizado;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public String toString() {
        return "CancelamentoDebitoItem(id=" + String.valueOf(this.getId()) + ", valor=" + String.valueOf(this.getValor()) + ", estornado=" + this.getEstornado() + ", dataEstorno=" + String.valueOf(this.getDataEstorno()) + ", usuarioEstorno=" + this.getUsuarioEstorno() + ", programaEstorno=" + this.getProgramaEstorno() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", idProcesso=" + this.getIdProcesso() + ", observacao=" + this.getObservacao() + ", motivoDesconto=" + String.valueOf(this.getMotivoDesconto()) + ", situacaoLegal=" + String.valueOf(this.getSituacaoLegal()) + ", valorAtualizado=" + String.valueOf(this.getValorAtualizado()) + ", valorJuros=" + String.valueOf(this.getValorJuros()) + ", valorMulta=" + String.valueOf(this.getValorMulta()) + ", valorCorrecao=" + String.valueOf(this.getValorCorrecao()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelamentoDebitoItem)) {
            return false;
        }
        CancelamentoDebitoItem other = (CancelamentoDebitoItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CancelamentoDebitoItemPk this$id = this.getId();
        CancelamentoDebitoItemPk other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CancelamentoDebitoItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CancelamentoDebitoItemPk $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

