/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.cancelamento;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.TipoDeducao;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCANCELAMENTODEBITO")
public class CancelamentoDebito
implements EloEntity<CancelamentoDebitoPk>,
Serializable {
    @EmbeddedId
    private CancelamentoDebitoPk id;
    private LocalDate dataCancelamento;
    private LocalDate dataInclusao;
    @Length(max=250)
    private @Length(max=250) String usuario;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="idato", referencedColumnName="idato"))})
    private Ato ato;
    @ManyToOne
    private TipoDeducao tipoDeducao;
    private Long situacaoLegal;
    private Long idProcesso;
    private Long exercicioProcesso;
    @ManyToOne
    @JoinColumn(name="motivocancelamento", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoCancelamento;
    @Length(max=1000)
    private @Length(max=1000) String motivo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean cancelamentoAutomatico = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean alterado = Boolean.FALSE;
    @JsonIgnoreProperties(value={"id.cancelamentoDebito"})
    @OneToMany(mappedBy="id.cancelamentoDebito", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="id.debitoParcelaTributo")
    private List<CancelamentoDebitoItem> itens = new ArrayList();
    private Boolean porTributo;
    @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20")
    private @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20") String processoSei;

    public String getSituacao() {
        if (this.itens.isEmpty()) {
            return "Sem Itens";
        }
        Boolean estornado = this.itens.stream().allMatch(CancelamentoDebitoItem::getEstornado);
        Boolean naoEstornado = this.itens.stream().noneMatch(CancelamentoDebitoItem::getEstornado);
        if (estornado.booleanValue()) {
            return "Sim";
        }
        if (naoEstornado.booleanValue()) {
            return "N\u00e3o";
        }
        return "Parcial";
    }

    @Generated
    public CancelamentoDebito() {
    }

    @Generated
    public CancelamentoDebitoPk getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Ato getAto() {
        return this.ato;
    }

    @Generated
    public TipoDeducao getTipoDeducao() {
        return this.tipoDeducao;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public MotivoDeducao getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public Boolean getCancelamentoAutomatico() {
        return this.cancelamentoAutomatico;
    }

    @Generated
    public Boolean getAlterado() {
        return this.alterado;
    }

    @Generated
    public List<CancelamentoDebitoItem> getItens() {
        return this.itens;
    }

    @Generated
    public Boolean getPorTributo() {
        return this.porTributo;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public void setId(CancelamentoDebitoPk id) {
        this.id = id;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setAto(Ato ato) {
        this.ato = ato;
    }

    @Generated
    public void setTipoDeducao(TipoDeducao tipoDeducao) {
        this.tipoDeducao = tipoDeducao;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setMotivoCancelamento(MotivoDeducao motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setCancelamentoAutomatico(Boolean cancelamentoAutomatico) {
        this.cancelamentoAutomatico = cancelamentoAutomatico;
    }

    @Generated
    public void setAlterado(Boolean alterado) {
        this.alterado = alterado;
    }

    @JsonIgnoreProperties(value={"id.cancelamentoDebito"})
    @Generated
    public void setItens(List<CancelamentoDebitoItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setPorTributo(Boolean porTributo) {
        this.porTributo = porTributo;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelamentoDebito)) {
            return false;
        }
        CancelamentoDebito other = (CancelamentoDebito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CancelamentoDebitoPk this$id = this.getId();
        CancelamentoDebitoPk other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CancelamentoDebito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CancelamentoDebitoPk $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CancelamentoDebito(id=" + String.valueOf(this.getId()) + ")";
    }
}

