/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.camposdinamicos;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnore;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import br.com.elotech.tributos.domain.camposdinamicos.Validacao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity(name="campo")
public class Campo
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="S_CAMPO_ID", applyOnMerge=true)
    private Long id;
    @NotNull
    private Long ordem;
    @Caption(value="Identificador")
    @NotEmpty
    private String identificador;
    @Caption(value="Descri\u00e7\u00e3o")
    @NotEmpty
    private String descricao;
    @NotNull
    private Long codigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDGRUPO", updatable=false, nullable=false)
    @JsonIgnore
    @MetaModelIgnore
    private GrupoCampo grupoCampo;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private TipoCampo tipo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean obrigatorio = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativo = Boolean.TRUE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean armazenaResultadoCalculo = Boolean.FALSE;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="IDCAMPO", updatable=false, nullable=false)
    private List<Validacao> validacoes = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="IDCAMPO", updatable=false, nullable=false)
    @Caption(value="Alternativas")
    private List<Alternativa> alternativas = new ArrayList();

    @DiffRevisionIgnore
    public String getTabelaResposta() {
        return Optional.ofNullable(this.grupoCampo).map(GrupoCampo::getFuncionalidade).map(FuncionalidadeCampo::getTabelaResposta).orElse("");
    }

    @Generated
    public Campo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public GrupoCampo getGrupoCampo() {
        return this.grupoCampo;
    }

    @Generated
    public TipoCampo getTipo() {
        return this.tipo;
    }

    @Generated
    public Boolean getObrigatorio() {
        return this.obrigatorio;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Boolean getArmazenaResultadoCalculo() {
        return this.armazenaResultadoCalculo;
    }

    @Generated
    public List<Validacao> getValidacoes() {
        return this.validacoes;
    }

    @Generated
    public List<Alternativa> getAlternativas() {
        return this.alternativas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @JsonIgnore
    @Generated
    public void setGrupoCampo(GrupoCampo grupoCampo) {
        this.grupoCampo = grupoCampo;
    }

    @Generated
    public void setTipo(TipoCampo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setObrigatorio(Boolean obrigatorio) {
        this.obrigatorio = obrigatorio;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setArmazenaResultadoCalculo(Boolean armazenaResultadoCalculo) {
        this.armazenaResultadoCalculo = armazenaResultadoCalculo;
    }

    @Generated
    public void setValidacoes(List<Validacao> validacoes) {
        this.validacoes = validacoes;
    }

    @Generated
    public void setAlternativas(List<Alternativa> alternativas) {
        this.alternativas = alternativas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Campo)) {
            return false;
        }
        Campo other = (Campo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Campo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Campo(id=" + this.getId() + ", identificador=" + this.getIdentificador() + ")";
    }
}

