/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.calculo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.dto.ReajusteTabelaValorAlteracaoDTO;
import br.com.elotech.tributos.domain.calculo.ReajusteValor;
import br.com.elotech.tributos.domain.parcelamento.TipoReajusteValorItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribreajustevaloritem")
public class ReajusteValorItem
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s05tribreajustevaloritem")
    private Long id;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idreajustevalor")
    private ReajusteValor reajusteValor;
    @Enumerated(value=EnumType.STRING)
    private TipoReajusteValorItem tipo;
    private Long idTabela;
    private String descricao;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorAtualizado = BigDecimal.ZERO;
    private BigDecimal valorItbi = BigDecimal.ZERO;
    private BigDecimal valorItbiAtualizado = BigDecimal.ZERO;

    public static ReajusteValorItem of(ReajusteTabelaValorAlteracaoDTO dto) {
        ReajusteValorItem item = new ReajusteValorItem();
        item.setIdTabela(dto.getIdTabela());
        item.setValor(dto.getValor());
        return item;
    }

    @Generated
    public ReajusteValorItem() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public ReajusteValor getReajusteValor() {
        return this.reajusteValor;
    }

    @Generated
    public TipoReajusteValorItem getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getIdTabela() {
        return this.idTabela;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorAtualizado() {
        return this.valorAtualizado;
    }

    @Generated
    public BigDecimal getValorItbi() {
        return this.valorItbi;
    }

    @Generated
    public BigDecimal getValorItbiAtualizado() {
        return this.valorItbiAtualizado;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setReajusteValor(ReajusteValor reajusteValor) {
        this.reajusteValor = reajusteValor;
    }

    @Generated
    public void setTipo(TipoReajusteValorItem tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setIdTabela(Long idTabela) {
        this.idTabela = idTabela;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorAtualizado(BigDecimal valorAtualizado) {
        this.valorAtualizado = valorAtualizado;
    }

    @Generated
    public void setValorItbi(BigDecimal valorItbi) {
        this.valorItbi = valorItbi;
    }

    @Generated
    public void setValorItbiAtualizado(BigDecimal valorItbiAtualizado) {
        this.valorItbiAtualizado = valorItbiAtualizado;
    }

    @Generated
    public String toString() {
        return "ReajusteValorItem(id=" + this.getId() + ", reajusteValor=" + String.valueOf(this.getReajusteValor()) + ", tipo=" + String.valueOf(this.getTipo()) + ", idTabela=" + this.getIdTabela() + ", descricao=" + this.getDescricao() + ", valor=" + String.valueOf(this.getValor()) + ", valorAtualizado=" + String.valueOf(this.getValorAtualizado()) + ", valorItbi=" + String.valueOf(this.getValorItbi()) + ", valorItbiAtualizado=" + String.valueOf(this.getValorItbiAtualizado()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReajusteValorItem)) {
            return false;
        }
        ReajusteValorItem other = (ReajusteValorItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReajusteValorItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

