/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.calculo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.InconsistenciaCalculoDTO;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacaoScript;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.OrigemDadosCalculo;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table
public class CalculoAvaliacao
implements EloEntity<Long>,
Serializable,
CalculoConfigBase {
    @Id
    @EloSequence(sequenceName="SEQ_CALCULOAVALIACAO")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    @Column(updatable=false)
    private Long exercicio;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TipoCalculoConfig tipo;
    private String identificadorResultado;
    private String identificadorBaseCalculo;
    private String identificadorCondicao;
    @Column(name="identvlvenalterritorial")
    private String identificadorValorVenalTerritorial;
    @Column(name="identvlpredial")
    private String identificadorValorVenalPredial;
    @Column(name="identvlterritorialitbi")
    private String identificadorValorVenalTerritorialITBI;
    @Column(name="identvlpredialitbi")
    private String identificadorValorVenalPredialITBI;
    private String identificadorRenuncia;
    private String identificadorIsencao;
    private Boolean aceitaCampoNulo = Boolean.FALSE;
    @OrderBy(value="id")
    @OneToMany(mappedBy="calculoAvaliacao", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CalculoAvaliacaoScript> script = new ArrayList();
    @Transient
    @JsonIgnore
    private CalculoBuildDTO calculoBuildDTO;

    public TipoDivida getTipoDivida() {
        return TipoDivida.IPTU;
    }

    public String getIdentificadorAliquota() {
        return null;
    }

    public String getIdentificadorLog() {
        return String.format("da avalia\u00e7\u00e3o %d", this.id);
    }

    public InconsistenciaCalculoDTO buildInconsistencia(String mensagem) {
        InconsistenciaCalculoDTO inconsistenciaCalculoDTO = new InconsistenciaCalculoDTO();
        inconsistenciaCalculoDTO.setMessage(mensagem);
        return inconsistenciaCalculoDTO;
    }

    public void setIdentificadoresResultado(CalculoResultadoDTO resultadoDTO) {
        resultadoDTO.setIdentificadorValorVenalTerritorial(this.identificadorValorVenalTerritorial);
        resultadoDTO.setIdentificadorValorVenalPredial(this.identificadorValorVenalPredial);
        resultadoDTO.setIdentificadorValorVenalTerritorialITBI(this.identificadorValorVenalTerritorialITBI);
        resultadoDTO.setIdentificadorValorVenalPredialITBI(this.identificadorValorVenalPredialITBI);
    }

    public OrigemDadosCalculo getOrigemDadosCalculo() {
        return OrigemDadosCalculo.IMOBILIARIO;
    }

    @Generated
    public CalculoAvaliacao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public TipoCalculoConfig getTipo() {
        return this.tipo;
    }

    @Generated
    public String getIdentificadorResultado() {
        return this.identificadorResultado;
    }

    @Generated
    public String getIdentificadorBaseCalculo() {
        return this.identificadorBaseCalculo;
    }

    @Generated
    public String getIdentificadorCondicao() {
        return this.identificadorCondicao;
    }

    @Generated
    public String getIdentificadorValorVenalTerritorial() {
        return this.identificadorValorVenalTerritorial;
    }

    @Generated
    public String getIdentificadorValorVenalPredial() {
        return this.identificadorValorVenalPredial;
    }

    @Generated
    public String getIdentificadorValorVenalTerritorialITBI() {
        return this.identificadorValorVenalTerritorialITBI;
    }

    @Generated
    public String getIdentificadorValorVenalPredialITBI() {
        return this.identificadorValorVenalPredialITBI;
    }

    @Generated
    public String getIdentificadorRenuncia() {
        return this.identificadorRenuncia;
    }

    @Generated
    public String getIdentificadorIsencao() {
        return this.identificadorIsencao;
    }

    @Generated
    public Boolean getAceitaCampoNulo() {
        return this.aceitaCampoNulo;
    }

    @Generated
    public List<CalculoAvaliacaoScript> getScript() {
        return this.script;
    }

    @Generated
    public CalculoBuildDTO getCalculoBuildDTO() {
        return this.calculoBuildDTO;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipo(TipoCalculoConfig tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setIdentificadorResultado(String identificadorResultado) {
        this.identificadorResultado = identificadorResultado;
    }

    @Generated
    public void setIdentificadorBaseCalculo(String identificadorBaseCalculo) {
        this.identificadorBaseCalculo = identificadorBaseCalculo;
    }

    @Generated
    public void setIdentificadorCondicao(String identificadorCondicao) {
        this.identificadorCondicao = identificadorCondicao;
    }

    @Generated
    public void setIdentificadorValorVenalTerritorial(String identificadorValorVenalTerritorial) {
        this.identificadorValorVenalTerritorial = identificadorValorVenalTerritorial;
    }

    @Generated
    public void setIdentificadorValorVenalPredial(String identificadorValorVenalPredial) {
        this.identificadorValorVenalPredial = identificadorValorVenalPredial;
    }

    @Generated
    public void setIdentificadorValorVenalTerritorialITBI(String identificadorValorVenalTerritorialITBI) {
        this.identificadorValorVenalTerritorialITBI = identificadorValorVenalTerritorialITBI;
    }

    @Generated
    public void setIdentificadorValorVenalPredialITBI(String identificadorValorVenalPredialITBI) {
        this.identificadorValorVenalPredialITBI = identificadorValorVenalPredialITBI;
    }

    @Generated
    public void setIdentificadorRenuncia(String identificadorRenuncia) {
        this.identificadorRenuncia = identificadorRenuncia;
    }

    @Generated
    public void setIdentificadorIsencao(String identificadorIsencao) {
        this.identificadorIsencao = identificadorIsencao;
    }

    @Generated
    public void setAceitaCampoNulo(Boolean aceitaCampoNulo) {
        this.aceitaCampoNulo = aceitaCampoNulo;
    }

    @Generated
    public void setScript(List<CalculoAvaliacaoScript> script) {
        this.script = script;
    }

    @JsonIgnore
    @Generated
    public void setCalculoBuildDTO(CalculoBuildDTO calculoBuildDTO) {
        this.calculoBuildDTO = calculoBuildDTO;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoAvaliacao)) {
            return false;
        }
        CalculoAvaliacao other = (CalculoAvaliacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoAvaliacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoAvaliacao(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipo=" + String.valueOf(this.getTipo()) + ", script=" + String.valueOf(this.getScript()) + ")";
    }
}

