/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.autoinfracao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracao;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoHistoricoId;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoAutoInfracao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@Table(name="tribautoinfracaohistorico")
public class AutoInfracaoHistorico
implements EloEntity<AutoInfracaoHistoricoId> {
    @EmbeddedId
    private AutoInfracaoHistoricoId id;
    @ManyToOne
    @MapsId(value="autoInfracao")
    @JoinColumn(name="idautoinfracaofiscal")
    @JsonIgnore
    @MetaModelIgnore
    private AutoInfracao autoInfracao;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime data;
    private String hora;
    private String usuario;
    @Column(name="situacaoautoinfracao")
    private SituacaoAutoInfracao situacao;

    public LocalDateTime getDataHora() {
        if (this.data.getHour() == 0 && this.data.getMinute() == 0 && this.data.getSecond() == 0) {
            return LocalDateTime.of(this.data.toLocalDate(), LocalTime.parse(this.hora, DateTimeFormatter.ISO_TIME));
        }
        return this.data;
    }

    @Generated
    public AutoInfracaoHistorico() {
    }

    @Generated
    public AutoInfracaoHistoricoId getId() {
        return this.id;
    }

    @Generated
    public AutoInfracao getAutoInfracao() {
        return this.autoInfracao;
    }

    @Generated
    public LocalDateTime getData() {
        return this.data;
    }

    @Generated
    public String getHora() {
        return this.hora;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public SituacaoAutoInfracao getSituacao() {
        return this.situacao;
    }

    @Generated
    public void setId(AutoInfracaoHistoricoId id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setAutoInfracao(AutoInfracao autoInfracao) {
        this.autoInfracao = autoInfracao;
    }

    @Generated
    public void setData(LocalDateTime data) {
        this.data = data;
    }

    @Generated
    public void setHora(String hora) {
        this.hora = hora;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setSituacao(SituacaoAutoInfracao situacao) {
        this.situacao = situacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoInfracaoHistorico)) {
            return false;
        }
        AutoInfracaoHistorico other = (AutoInfracaoHistorico)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AutoInfracaoHistoricoId this$id = this.getId();
        AutoInfracaoHistoricoId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        AutoInfracao this$autoInfracao = this.getAutoInfracao();
        AutoInfracao other$autoInfracao = other.getAutoInfracao();
        if (this$autoInfracao == null ? other$autoInfracao != null : !this$autoInfracao.equals(other$autoInfracao)) {
            return false;
        }
        LocalDateTime this$data = this.getData();
        LocalDateTime other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$hora = this.getHora();
        String other$hora = other.getHora();
        if (this$hora == null ? other$hora != null : !this$hora.equals(other$hora)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        SituacaoAutoInfracao this$situacao = this.getSituacao();
        SituacaoAutoInfracao other$situacao = other.getSituacao();
        return !(this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoInfracaoHistorico;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AutoInfracaoHistoricoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        AutoInfracao $autoInfracao = this.getAutoInfracao();
        result = result * 59 + ($autoInfracao == null ? 43 : $autoInfracao.hashCode());
        LocalDateTime $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $hora = this.getHora();
        result = result * 59 + ($hora == null ? 43 : $hora.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        SituacaoAutoInfracao $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AutoInfracaoHistorico(id=" + String.valueOf(this.getId()) + ", autoInfracao=" + String.valueOf(this.getAutoInfracao()) + ", data=" + String.valueOf(this.getData()) + ", hora=" + this.getHora() + ", usuario=" + this.getUsuario() + ", situacao=" + String.valueOf(this.getSituacao()) + ")";
    }
}

