/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.atendimento;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import java.time.LocalDateTime;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table
public class AtendimentoHistorico
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="S_ATENDIMENTOHISTORICO_ID")
    private Long id;
    @NotNull
    private LocalDateTime horario;
    @NotNull
    @ManyToOne
    private CadastroGeral cadastroGeral;
    @NotNull
    @ManyToOne
    private Atendimento atendimento;

    public AtendimentoHistorico() {
    }

    public AtendimentoHistorico(Atendimento atendimento) {
        this.horario = LocalDateTime.now();
        this.cadastroGeral = atendimento.getCadastroGeral();
        this.atendimento = atendimento;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDateTime getHorario() {
        return this.horario;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Atendimento getAtendimento() {
        return this.atendimento;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setHorario(LocalDateTime horario) {
        this.horario = horario;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAtendimento(Atendimento atendimento) {
        this.atendimento = atendimento;
    }

    @Generated
    public String toString() {
        return "AtendimentoHistorico(id=" + this.getId() + ", horario=" + String.valueOf(this.getHorario()) + ", cadastroGeral=" + String.valueOf(this.getCadastroGeral()) + ", atendimento=" + String.valueOf(this.getAtendimento()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtendimentoHistorico)) {
            return false;
        }
        AtendimentoHistorico other = (AtendimentoHistorico)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtendimentoHistorico;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

