/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.TipoInscrito;
import br.com.elotech.tributos.domain.TipoTributo;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.UpdateTributoDTO;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribreceita")
public class Tributo
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="seq_receita")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @NotBlank
    @Length(max=5)
    @Column(name="receita")
    private @NotBlank @Length(max=5) String tributo;
    @NotNull
    @ManyToOne
    @JoinColumn(name="tiporeceita")
    @IgnoreSizeOf
    private TipoTributo tipoTributo;
    @NotBlank
    @Length(max=100)
    private @NotBlank @Length(max=100) String descricao;
    @Length(max=50)
    private @Length(max=50) String apelido;
    private ClassificacaoTributo classificacao;
    private Boolean incideJuros;
    private Boolean incideMulta;
    private Boolean incideCorrecao;
    private TipoInscrito inscrito;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean ativa;

    public static Tributo from(UpdateTributoDTO updateTributoDTO) {
        Tributo entity = new Tributo();
        entity.setId(updateTributoDTO.getId());
        entity.setEntidade(updateTributoDTO.getEntidade());
        entity.setExercicio(updateTributoDTO.getExercicio());
        entity.setTributo(updateTributoDTO.getTributo());
        entity.setTipoTributo(updateTributoDTO.getTipoTributo());
        entity.setDescricao(updateTributoDTO.getDescricao());
        entity.setApelido(updateTributoDTO.getApelido());
        entity.setClassificacao(updateTributoDTO.getClassificacao());
        entity.setIncideJuros(updateTributoDTO.getIncideJuros());
        entity.setIncideMulta(updateTributoDTO.getIncideMulta());
        entity.setIncideCorrecao(updateTributoDTO.getIncideCorrecao());
        entity.setInscrito(updateTributoDTO.getInscrito());
        entity.setAtiva(updateTributoDTO.getAtiva());
        return entity;
    }

    @Generated
    public Tributo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public TipoTributo getTipoTributo() {
        return this.tipoTributo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getApelido() {
        return this.apelido;
    }

    @Generated
    public ClassificacaoTributo getClassificacao() {
        return this.classificacao;
    }

    @Generated
    public Boolean getIncideJuros() {
        return this.incideJuros;
    }

    @Generated
    public Boolean getIncideMulta() {
        return this.incideMulta;
    }

    @Generated
    public Boolean getIncideCorrecao() {
        return this.incideCorrecao;
    }

    @Generated
    public TipoInscrito getInscrito() {
        return this.inscrito;
    }

    @Generated
    public Boolean getAtiva() {
        return this.ativa;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setTipoTributo(TipoTributo tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setApelido(String apelido) {
        this.apelido = apelido;
    }

    @Generated
    public void setClassificacao(ClassificacaoTributo classificacao) {
        this.classificacao = classificacao;
    }

    @Generated
    public void setIncideJuros(Boolean incideJuros) {
        this.incideJuros = incideJuros;
    }

    @Generated
    public void setIncideMulta(Boolean incideMulta) {
        this.incideMulta = incideMulta;
    }

    @Generated
    public void setIncideCorrecao(Boolean incideCorrecao) {
        this.incideCorrecao = incideCorrecao;
    }

    @Generated
    public void setInscrito(TipoInscrito inscrito) {
        this.inscrito = inscrito;
    }

    @Generated
    public void setAtiva(Boolean ativa) {
        this.ativa = ativa;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tributo)) {
            return false;
        }
        Tributo other = (Tributo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tributo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Tributo(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tributo=" + this.getTributo() + ")";
    }
}

