/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.enumerable.EnumConverter;
import br.com.elotech.core.enumerable.EnumValues;
import br.com.elotech.core.exception.RecordNotFoundException;
import br.com.elotech.core.utils.EnumUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public enum TipoSituacaoParcela implements EnumConverter<TipoSituacaoParcela, Long>
{
    ABERTO("Aberto/Devedor", Long.valueOf(1L), "A"),
    PAGO("Pago", Long.valueOf(2L), "B"),
    REPARCELADO("Reparcelado", Long.valueOf(3L), "B"),
    PRESCRITO("Prescrito", Long.valueOf(4L), "B"),
    RESTITUIDO("Restituido", Long.valueOf(5L), "B"),
    ISENTO("Isento", Long.valueOf(6L), "B"),
    CANCELADO("Cancelado", Long.valueOf(7L), "B"),
    REMIDO("Remido", Long.valueOf(8L), "B"),
    CONTENCIOSO("Contencioso", Long.valueOf(9L), "B"),
    IMPUGNADO("Impugnado", Long.valueOf(10L), "B"),
    ISENTO_ORIGEM("Isento de Origem", Long.valueOf(11L), "B"),
    SEM_MOVIMENTACAO("Sem Movimenta\u00e7\u00e3o", Long.valueOf(12L), "B"),
    ENGLOBADO("Englobado", Long.valueOf(13L), "B"),
    ARQUIVADO("Arquivado", Long.valueOf(14L), "B"),
    SUSPENSO("Suspenso", Long.valueOf(15L), "B"),
    ANISTIADO("Anistiado", Long.valueOf(16L), "B"),
    AGUARDANDO_REPASSE_JUDICIAL("Aguardando Repasse Judicial", Long.valueOf(17L), "B"),
    EXCLUSAO_LOGICA("Exclus\u00e3o l\u00f3gica", Long.valueOf(18L), "B"),
    CONVERSAO("Convers\u00e3o", Long.valueOf(19L), "B"),
    LEILOADO("Leiloado", Long.valueOf(20L), "B"),
    TRANSFERIDO_CADASTRO("Transferido para outro Cadastro", Long.valueOf(21L), "B"),
    RECURSO_ADMINISTRATIVO("Recurso Administrativo", Long.valueOf(22L), "A"),
    SUBJUDICE("Sub-J\u00fadice", Long.valueOf(23L), "A"),
    DIVIDA_SUSPENSA("Divida Suspensa", Long.valueOf(24L), "A"),
    REPARCELAMENTO_CANCELADO("Reparcelamento Cancelado", Long.valueOf(25L), "B"),
    DACAO_EM_PAGAMENTO("Da\u00e7\u00e3o em Pagamento da D\u00edvida Ativa", Long.valueOf(26L), "B"),
    INSCRITO_DIVIDA_ATIVA("Inscrito em D\u00edvida Ativa", Long.valueOf(27L), "B"),
    PARCELADO("Parcelado", Long.valueOf(28L), "B"),
    PARCELAMENTO_CANCELADO("Parcelamento Cancelado", Long.valueOf(29L), "B"),
    REPARCELAMENTO_CANCELADO_DESFEITO("Reparcelamento Cancelado Desfeito", Long.valueOf(30L), "B"),
    PARCELAMENTO_CANCELADO_DESFEITO("Parcelamento Cancelado Desfeito", Long.valueOf(31L), "B"),
    ESTORNADO("Estornado", Long.valueOf(32L), "B"),
    PAGO_TOTEM("Pago Totem", Long.valueOf(33L), "B"),
    PAGO_POR_ESTORNO_REPARCELAMENTO("Pago por Estorno de Reparcelamento", Long.valueOf(34L), "B"),
    PAGO_POR_PAGAMENTO_NEGOCIADO("Pago por Pagamento Negociado", Long.valueOf(35L), "B"),
    PAGO_POR_PIX("Pago via WebHook Pix", Long.valueOf(36L), "B"),
    DEBITO_AGRUPADO("D\u00e9bito Agrupado", Long.valueOf(37L), "B"),
    ESTORNO_DEBITO_AGRUPADO("Estorno D\u00e9bito Agrupado", Long.valueOf(38L), "B"),
    NEGOCIACAO_JUDICIAL("Em Negocia\u00e7\u00e3o Judicial", Long.valueOf(39L), "B");

    static final List<Long> SITUACOES_ABERTAS;
    private final Long codigo;
    private final String descricao;
    private String tipo;
    public static final EnumValues<TipoSituacaoParcela, Long> ENUM_VALUES;

    private TipoSituacaoParcela(String descricao, Long codigo, String tipo) {
        this.descricao = descricao;
        this.codigo = codigo;
        this.tipo = tipo;
    }

    @JsonCreator
    public static TipoSituacaoParcela fromValue(Object codigo) {
        return Stream.of(TipoSituacaoParcela.values()).filter(t -> t.getValue().equals(Long.valueOf(codigo.toString()))).findFirst().orElseThrow(() -> new RecordNotFoundException(String.format("O TipoSituacaoParcela '%s' n\u00e3o existe.", codigo)));
    }

    public static TipoSituacaoParcela fromDescricao(String descricao) {
        return Stream.of(TipoSituacaoParcela.values()).filter(t -> t.getDescricao().equalsIgnoreCase(descricao)).findFirst().orElseThrow(() -> new RecordNotFoundException(String.format("O TipoSituacaoParcela com a descri\u00e7\u00e3o '%s' n\u00e3o existe.", descricao)));
    }

    public boolean isAberto() {
        return this.tipo.equals("A");
    }

    public boolean isAbertoParaContencioso() {
        return this.codigo.equals(ABERTO.getValue());
    }

    @JsonValue
    public Long getValue() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getTipo() {
        return this.tipo;
    }

    public static List<Long> getSituacoesAbertas() {
        return SITUACOES_ABERTAS;
    }

    static {
        SITUACOES_ABERTAS = Arrays.asList(ABERTO.getValue(), RECURSO_ADMINISTRATIVO.getValue(), SUBJUDICE.getValue(), DIVIDA_SUSPENSA.getValue());
        ENUM_VALUES = EnumUtils.getEnumValuesMap(TipoSituacaoParcela.class);
    }
}

