/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.enumerable.EnumConverter;
import br.com.elotech.core.enumerable.EnumValues;
import br.com.elotech.core.utils.EnumUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TipoCadastro implements EnumConverter<TipoCadastro, Long>
{
    IMOBILIARIO(Long.valueOf(1L), "Imobili\u00e1rio", Boolean.FALSE),
    MOBILIARIO(Long.valueOf(2L), "Mobili\u00e1rio", Boolean.TRUE),
    RURAL(Long.valueOf(3L), "Rural", Boolean.FALSE),
    CEMITERIO(Long.valueOf(4L), "Cemit\u00e9rio", Boolean.FALSE),
    AGUA_ESGOTO(Long.valueOf(5L), "\u00c1gua / Esgoto", Boolean.FALSE),
    AVULSO(Long.valueOf(9L), "Avulso", Boolean.TRUE);

    private static final EnumValues<TipoCadastro, Long> VALUES;
    private final Long codigo;
    private final String descricao;
    private final Boolean permiteEmissaoDebitoISS;

    private TipoCadastro(Long codigo, String descricao, Boolean permiteEmissaoDebitoISS) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.permiteEmissaoDebitoISS = permiteEmissaoDebitoISS;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Boolean permiteEmissaoDebitoISS() {
        return this.permiteEmissaoDebitoISS;
    }

    @JsonValue
    public Long getValue() {
        return this.codigo;
    }

    @JsonCreator
    public static TipoCadastro fromValue(Long value) {
        return (TipoCadastro)VALUES.getEnum((Object)value);
    }

    public Boolean isMobiliario() {
        return TipoCadastro.MOBILIARIO.codigo == this.codigo;
    }

    public Boolean isImobiliario() {
        return TipoCadastro.IMOBILIARIO.codigo == this.codigo;
    }

    public Boolean isAvulso() {
        return TipoCadastro.AVULSO.codigo == this.codigo;
    }

    public Boolean isCemiterio() {
        return TipoCadastro.CEMITERIO.codigo == this.codigo;
    }

    public Boolean isRural() {
        return TipoCadastro.RURAL.codigo == this.codigo;
    }

    public Boolean isAguaEsgoto() {
        return TipoCadastro.AGUA_ESGOTO.codigo == this.codigo;
    }

    static {
        VALUES = EnumUtils.getEnumValuesMap(TipoCadastro.class);
    }
}

