/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoRepresentante;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.RepresentanteLegalDTO;
import br.com.elotech.tributos.dto.TipoRepresentanteDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.jsonwebtoken.lang.Assert;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribrepresentantelegal")
public class RepresentanteLegal
implements EloEntity<Long> {
    @Id
    @Column(name="idRepresentanteLegal")
    @EloSequence
    private Long id;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroMobiliario cadastroMobiliario;
    private LocalDate data;
    @ManyToOne
    @JoinColumn(name="pessoa", referencedColumnName="pessoa")
    private Pessoa pessoa;
    @ManyToOne
    @JoinColumn(name="TipoRepresentante", referencedColumnName="tipoRepresentante")
    private TipoRepresentante tipoRepresentante;

    public static RepresentanteLegal from(RepresentanteLegalDTO representanteLegalDTO) {
        Assert.notNull((Object)representanteLegalDTO.getCadastroMobiliario(), (String)"Erro ao fazer convers\u00e3o de dados: Id do cadastro mobili\u00e1rio est\u00e1 nulo.");
        RepresentanteLegal representanteLegal = new RepresentanteLegal();
        representanteLegal.setId(representanteLegalDTO.getId());
        representanteLegal.setData(representanteLegalDTO.getData());
        representanteLegal.setCadastroMobiliario(representanteLegalDTO.getCadastroMobiliario().toEntity());
        representanteLegal.setPessoa(representanteLegalDTO.getPessoa().toEntity());
        representanteLegal.setTipoRepresentante(TipoRepresentante.from((TipoRepresentanteDTO)representanteLegalDTO.getTipoRepresentante()));
        return representanteLegal;
    }

    public RepresentanteLegal merge(RepresentanteLegal representanteLegalToMerge) {
        this.setPessoa(representanteLegalToMerge.getPessoa());
        this.setData(representanteLegalToMerge.getData());
        this.setData(representanteLegalToMerge.getData());
        this.setTipoRepresentante(representanteLegalToMerge.getTipoRepresentante());
        return this;
    }

    @Generated
    public RepresentanteLegal() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CadastroMobiliario getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoRepresentante getTipoRepresentante() {
        return this.tipoRepresentante;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoRepresentante(TipoRepresentante tipoRepresentante) {
        this.tipoRepresentante = tipoRepresentante;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepresentanteLegal)) {
            return false;
        }
        RepresentanteLegal other = (RepresentanteLegal)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        CadastroMobiliario this$cadastroMobiliario = this.getCadastroMobiliario();
        CadastroMobiliario other$cadastroMobiliario = other.getCadastroMobiliario();
        if (this$cadastroMobiliario == null ? other$cadastroMobiliario != null : !this$cadastroMobiliario.equals(other$cadastroMobiliario)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        TipoRepresentante this$tipoRepresentante = this.getTipoRepresentante();
        TipoRepresentante other$tipoRepresentante = other.getTipoRepresentante();
        return !(this$tipoRepresentante == null ? other$tipoRepresentante != null : !this$tipoRepresentante.equals(other$tipoRepresentante));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RepresentanteLegal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        CadastroMobiliario $cadastroMobiliario = this.getCadastroMobiliario();
        result = result * 59 + ($cadastroMobiliario == null ? 43 : $cadastroMobiliario.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        TipoRepresentante $tipoRepresentante = this.getTipoRepresentante();
        result = result * 59 + ($tipoRepresentante == null ? 43 : $tipoRepresentante.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RepresentanteLegal(id=" + this.getId() + ", cadastroMobiliario=" + String.valueOf(this.getCadastroMobiliario()) + ", data=" + String.valueOf(this.getData()) + ", pessoa=" + String.valueOf(this.getPessoa()) + ", tipoRepresentante=" + String.valueOf(this.getTipoRepresentante()) + ")";
    }
}

