/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnore;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnoreProperties;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Vinculo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBPROPRIETARIO")
@Audited
public class Proprietario
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBPROPRIETARIO_ID")
    private Long id;
    @IndexedEmbedded
    @ManyToOne
    @NotNull
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Pessoa")
    @DiffRevisionIgnoreProperties(value={"id", "enderecos", "bancos", "contatos", "rg", "orgaoEmissor", "dataEmissao", "inscricaoEstadual", "sequenciaEndereco", "sequenciaContato", "sequenciaBanco", "contribuinte", "fornecedor", "pessoal", "dataInclusao", "observacao", "usuarioInclusao", "estadoEmissor", "microEmpresa", "dataAlteracao", "estrangeiro", "autonomo", "atividadePrincipal", "inscricaoMunicipal", "dataIssqn", "fornecedorSiscop", "codigoSistemaAnterior", "inativo", "sequenciaImagem", "activeFormOrigem", "dataNascimento", "nit", "nire", "pis", "dataAberturaCnpj", "idTcePR", "idUnico", "enderecoPrincipal", "contatoPrincipal", "contaBancariaPrincipal"})
    private Pessoa pessoa;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @ContainedIn
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", referencedColumnName="idkey", insertable=false, updatable=false)
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DiffRevisionIgnoreProperties(value={"tiposCadastro"})
    @Caption(value="V\u00ednculo")
    private Vinculo vinculo;
    @Caption(value="Percentual")
    @Min(value=0L)
    @Max(value=100L)
    private @Min(value=0L) @Max(value=100L) BigDecimal percentual = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Co-Respons\u00e1vel Principal")
    private Boolean coResponsavelPrincipal = Boolean.FALSE;
    @Transient
    private Boolean changed = Boolean.FALSE;

    public Boolean wasChanged() {
        return Boolean.TRUE.equals(this.changed);
    }

    public Boolean isPrincipal() {
        return Boolean.TRUE.equals(this.principal);
    }

    @DiffRevisionIgnore
    public Long getIdPessoa() {
        return Optional.ofNullable(this.pessoa).map(Pessoa::getId).orElse(null);
    }

    public void merge(Proprietario proprietario) {
        this.setPessoa(proprietario.getPessoa());
        this.setPrincipal(proprietario.getPrincipal());
        this.setVinculo(proprietario.getVinculo());
        this.setPercentual(proprietario.getPercentual());
        this.setCoResponsavelPrincipal(proprietario.getCoResponsavelPrincipal());
    }

    public Proprietario copy() {
        Proprietario proprietario = new Proprietario();
        BeanUtils.copyProperties((Object)this, (Object)proprietario, (String[])new String[]{"id", "cadastroGeral"});
        return proprietario;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proprietario)) {
            return false;
        }
        Proprietario other = (Proprietario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Proprietario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public Proprietario() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Vinculo getVinculo() {
        return this.vinculo;
    }

    @Generated
    public BigDecimal getPercentual() {
        return this.percentual;
    }

    @Generated
    public Boolean getCoResponsavelPrincipal() {
        return this.coResponsavelPrincipal;
    }

    @Generated
    public Boolean getChanged() {
        return this.changed;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setVinculo(Vinculo vinculo) {
        this.vinculo = vinculo;
    }

    @Generated
    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    @Generated
    public void setCoResponsavelPrincipal(Boolean coResponsavelPrincipal) {
        this.coResponsavelPrincipal = coResponsavelPrincipal;
    }

    @Generated
    public void setChanged(Boolean changed) {
        this.changed = changed;
    }

    @Generated
    public String toString() {
        return "Proprietario(id=" + this.getId() + ", pessoa=" + String.valueOf(this.getPessoa()) + ")";
    }
}

