/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Cbo;
import br.com.elotech.tributos.domain.ProfissionalId;
import br.com.elotech.tributos.domain.ProfissionalProfissao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="Profissional")
public class Profissional
implements EloEntity<ProfissionalId> {
    @EmbeddedId
    private ProfissionalId id;
    private Boolean autorProjeto;
    private LocalDate dataCadastro;
    private LocalDate dataIssqn;
    @Length(max=20)
    private @Length(max=20) String inscricaoIssqn;
    @Length(max=250)
    private @Length(max=250) String usuario;
    @JsonIgnore
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true)
    @JoinColumn(name="pessoa", insertable=false, updatable=false, nullable=false)
    @Caption(value="Profissional Profiss\u00f5es")
    private final List<ProfissionalProfissao> profissionalProfissoes = new ArrayList();

    @JsonIgnore
    public ProfissionalProfissao getProfissaoPrincipal() {
        if (Objects.equals(this.profissionalProfissoes.size(), 1)) {
            return this.profissionalProfissoes.stream().findFirst().orElse(null);
        }
        return this.profissionalProfissoes.stream().filter(ProfissionalProfissao::getPrincipal).findFirst().orElse(null);
    }

    public String getDescricaoProfissaoPrincipal() {
        return Optional.ofNullable(this.getProfissaoPrincipal()).filter(pp -> Objects.nonNull(pp.getCbo())).map(ProfissionalProfissao::getCbo).map(Cbo::getDescricao).orElse(this.id.getPessoa().getAtividadePrincipal());
    }

    public Long getNextSequencia() {
        return this.profissionalProfissoes.stream().map(ProfissionalProfissao::getSequencia).max(Long::compare).map(max -> max + 1L).orElse(1L);
    }

    @Generated
    public Profissional() {
    }

    @Generated
    public ProfissionalId getId() {
        return this.id;
    }

    @Generated
    public Boolean getAutorProjeto() {
        return this.autorProjeto;
    }

    @Generated
    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public LocalDate getDataIssqn() {
        return this.dataIssqn;
    }

    @Generated
    public String getInscricaoIssqn() {
        return this.inscricaoIssqn;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public List<ProfissionalProfissao> getProfissionalProfissoes() {
        return this.profissionalProfissoes;
    }

    @Generated
    public void setId(ProfissionalId id) {
        this.id = id;
    }

    @Generated
    public void setAutorProjeto(Boolean autorProjeto) {
        this.autorProjeto = autorProjeto;
    }

    @Generated
    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataIssqn(LocalDate dataIssqn) {
        this.dataIssqn = dataIssqn;
    }

    @Generated
    public void setInscricaoIssqn(String inscricaoIssqn) {
        this.inscricaoIssqn = inscricaoIssqn;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Profissional)) {
            return false;
        }
        Profissional other = (Profissional)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$autorProjeto = this.getAutorProjeto();
        Boolean other$autorProjeto = other.getAutorProjeto();
        if (this$autorProjeto == null ? other$autorProjeto != null : !((Object)this$autorProjeto).equals(other$autorProjeto)) {
            return false;
        }
        ProfissionalId this$id = this.getId();
        ProfissionalId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDate this$dataCadastro = this.getDataCadastro();
        LocalDate other$dataCadastro = other.getDataCadastro();
        if (this$dataCadastro == null ? other$dataCadastro != null : !((Object)this$dataCadastro).equals(other$dataCadastro)) {
            return false;
        }
        LocalDate this$dataIssqn = this.getDataIssqn();
        LocalDate other$dataIssqn = other.getDataIssqn();
        if (this$dataIssqn == null ? other$dataIssqn != null : !((Object)this$dataIssqn).equals(other$dataIssqn)) {
            return false;
        }
        String this$inscricaoIssqn = this.getInscricaoIssqn();
        String other$inscricaoIssqn = other.getInscricaoIssqn();
        if (this$inscricaoIssqn == null ? other$inscricaoIssqn != null : !this$inscricaoIssqn.equals(other$inscricaoIssqn)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        List this$profissionalProfissoes = this.getProfissionalProfissoes();
        List other$profissionalProfissoes = other.getProfissionalProfissoes();
        return !(this$profissionalProfissoes == null ? other$profissionalProfissoes != null : !((Object)this$profissionalProfissoes).equals(other$profissionalProfissoes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Profissional;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autorProjeto = this.getAutorProjeto();
        result = result * 59 + ($autorProjeto == null ? 43 : ((Object)$autorProjeto).hashCode());
        ProfissionalId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDate $dataCadastro = this.getDataCadastro();
        result = result * 59 + ($dataCadastro == null ? 43 : ((Object)$dataCadastro).hashCode());
        LocalDate $dataIssqn = this.getDataIssqn();
        result = result * 59 + ($dataIssqn == null ? 43 : ((Object)$dataIssqn).hashCode());
        String $inscricaoIssqn = this.getInscricaoIssqn();
        result = result * 59 + ($inscricaoIssqn == null ? 43 : $inscricaoIssqn.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        List $profissionalProfissoes = this.getProfissionalProfissoes();
        result = result * 59 + ($profissionalProfissoes == null ? 43 : ((Object)$profissionalProfissoes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Profissional(id=" + String.valueOf(this.getId()) + ", autorProjeto=" + this.getAutorProjeto() + ", dataCadastro=" + String.valueOf(this.getDataCadastro()) + ", dataIssqn=" + String.valueOf(this.getDataIssqn()) + ", inscricaoIssqn=" + this.getInscricaoIssqn() + ", usuario=" + this.getUsuario() + ", profissionalProfissoes=" + String.valueOf(this.getProfissionalProfissoes()) + ")";
    }
}

