/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.PagNegDebOrigemId;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import br.com.elotech.tributos.dto.DadosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.FiltroPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoSituacaoEnum;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.enums.negociacaodebito.TipoNegociacao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="TRIBPGTONEGOCIADO")
public class PagamentoNegociado
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="pgtonegociado")
    @EloSequence(applyOnMerge=true, sequenceName="s05pgtonegociado")
    private Long id;
    private Long entidade;
    private String observacao;
    private BigDecimal valorNegociado = BigDecimal.ZERO;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="contaBancaria", referencedColumnName="contaBancaria"))})
    private ContaBancaria contaBancaria;
    private LocalDate dataCredito;
    private PagamentoNegociadoSituacaoEnum cancelado;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidadePagamentoGerado", referencedColumnName="entidade"), @JoinColumn(name="exercicioPagamentoGerado", referencedColumnName="exercicioPagamento"), @JoinColumn(name="pagamentoGerado", referencedColumnName="pagamento")})
    private Pagamento pagamentoGerado;
    @ManyToOne
    @JoinColumn(name="idboletogerado", referencedColumnName="idkey")
    @JsonIncludeProperties(value={"id", "bloqueto", "exercicioBloqueto, entidade"})
    private Bloqueto boletoGerado;
    private String cadastroGeralfiltro;
    private String tipoCadastrofiltro;
    private String exercicioFiltro;
    private String guiaRecolhimentoFiltro;
    private String subDividaFiltro;
    private String parcelaFiltro;
    private String creditoFiltro;
    private Long cda;
    private Long exercicioCDA;
    private Long situacaoLegal;
    private Long motivoDesconto;
    private LocalDate dataReferencia;
    private LocalDate venctoInicial;
    private LocalDate venctoFinal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="convenio", referencedColumnName="convenio"))})
    private Convenio convenio;
    private LocalDate dataNegociacao;
    private String usuario;
    private String usuarioCancelamento;
    private LocalDate dataCancelamento;
    private String motivoCancelamento;
    private BigDecimal valorDebitoBaixado;
    private BigDecimal valorDebitoNovo;
    @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20")
    private @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20") String processoSei;
    @Length(max=30, message="Tamanho m\u00e1ximo do Processo Judicial \u00e9 30")
    private @Length(max=30, message="Tamanho m\u00e1ximo do Processo Judicial \u00e9 30") String processoJudicial;
    @Enumerated(value=EnumType.STRING)
    private TipoNegociacao tipoNegociacao;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="pagamentoNegociado", orphanRemoval=true)
    private List<PagamentoNegociadoDebOrigem> debitosOrigem = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="pgtonegociado", referencedColumnName="pgtonegociado")
    private List<PagamentoNegociadoDebNovo> debitosNovos = new ArrayList();

    public static PagamentoNegociado from(ParametrosPagamentoNegociadoDTO parametros, PagamentoNegociadoSituacaoEnum situacao) {
        PagamentoNegociado pagamentoNegociado = new PagamentoNegociado();
        FiltroPagamentoNegociadoDTO filtro = parametros.getFiltro();
        DadosPagamentoNegociadoDTO dadosPagamento = parametros.getDadosPagamento();
        Optional.ofNullable(filtro.getDataVencimentoInicial()).ifPresent(arg_0 -> pagamentoNegociado.setVenctoInicial(arg_0));
        Optional.ofNullable(filtro.getDataVencimentoFinal()).ifPresent(arg_0 -> pagamentoNegociado.setVenctoFinal(arg_0));
        Optional.ofNullable(filtro.getSituacaoLegal()).ifPresent(arg_0 -> pagamentoNegociado.setSituacaoLegal(arg_0));
        Optional.ofNullable(filtro.getNumeroCDA()).ifPresent(arg_0 -> pagamentoNegociado.setCda(arg_0));
        Optional.ofNullable(filtro.getExercicio()).ifPresent(arg_0 -> pagamentoNegociado.setExercicioFiltro(arg_0));
        Optional.ofNullable(filtro.getSubDivida()).ifPresent(arg_0 -> pagamentoNegociado.setSubDividaFiltro(arg_0));
        Optional.ofNullable(filtro.getAnoCDA()).ifPresent(arg_0 -> pagamentoNegociado.setExercicioCDA(arg_0));
        Optional.ofNullable(filtro.getDivida()).ifPresent(arg_0 -> pagamentoNegociado.setGuiaRecolhimentoFiltro(arg_0));
        Optional.ofNullable(filtro.getParcela()).ifPresent(arg_0 -> pagamentoNegociado.setParcelaFiltro(arg_0));
        Optional.ofNullable(filtro.getParcela()).ifPresent(arg_0 -> pagamentoNegociado.setParcelaFiltro(arg_0));
        Optional.ofNullable(filtro.getCadastroGeral()).ifPresent(cadastroGeral -> pagamentoNegociado.setCadastroGeralfiltro(cadastroGeral.toString()));
        Optional.ofNullable(filtro.getTipoCadastro()).ifPresent(tipoCadastro -> pagamentoNegociado.setTipoCadastrofiltro(tipoCadastro.toString()));
        Optional.ofNullable(filtro.getDataReferencia()).ifPresent(arg_0 -> pagamentoNegociado.setDataReferencia(arg_0));
        Optional.ofNullable(dadosPagamento.getDtNegociacao()).ifPresent(arg_0 -> pagamentoNegociado.setDataNegociacao(arg_0));
        Optional.ofNullable(dadosPagamento.getMotivo()).ifPresent(motivo -> pagamentoNegociado.setMotivoDesconto(motivo.getId()));
        Optional.ofNullable(dadosPagamento.getValorNegociado()).ifPresent(arg_0 -> pagamentoNegociado.setValorNegociado(arg_0));
        Optional.ofNullable(dadosPagamento.getDataCredito()).ifPresent(arg_0 -> pagamentoNegociado.setDataCredito(arg_0));
        Optional.ofNullable(dadosPagamento.getUsuario()).ifPresent(arg_0 -> pagamentoNegociado.setUsuario(arg_0));
        Optional.ofNullable(dadosPagamento.getObservacao()).ifPresent(arg_0 -> pagamentoNegociado.setObservacao(arg_0));
        Optional.ofNullable(filtro.getTipoNegociacao()).ifPresent(arg_0 -> pagamentoNegociado.setTipoNegociacao(arg_0));
        pagamentoNegociado.setCancelado(situacao);
        return pagamentoNegociado;
    }

    public static PagamentoNegociado from(ParametrosPagamentoNegociadoDTO parametros, Convenio convenio) {
        PagamentoNegociado pagamentoNegociado = PagamentoNegociado.from((ParametrosPagamentoNegociadoDTO)parametros, (PagamentoNegociadoSituacaoEnum)PagamentoNegociadoSituacaoEnum.EFETIVADO);
        pagamentoNegociado.setContaBancaria(convenio.getContaBancaria());
        pagamentoNegociado.setConvenio(convenio);
        return pagamentoNegociado;
    }

    public static PagamentoNegociado from(ParametrosPagamentoNegociadoDTO parametros, Bloqueto boleto) {
        PagamentoNegociado pagamentoNegociado = PagamentoNegociado.from((ParametrosPagamentoNegociadoDTO)parametros, (PagamentoNegociadoSituacaoEnum)PagamentoNegociadoSituacaoEnum.ABERTO);
        pagamentoNegociado.setBoletoGerado(boleto);
        pagamentoNegociado.setContaBancaria(boleto.getModeloBloqueto().getConvenio().getContaBancaria());
        pagamentoNegociado.setConvenio(boleto.getModeloBloqueto().getConvenio());
        pagamentoNegociado.setProcessoSei(parametros.getDadosPagamento().getProcessoSei());
        pagamentoNegociado.setProcessoJudicial(parametros.getDadosPagamento().getProcessoJudicial());
        pagamentoNegociado.setTipoNegociacao(parametros.getFiltro().getTipoNegociacao());
        return pagamentoNegociado;
    }

    @JsonIgnore
    public String getParcelasOrigemWithCommaByDebito(Long idDebito) {
        return this.debitosOrigem.stream().filter(p -> Objects.equals(p.getId().getDebitoParcela().getDebito().getId(), idDebito)).map(p -> String.valueOf(p.getId().getDebitoParcela().getId().getParcela())).collect(Collectors.joining(", "));
    }

    @JsonIgnore
    public List<DebitoParcela> getParcelasOrigem() {
        return this.debitosOrigem.stream().map(PagamentoNegociadoDebOrigem::getId).map(PagNegDebOrigemId::getDebitoParcela).collect(Collectors.toList());
    }

    @Generated
    public PagamentoNegociado() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public BigDecimal getValorNegociado() {
        return this.valorNegociado;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public PagamentoNegociadoSituacaoEnum getCancelado() {
        return this.cancelado;
    }

    @Generated
    public Pagamento getPagamentoGerado() {
        return this.pagamentoGerado;
    }

    @Generated
    public Bloqueto getBoletoGerado() {
        return this.boletoGerado;
    }

    @Generated
    public String getCadastroGeralfiltro() {
        return this.cadastroGeralfiltro;
    }

    @Generated
    public String getTipoCadastrofiltro() {
        return this.tipoCadastrofiltro;
    }

    @Generated
    public String getExercicioFiltro() {
        return this.exercicioFiltro;
    }

    @Generated
    public String getGuiaRecolhimentoFiltro() {
        return this.guiaRecolhimentoFiltro;
    }

    @Generated
    public String getSubDividaFiltro() {
        return this.subDividaFiltro;
    }

    @Generated
    public String getParcelaFiltro() {
        return this.parcelaFiltro;
    }

    @Generated
    public String getCreditoFiltro() {
        return this.creditoFiltro;
    }

    @Generated
    public Long getCda() {
        return this.cda;
    }

    @Generated
    public Long getExercicioCDA() {
        return this.exercicioCDA;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getMotivoDesconto() {
        return this.motivoDesconto;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public LocalDate getVenctoInicial() {
        return this.venctoInicial;
    }

    @Generated
    public LocalDate getVenctoFinal() {
        return this.venctoFinal;
    }

    @Generated
    public Convenio getConvenio() {
        return this.convenio;
    }

    @Generated
    public LocalDate getDataNegociacao() {
        return this.dataNegociacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public BigDecimal getValorDebitoBaixado() {
        return this.valorDebitoBaixado;
    }

    @Generated
    public BigDecimal getValorDebitoNovo() {
        return this.valorDebitoNovo;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public String getProcessoJudicial() {
        return this.processoJudicial;
    }

    @Generated
    public TipoNegociacao getTipoNegociacao() {
        return this.tipoNegociacao;
    }

    @Generated
    public List<PagamentoNegociadoDebOrigem> getDebitosOrigem() {
        return this.debitosOrigem;
    }

    @Generated
    public List<PagamentoNegociadoDebNovo> getDebitosNovos() {
        return this.debitosNovos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setValorNegociado(BigDecimal valorNegociado) {
        this.valorNegociado = valorNegociado;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setCancelado(PagamentoNegociadoSituacaoEnum cancelado) {
        this.cancelado = cancelado;
    }

    @Generated
    public void setPagamentoGerado(Pagamento pagamentoGerado) {
        this.pagamentoGerado = pagamentoGerado;
    }

    @Generated
    public void setBoletoGerado(Bloqueto boletoGerado) {
        this.boletoGerado = boletoGerado;
    }

    @Generated
    public void setCadastroGeralfiltro(String cadastroGeralfiltro) {
        this.cadastroGeralfiltro = cadastroGeralfiltro;
    }

    @Generated
    public void setTipoCadastrofiltro(String tipoCadastrofiltro) {
        this.tipoCadastrofiltro = tipoCadastrofiltro;
    }

    @Generated
    public void setExercicioFiltro(String exercicioFiltro) {
        this.exercicioFiltro = exercicioFiltro;
    }

    @Generated
    public void setGuiaRecolhimentoFiltro(String guiaRecolhimentoFiltro) {
        this.guiaRecolhimentoFiltro = guiaRecolhimentoFiltro;
    }

    @Generated
    public void setSubDividaFiltro(String subDividaFiltro) {
        this.subDividaFiltro = subDividaFiltro;
    }

    @Generated
    public void setParcelaFiltro(String parcelaFiltro) {
        this.parcelaFiltro = parcelaFiltro;
    }

    @Generated
    public void setCreditoFiltro(String creditoFiltro) {
        this.creditoFiltro = creditoFiltro;
    }

    @Generated
    public void setCda(Long cda) {
        this.cda = cda;
    }

    @Generated
    public void setExercicioCDA(Long exercicioCDA) {
        this.exercicioCDA = exercicioCDA;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setMotivoDesconto(Long motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setVenctoInicial(LocalDate venctoInicial) {
        this.venctoInicial = venctoInicial;
    }

    @Generated
    public void setVenctoFinal(LocalDate venctoFinal) {
        this.venctoFinal = venctoFinal;
    }

    @Generated
    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setDataNegociacao(LocalDate dataNegociacao) {
        this.dataNegociacao = dataNegociacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setValorDebitoBaixado(BigDecimal valorDebitoBaixado) {
        this.valorDebitoBaixado = valorDebitoBaixado;
    }

    @Generated
    public void setValorDebitoNovo(BigDecimal valorDebitoNovo) {
        this.valorDebitoNovo = valorDebitoNovo;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setProcessoJudicial(String processoJudicial) {
        this.processoJudicial = processoJudicial;
    }

    @Generated
    public void setTipoNegociacao(TipoNegociacao tipoNegociacao) {
        this.tipoNegociacao = tipoNegociacao;
    }

    @Generated
    public void setDebitosOrigem(List<PagamentoNegociadoDebOrigem> debitosOrigem) {
        this.debitosOrigem = debitosOrigem;
    }

    @Generated
    public void setDebitosNovos(List<PagamentoNegociadoDebNovo> debitosNovos) {
        this.debitosNovos = debitosNovos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoNegociado)) {
            return false;
        }
        PagamentoNegociado other = (PagamentoNegociado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoNegociado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoNegociado(id=" + this.getId() + ")";
    }
}

