/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.NossoNumero;
import br.com.elotech.tributos.domain.NossoNumeroFebraban;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.service.exception.NossoNumeroException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class NossoNumeroSicoob
implements NossoNumero {
    private static final String INDICE = "3197319731973197319731973";

    public CodigoBarrasDTO gerar(Bloqueto boleto) {
        this.validaDadosNossoNumero(boleto);
        CodigoBarrasDTO dto = new CodigoBarrasDTO();
        dto.setNossoNumero(boleto.getNossoNumero());
        dto.setDvNossoNumero(this.gerarDVNossoNumero(boleto));
        NossoNumeroFebraban nossoNumeroFebraban = new NossoNumeroFebraban();
        nossoNumeroFebraban.validaDadosGeracaoCodigoBarras(boleto);
        dto.setCodigoBarras(nossoNumeroFebraban.getCodigoBarras(boleto));
        nossoNumeroFebraban.loadCamposLinhaDigitavel(dto);
        return dto;
    }

    public String gerarDVNossoNumero(Bloqueto boleto) {
        Integer soma = 0;
        StringBuilder sequencia = new StringBuilder();
        sequencia.append(StringUtils.leftPad((String)boleto.getModeloBloqueto().getConvenio().getContaBancaria().getAgencia().getAgencia(), (int)4, (String)"0"));
        sequencia.append(StringUtils.leftPad((String)boleto.getModeloBloqueto().getConvenio().getCodigoCedente(), (int)10, (String)"0"));
        sequencia.append(boleto.getNossoNumero());
        for (int i = 0; i < sequencia.toString().length(); ++i) {
            soma = soma + Character.getNumericValue(sequencia.toString().charAt(i)) * Character.getNumericValue(INDICE.charAt(i));
        }
        Integer restoDiv = soma % 11;
        Integer DV = 11 - restoDiv;
        return restoDiv == 0 || restoDiv == 1 ? "0" : DV.toString();
    }

    private void validaDadosNossoNumero(Bloqueto boleto) {
        if (!Optional.ofNullable(boleto.getModeloBloqueto()).isPresent()) {
            throw NossoNumeroException.modeloBoletoNotFound();
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio()).isPresent()) {
            throw NossoNumeroException.convenioNotFound((Long)boleto.getModeloBloqueto().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getBanco()).isPresent()) {
            throw NossoNumeroException.bancoNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getCodigoCedente()).isPresent() || boleto.getModeloBloqueto().getConvenio().getCodigoCedente().isEmpty()) {
            throw NossoNumeroException.codigoCedenteNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getCarteira()).isPresent() || boleto.getModeloBloqueto().getConvenio().getCarteira().isEmpty()) {
            throw NossoNumeroException.carteiraNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getContaBancaria()).isPresent()) {
            throw NossoNumeroException.contaBancariaNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getContaBancaria().getAgencia()).isPresent() || boleto.getModeloBloqueto().getConvenio().getContaBancaria().getAgencia().getAgencia().isEmpty()) {
            throw NossoNumeroException.agenciaNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
    }
}

