/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.caelum.stella.boleto.bancos.gerador.GeradorDeDigitoPadrao;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.NossoNumero;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.service.exception.CodigoBarrasException;
import br.com.elotech.tributos.service.exception.ConvenioBoletoNotFoundException;
import br.com.elotech.tributos.service.exception.ModeloBoletoNotFoundException;
import br.com.elotech.tributos.service.exception.NossoNumeroException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class NossoNumeroFebraban
implements NossoNumero {
    public static final String INICIO_LINHADIGITAVEL_ARRECADACAO = "8";

    public CodigoBarrasDTO gerar(Bloqueto boleto) {
        this.validaDadosNossoNumero(boleto);
        this.validaDadosGeracaoCodigoBarras(boleto);
        CodigoBarrasDTO dto = new CodigoBarrasDTO();
        dto.setNossoNumero(this.getNossoNumero(boleto));
        dto.setCodigoBarras(this.getCodigoBarras(boleto));
        this.loadCamposLinhaDigitavel(dto);
        return dto;
    }

    private void validaDadosNossoNumero(Bloqueto boleto) {
        if (!Optional.ofNullable(boleto.getEntidade()).isPresent()) {
            throw NossoNumeroException.entidadeNotDefined();
        }
        if (!Optional.ofNullable(boleto.getExercicioBloqueto()).isPresent()) {
            throw NossoNumeroException.exercicioBoletoNotFound();
        }
        if (!Optional.ofNullable(boleto.getBloqueto()).isPresent()) {
            throw NossoNumeroException.numeroBoletoNotFound();
        }
    }

    private String getNossoNumero(Bloqueto boleto) {
        if (TipoCodigoBarras.DAM_SEGMENTO_9.equals((Object)TipoCodigoBarras.fromValue((Long)boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras().getValue()))) {
            return boleto.getEntidade().toString() + boleto.getExercicioBloqueto().toString().substring(2, 4) + StringUtils.leftPad((String)boleto.getBloqueto().toString(), (int)10, (String)"0");
        }
        return boleto.getEntidade().toString() + boleto.getExercicioBloqueto().toString().substring(2, 4) + StringUtils.leftPad((String)boleto.getBloqueto().toString(), (int)14, (String)"0");
    }

    void loadCamposLinhaDigitavel(CodigoBarrasDTO dto) {
        dto.setCampo1(dto.getCodigoBarras().substring(0, 11).concat(this.geraDigitoVerificadorMod10(dto.getCodigoBarras().substring(0, 11))));
        dto.setCampo2(dto.getCodigoBarras().substring(11, 22).concat(this.geraDigitoVerificadorMod10(dto.getCodigoBarras().substring(11, 22))));
        dto.setCampo3(dto.getCodigoBarras().substring(22, 33).concat(this.geraDigitoVerificadorMod10(dto.getCodigoBarras().substring(22, 33))));
        dto.setCampo4(dto.getCodigoBarras().substring(33).concat(this.geraDigitoVerificadorMod10(dto.getCodigoBarras().substring(30))));
        dto.setCampo5(null);
        dto.setLinhaDigitavel(dto.getCampo1().concat(dto.getCampo2()).concat(dto.getCampo3()).concat(dto.getCampo4()));
    }

    String getCodigoBarras(Bloqueto boleto) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String dataVencimento = StringUtils.leftPad((String)LocalDate.parse(boleto.getDataVencimento().toString(), formatter).toString(), (int)8, (String)"0").replaceAll("\\D", "");
        String linhaDigitavel = INICIO_LINHADIGITAVEL_ARRECADACAO.concat(StringUtils.leftPad((String)boleto.getModeloBloqueto().getCodigoBarras().getSegmento().replaceAll("\\D", ""), (int)1, (String)"0")).concat(StringUtils.leftPad((String)boleto.getModeloBloqueto().getCodigoBarras().getMoeda().replaceAll("\\D", ""), (int)1, (String)"0")).concat(StringUtils.leftPad((String)this.getValorFormatado(boleto.calculaValorBoleto()).replaceAll("\\D", ""), (int)11, (String)"0")).concat(this.getCampoLivre(boleto)).concat(dataVencimento).concat(this.getNossoNumero(boleto));
        String digitoVerificador = this.geraDigitoVerificadorMod10(linhaDigitavel);
        return linhaDigitavel.substring(0, 3).concat(digitoVerificador).concat(linhaDigitavel.substring(3)).replaceAll("\\D", "");
    }

    void validaDadosGeracaoCodigoBarras(Bloqueto boleto) {
        if (!Optional.ofNullable(boleto.getModeloBloqueto()).isPresent()) {
            throw new ModeloBoletoNotFoundException();
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio()).isPresent()) {
            throw new ConvenioBoletoNotFoundException(boleto.getModeloBloqueto().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getCodigoBarras()).isPresent()) {
            throw CodigoBarrasException.codigoBarrasNaoConfigurado((Long)boleto.getModeloBloqueto().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getCodigoBarras().getMoeda()).isPresent() || boleto.getModeloBloqueto().getCodigoBarras().getMoeda().isEmpty()) {
            throw CodigoBarrasException.moedaNotfound((Long)boleto.getModeloBloqueto().getCodigoBarras().getId());
        }
        if (!Optional.ofNullable(boleto.calculaValorBoleto()).isPresent()) {
            throw BoletoException.valorBoletoNotFound();
        }
        if (boleto.calculaValorBoleto().compareTo(BigDecimal.ZERO) <= 0) {
            throw BoletoException.valorBoletoDeveSerMaiorZero();
        }
        if (!Optional.ofNullable(boleto.getDataVencimento()).isPresent()) {
            throw BoletoException.dataVencimentoNotFound();
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getCodigoCedente()).isPresent() || boleto.getModeloBloqueto().getConvenio().getCodigoCedente().isEmpty()) {
            throw NossoNumeroException.codigoCedenteNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
    }

    public String geraDigitoVerificadorMod10(String campo) {
        GeradorDeDigitoPadrao geradorDeDigito = new GeradorDeDigitoPadrao();
        return Integer.toString(geradorDeDigito.geraDigitoMod10(campo));
    }

    private String getCampoLivre(Bloqueto boleto) {
        return StringUtils.leftPad((String)boleto.getModeloBloqueto().getConvenio().getCodigoCedente().replaceAll("\\D", ""), (int)4, (String)"0");
    }

    private String getValorFormatado(BigDecimal valor) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setGroupingUsed(false);
        return df.format(valor);
    }
}

