/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.NossoNumero;
import br.com.elotech.tributos.domain.NossoNumeroFebraban;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.service.exception.NossoNumeroException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class NossoNumeroBradesco
implements NossoNumero {
    public CodigoBarrasDTO gerar(Bloqueto boleto) {
        String nossoNumero = this.gerarNossoNumero(boleto);
        String dv = this.gerarDVNossoNumero(boleto.getModeloBloqueto().getConvenio().getCarteira(), nossoNumero);
        CodigoBarrasDTO dto = new CodigoBarrasDTO();
        dto.setNossoNumero(nossoNumero);
        dto.setDvNossoNumero(dv);
        NossoNumeroFebraban nossoNumeroFebraban = new NossoNumeroFebraban();
        nossoNumeroFebraban.validaDadosGeracaoCodigoBarras(boleto);
        dto.setCodigoBarras(nossoNumeroFebraban.getCodigoBarras(boleto));
        nossoNumeroFebraban.loadCamposLinhaDigitavel(dto);
        return dto;
    }

    private void validaDadosNossoNumero(Bloqueto boleto) {
        if (Optional.ofNullable(boleto.getEntidade()).isEmpty()) {
            throw NossoNumeroException.entidadeNotDefined();
        }
        if (Optional.ofNullable(boleto.getExercicioBloqueto()).isEmpty()) {
            throw NossoNumeroException.exercicioBoletoNotFound();
        }
        if (Optional.ofNullable(boleto.getBloqueto()).isEmpty()) {
            throw NossoNumeroException.numeroBoletoNotFound();
        }
        if (Optional.ofNullable(boleto.getModeloBloqueto()).isEmpty()) {
            throw NossoNumeroException.modeloBoletoNotFound();
        }
        if (Optional.ofNullable(boleto.getModeloBloqueto().getConvenio()).isEmpty()) {
            throw NossoNumeroException.convenioNotFound((Long)boleto.getModeloBloqueto().getId());
        }
    }

    public String gerarNossoNumero(Bloqueto boleto) {
        this.validaDadosNossoNumero(boleto);
        Long numeroBoleto = boleto.getBloqueto();
        Long exercicioBoleto = boleto.getExercicioBloqueto();
        String anoIdentificador = exercicioBoleto.toString().substring(2, 4).concat(StringUtils.leftPad((String)numeroBoleto.toString(), (int)8, (String)"0"));
        return boleto.getEntidade().toString().concat(anoIdentificador);
    }

    public String gerarDVNossoNumero(String carteira, String nossoNumero) {
        this.validaDigitoVerificadorBradesco(carteira, nossoNumero);
        String vsNossoNumero = StringUtils.leftPad((String)carteira, (int)2, (String)"0").concat(nossoNumero);
        Integer valorMultiplicador = 2;
        Integer viSoma = 0;
        for (int i = 0; i < vsNossoNumero.length(); ++i) {
            viSoma = viSoma + Character.getNumericValue(vsNossoNumero.charAt(i)) * valorMultiplicador;
            valorMultiplicador = valorMultiplicador == 2 ? 7 : valorMultiplicador - 1;
        }
        Integer viResto = viSoma % 11;
        return this.getResult(viResto);
    }

    private String getResult(Integer viResto) {
        if (Objects.equals(viResto, 0)) {
            return "0";
        }
        if (Objects.equals(viResto, 1)) {
            return "P";
        }
        return String.valueOf(11 - viResto);
    }

    private void validaDigitoVerificadorBradesco(String carteira, String nossoNumero) {
        if (StringUtils.isBlank((String)carteira)) {
            throw new EloValidationException("Necess\u00e1rio informar a carteira para o c\u00e1lculo do digito verificador");
        }
        if (StringUtils.isBlank((String)nossoNumero)) {
            throw new EloValidationException("Nosso N\u00famero n\u00e3o pode ser nullo para o c\u00e1lculo do digito verificador");
        }
    }
}

