/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.BancoDoBrasil;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.NossoNumero;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.service.exception.NossoNumeroException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class NossoNumeroBancoBrasil
implements NossoNumero {
    private String getNossoNumero(Bloqueto boleto) {
        if (TipoCodigoBarras.BOLETO_BANCARIO_BB_CONVENIO_7_POSICOES.equals((Object)TipoCodigoBarras.fromValue((Long)boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras().getValue()))) {
            return boleto.getModeloBloqueto().getConvenio().getNumeroConvenio().concat(StringUtils.leftPad((String)boleto.getEntidade().toString(), (int)1, (String)"0")).concat(boleto.getExercicioBloqueto().toString().substring(2, 4)).concat(StringUtils.leftPad((String)boleto.getBloqueto().toString(), (int)7, (String)"0"));
        }
        return boleto.getModeloBloqueto().getConvenio().getNumeroConvenio().concat(StringUtils.leftPad((String)Optional.ofNullable(boleto.getId()).map(String::valueOf).orElse(""), (int)5, (String)"0"));
    }

    public CodigoBarrasDTO gerar(Bloqueto boleto) {
        this.validaDadosNossoNumero(boleto);
        CodigoBarrasDTO dto = new CodigoBarrasDTO();
        dto.setNossoNumero(this.getNossoNumero(boleto));
        Boleto novoBoleto = this.getNovoBoleto(boleto, (Banco)new BancoDoBrasil(), dto.getNossoNumero());
        dto.setLinhaDigitavel(novoBoleto.getLinhaDigitavel().replaceAll("\\D", ""));
        this.getNossoNumeroFormatado(boleto.getModeloBloqueto().getConvenio().getNumeroConvenio(), boleto.getModeloBloqueto().getConvenio().getTipoCodigoBarras(), dto);
        dto.setCodigoBarras(novoBoleto.getCodigoDeBarras());
        this.loadCamposLinhaDigitavel(dto);
        return dto;
    }

    private void validaDadosNossoNumero(Bloqueto boleto) {
        if (!Optional.ofNullable(boleto.getModeloBloqueto()).isPresent()) {
            throw NossoNumeroException.modeloBoletoNotFound();
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio()).isPresent()) {
            throw NossoNumeroException.convenioNotFound((Long)boleto.getModeloBloqueto().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getBanco()).isPresent()) {
            throw NossoNumeroException.bancoNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getNumeroConvenio()).isPresent() || boleto.getModeloBloqueto().getConvenio().getNumeroConvenio().isEmpty()) {
            throw NossoNumeroException.numeroConvenioNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
        if (!Optional.ofNullable(boleto.getModeloBloqueto().getConvenio().getCarteira()).isPresent() || boleto.getModeloBloqueto().getConvenio().getCarteira().isEmpty()) {
            throw NossoNumeroException.carteiraNotFound((Long)boleto.getModeloBloqueto().getConvenio().getId());
        }
        if (!Optional.ofNullable(boleto.getDataEmissao()).isPresent()) {
            throw NossoNumeroException.dataEmissaoNotFound();
        }
        if (!Optional.ofNullable(boleto.getDataVencimento()).isPresent()) {
            throw BoletoException.dataVencimentoNotFound();
        }
    }

    private void loadCamposLinhaDigitavel(CodigoBarrasDTO dto) {
        dto.setCampo1(dto.getLinhaDigitavel().substring(0, 10));
        dto.setCampo2(dto.getLinhaDigitavel().substring(10, 21));
        dto.setCampo3(dto.getLinhaDigitavel().substring(21, 32));
        dto.setCampo4(dto.getLinhaDigitavel().substring(32, 33));
        dto.setCampo5(dto.getLinhaDigitavel().substring(33, 47));
    }

    private void getNossoNumeroFormatado(String numeroConvenio, TipoCodigoBarras tipoCodigoBarras, CodigoBarrasDTO dto) {
        if (tipoCodigoBarras.equals((Object)TipoCodigoBarras.BOLETO_BANCARIO_BB_CONVENIO_7_POSICOES)) {
            dto.setNossoNumero(StringUtils.leftPad((String)numeroConvenio, (int)7, (String)"0").concat(dto.getNossoNumero()));
        }
    }
}

