/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnore;
import br.com.elotech.core.jpa.hibernate.envers.DiffRevisionIgnoreProperties;
import br.com.elotech.core.metamodel.annotation.CalculatedModel;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.TipoLogradouro;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.validator.constraints.Length;

@Entity(name="logradouro")
public class Logradouro
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_LOGRADOURO_ID")
    private Long id;
    @ManyToOne
    @Caption(value="Cidade")
    @NotNull
    @DiffRevisionIgnoreProperties(value={"id", "pais", "descricaoAbreviada", "codigoNacional", "ativa", "dataCriacao", "programa", "usuario", "idunico"})
    private Cidade cidade;
    @Caption(value="C\u00f3digo do Logradouro")
    @Field(analyze=Analyze.NO)
    @FieldBridge(impl=LongBridge.class)
    private Long logradouro;
    @ManyToOne
    @JoinColumn(name="tipologradouro")
    @Caption(value="Tipo Logradouro")
    private TipoLogradouro tipoLogradouro;
    @Field
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    @SortableField
    private @Length(max=100) String descricao;
    @Caption(value="Correto")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean correto = Boolean.FALSE;
    @Length(max=60)
    @Caption(value="Localiza\u00e7\u00e3o")
    private @Length(max=60) String localizacao;
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o Logradouro Inicio")
    private @Length(max=100) String descLogradouroInicio;
    @Caption(value="Inativo")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean inativo;
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o Anterior")
    private @Length(max=100) String descricaoAnterior;
    @Caption(value="Logradouro Inicio")
    private Long logradouroInicio;
    @Caption(value="Data Cria\u00e7\u00e3o")
    private LocalDate dataCriacao;
    @Length(max=100)
    @Caption(value="Programa")
    private @Length(max=100) String programa;
    @Length(max=250)
    @Caption(value="Usu\u00e1rio")
    private @Length(max=250) String usuario;
    @Caption(value="ID \u00danico")
    private Long idunico;

    @CalculatedModel(fieldPath="tipoLogradouroDescricao", caption="Descri\u00e7\u00e3o do Tipo de Logradouro")
    @DiffRevisionIgnore
    public String getTipoLogradouroDescricao() {
        if (this.getTipoLogradouro() == null) {
            return "";
        }
        return this.getTipoLogradouro().getDescricao();
    }

    @Generated
    public Logradouro() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public Long getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public TipoLogradouro getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getCorreto() {
        return this.correto;
    }

    @Generated
    public String getLocalizacao() {
        return this.localizacao;
    }

    @Generated
    public String getDescLogradouroInicio() {
        return this.descLogradouroInicio;
    }

    @Generated
    public Boolean getInativo() {
        return this.inativo;
    }

    @Generated
    public String getDescricaoAnterior() {
        return this.descricaoAnterior;
    }

    @Generated
    public Long getLogradouroInicio() {
        return this.logradouroInicio;
    }

    @Generated
    public LocalDate getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public String getPrograma() {
        return this.programa;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getIdunico() {
        return this.idunico;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setLogradouro(Long logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setTipoLogradouro(TipoLogradouro tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCorreto(Boolean correto) {
        this.correto = correto;
    }

    @Generated
    public void setLocalizacao(String localizacao) {
        this.localizacao = localizacao;
    }

    @Generated
    public void setDescLogradouroInicio(String descLogradouroInicio) {
        this.descLogradouroInicio = descLogradouroInicio;
    }

    @Generated
    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    @Generated
    public void setDescricaoAnterior(String descricaoAnterior) {
        this.descricaoAnterior = descricaoAnterior;
    }

    @Generated
    public void setLogradouroInicio(Long logradouroInicio) {
        this.logradouroInicio = logradouroInicio;
    }

    @Generated
    public void setDataCriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setPrograma(String programa) {
        this.programa = programa;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setIdunico(Long idunico) {
        this.idunico = idunico;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Logradouro)) {
            return false;
        }
        Logradouro other = (Logradouro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Logradouro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Logradouro(id=" + this.getId() + ", logradouro=" + this.getLogradouro() + ")";
    }
}

