/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.LivroRegistroId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.dividaativa.LivroRegistroParcelaDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="triblivroregistro")
public class LivroRegistro
implements EloEntity<LivroRegistroId>,
Serializable {
    @EmbeddedId
    private LivroRegistroId id;
    @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio") Long tipoCadastro;
    @NotNull(message="Cadastro Geral \u00e9 obrigat\u00f3rio")
    @Column(name="cadastroGeral")
    private @NotNull(message="Cadastro Geral \u00e9 obrigat\u00f3rio") Long cadastroGeralId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="tipoCadastro", referencedColumnName="tipoCadastro")), @JoinColumnOrFormula(formula=@JoinFormula(value="cadastroGeral", referencedColumnName="cadastroGeral"))})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @NotNull(message="Obrigat\u00f3rio o n\u00famero da folha para o Registro")
    private @NotNull(message="Obrigat\u00f3rio o n\u00famero da folha para o Registro") Long numeroFolha;
    @NotNull(message="Obrigat\u00f3rio o n\u00famero de inscri\u00e7\u00e3o para o Registro")
    private @NotNull(message="Obrigat\u00f3rio o n\u00famero de inscri\u00e7\u00e3o para o Registro") Long numeroInscricao;
    private LocalDate dataInscricao;
    private Long sequenciaFolha;
    @Length(max=150)
    private @Length(max=150) String nomeContribuinte;
    private BigDecimal valorOriginal = BigDecimal.ZERO;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    @Length(max=1000)
    private @Length(max=1000) String metodologiaCalculo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="fundamentolegal", referencedColumnName="idato"))})
    @JsonIgnore
    @MetaModelIgnore
    private Ato fundamentoLegal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pessoacontribuinte", referencedColumnName="pessoa")
    @JsonIgnore
    @MetaModelIgnore
    private Pessoa pessoa;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="id.livroRegistro")
    @JsonIgnore
    private List<LivroParcelaTributo> parcelaTributos = new ArrayList();

    public List<LivroRegistroParcelaDTO> getParcelasAgrupadas() {
        Map<LivroRegistroParcelaDTO, List<LivroParcelaTributo>> itensDetalhesAgrupados = this.parcelaTributos.stream().collect(Collectors.groupingBy(LivroRegistroParcelaDTO::ofWithoutValues));
        ArrayList itens = new ArrayList();
        itensDetalhesAgrupados.forEach((loteCdaItemAgrupadoDTO, loteCdaItemDetalhes) -> itens.add(loteCdaItemDetalhes.stream().map(LivroRegistroParcelaDTO::of).reduce((LivroRegistroParcelaDTO)loteCdaItemAgrupadoDTO, (item, acumulator) -> {
            acumulator.setValorOriginal(acumulator.getValorOriginal().add(item.getValorOriginal()));
            acumulator.setValorJuros(acumulator.getValorJuros().add(item.getValorJuros()));
            acumulator.setValorMulta(acumulator.getValorMulta().add(item.getValorMulta()));
            acumulator.setValorCorrecao(acumulator.getValorCorrecao().add(item.getValorCorrecao()));
            acumulator.setValorTotal(acumulator.getValorOriginal().add(acumulator.getValorCorrecao()).add(acumulator.getValorJuros()).add(acumulator.getValorMulta()));
            return acumulator;
        })));
        return itens.stream().sorted(Comparator.comparing(LivroRegistroParcelaDTO::getExercicio).thenComparing(LivroRegistroParcelaDTO::getDivida).thenComparing(LivroRegistroParcelaDTO::getSubDivida).thenComparing(LivroRegistroParcelaDTO::getParcela)).collect(Collectors.toList());
    }

    public BigDecimal getValorTotal() {
        return this.valorPrincipal.add(this.valorJuros).add(this.valorMulta).add(this.valorCorrecao);
    }

    @JsonIgnore
    public BigDecimal getValorPrincipalFromParcelas() {
        return this.getParcelaTributos().stream().map(LivroParcelaTributo::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public BigDecimal getValorOriginalFromParcelas() {
        return this.getParcelaTributos().stream().map(LivroParcelaTributo::getValorOriginal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public BigDecimal getValorJurosFromParcelas() {
        return this.getParcelaTributos().stream().map(LivroParcelaTributo::getValorJuros).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public BigDecimal getValorMultaFromParcelas() {
        return this.getParcelaTributos().stream().map(LivroParcelaTributo::getValorMulta).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public BigDecimal getValorCorrecaoFromParcelas() {
        return this.getParcelaTributos().stream().map(LivroParcelaTributo::getValorCorrecao).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public Long getLivro() {
        return Optional.ofNullable(this.id).map(LivroRegistroId::getLivro).map(Livro::getId).map(LivroId::getLivro).orElse(null);
    }

    @JsonIgnore
    public Long getExercicioLivro() {
        return Optional.ofNullable(this.id).map(LivroRegistroId::getLivro).map(Livro::getId).map(LivroId::getExercicio).orElse(null);
    }

    public static LivroRegistro of(Livro livro, Long sequencia) {
        LivroRegistro livroRegistro = new LivroRegistro();
        livroRegistro.setId(LivroRegistroId.of((Long)livro.getId().getEntidade(), (Long)livro.getId().getExercicio(), (Long)livro.getId().getLivro(), (Long)sequencia));
        return livroRegistro;
    }

    @Generated
    public LivroRegistro() {
    }

    @Generated
    public LivroRegistroId getId() {
        return this.id;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeralId() {
        return this.cadastroGeralId;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getNumeroFolha() {
        return this.numeroFolha;
    }

    @Generated
    public Long getNumeroInscricao() {
        return this.numeroInscricao;
    }

    @Generated
    public LocalDate getDataInscricao() {
        return this.dataInscricao;
    }

    @Generated
    public Long getSequenciaFolha() {
        return this.sequenciaFolha;
    }

    @Generated
    public String getNomeContribuinte() {
        return this.nomeContribuinte;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public String getMetodologiaCalculo() {
        return this.metodologiaCalculo;
    }

    @Generated
    public Ato getFundamentoLegal() {
        return this.fundamentoLegal;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public List<LivroParcelaTributo> getParcelaTributos() {
        return this.parcelaTributos;
    }

    @Generated
    public void setId(LivroRegistroId id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeralId(Long cadastroGeralId) {
        this.cadastroGeralId = cadastroGeralId;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNumeroFolha(Long numeroFolha) {
        this.numeroFolha = numeroFolha;
    }

    @Generated
    public void setNumeroInscricao(Long numeroInscricao) {
        this.numeroInscricao = numeroInscricao;
    }

    @Generated
    public void setDataInscricao(LocalDate dataInscricao) {
        this.dataInscricao = dataInscricao;
    }

    @Generated
    public void setSequenciaFolha(Long sequenciaFolha) {
        this.sequenciaFolha = sequenciaFolha;
    }

    @Generated
    public void setNomeContribuinte(String nomeContribuinte) {
        this.nomeContribuinte = nomeContribuinte;
    }

    @Generated
    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setMetodologiaCalculo(String metodologiaCalculo) {
        this.metodologiaCalculo = metodologiaCalculo;
    }

    @JsonIgnore
    @Generated
    public void setFundamentoLegal(Ato fundamentoLegal) {
        this.fundamentoLegal = fundamentoLegal;
    }

    @JsonIgnore
    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @JsonIgnore
    @Generated
    public void setParcelaTributos(List<LivroParcelaTributo> parcelaTributos) {
        this.parcelaTributos = parcelaTributos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LivroRegistro)) {
            return false;
        }
        LivroRegistro other = (LivroRegistro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LivroRegistroId this$id = this.getId();
        LivroRegistroId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LivroRegistro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LivroRegistroId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LivroRegistro(id=" + String.valueOf(this.getId()) + ")";
    }
}

