/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.LivroParcelaTributoId;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Optional;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBLIVROPARCELARECEITA")
public class LivroParcelaTributo
implements EloEntity<LivroParcelaTributoId>,
Serializable {
    @EmbeddedId
    private LivroParcelaTributoId id;
    private SituacaoLegal situacaoLegal;
    private Long novaSubDivida;
    private Boolean estornado = Boolean.FALSE;
    @Length(max=100)
    private @Length(max=100) String observacao;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorOriginal = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;

    public static LivroParcelaTributo of(LivroRegistro livroRegistro, DebitoParcelaTributo debitoParcelaTributo, GeraLivroDebitoParcelaTributoDTO livroParcelaTributoDTO) {
        LivroParcelaTributoId id = new LivroParcelaTributoId();
        id.setLivroRegistro(livroRegistro);
        id.setDebitoParcelaTributo(debitoParcelaTributo);
        LivroParcelaTributo livroParcelaTributo = new LivroParcelaTributo();
        livroParcelaTributo.setId(id);
        livroParcelaTributo.setSituacaoLegal(SituacaoLegal.fromValue((Integer)livroParcelaTributoDTO.getSituacaoLegal().intValue()));
        livroParcelaTributo.setValor(livroParcelaTributoDTO.getValor());
        livroParcelaTributo.setValorOriginal(livroParcelaTributoDTO.getValor());
        livroParcelaTributo.setValorJuros(livroParcelaTributoDTO.getValorJuros());
        livroParcelaTributo.setValorMulta(livroParcelaTributoDTO.getValorMulta());
        livroParcelaTributo.setValorCorrecao(livroParcelaTributoDTO.getValorCorrecao());
        Long novaSubDivida = Optional.ofNullable(livroParcelaTributoDTO.getNovaSubDivida()).orElse(debitoParcelaTributo.getSubDivida());
        livroParcelaTributo.setNovaSubDivida(novaSubDivida);
        return livroParcelaTributo;
    }

    @Generated
    public LivroParcelaTributo() {
    }

    @Generated
    public LivroParcelaTributoId getId() {
        return this.id;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getNovaSubDivida() {
        return this.novaSubDivida;
    }

    @Generated
    public Boolean getEstornado() {
        return this.estornado;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public void setId(LivroParcelaTributoId id) {
        this.id = id;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setNovaSubDivida(Long novaSubDivida) {
        this.novaSubDivida = novaSubDivida;
    }

    @Generated
    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LivroParcelaTributo)) {
            return false;
        }
        LivroParcelaTributo other = (LivroParcelaTributo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LivroParcelaTributoId this$id = this.getId();
        LivroParcelaTributoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LivroParcelaTributo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LivroParcelaTributoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LivroParcelaTributo(id=" + String.valueOf(this.getId()) + ")";
    }
}

