/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.TipoCorrecao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="FORMACORRECAO")
public class FormaCorrecao
implements EloEntity<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @EloSequence
    @Column(name="FORMACORRECAO")
    private Long id;
    @Length(max=50)
    @NotEmpty(message="A descri\u00e7\u00e3o \u00e9 obrigat\u00f3ria")
    private @Length(max=50) @NotEmpty(message="A descri\u00e7\u00e3o \u00e9 obrigat\u00f3ria") String descricao;
    @NotNull(message="O n\u00famero de meses \u00e9 obrigat\u00f3rio.")
    @Min(value=0L, message="O n\u00famero de meses deve ser maior que 0.")
    @Max(value=12L, message="O n\u00famero de meses deve ser menor que 12.")
    private @NotNull(message="O n\u00famero de meses \u00e9 obrigat\u00f3rio.") @Min(value=0L, message="O n\u00famero de meses deve ser maior que 0.") @Max(value=12L, message="O n\u00famero de meses deve ser menor que 12.") Long meses;
    @Column(name="tipocorrecao")
    @NotNull(message="O tipo de corre\u00e7\u00e3o \u00e9 obrigat\u00f3rio")
    private @NotNull(message="O tipo de corre\u00e7\u00e3o \u00e9 obrigat\u00f3rio") TipoCorrecao tipoCorrecao;
    @Column(name="eventodatacalculo")
    @Length(max=1000)
    private @Length(max=1000) String eventoDataCalculo;
    @Column(name="eventodepoiscorrigir")
    @Length(max=1000)
    private @Length(max=1000) String eventoDepoisCorrigir;
    @Column(name="convertemoeda")
    private Boolean converteMoeda = Boolean.FALSE;
    @Column(name="agregaaovalordoprincipal")
    private Boolean agregaAoValorDoPrincipal = Boolean.FALSE;
    private Boolean agregaAoJuros = Boolean.FALSE;
    @OneToMany(mappedBy="id.formaCorrecao", cascade={CascadeType.ALL}, orphanRemoval=true)
    @IgnoreSizeOf
    private List<IndiceComposto> indices = new ArrayList();

    public void setVinculoIndice() {
        this.indices.forEach(indiceComposto -> indiceComposto.setFormaCorrecao(this));
    }

    @Generated
    public String toString() {
        return "FormaCorrecao(id=" + this.getId() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormaCorrecao)) {
            return false;
        }
        FormaCorrecao other = (FormaCorrecao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FormaCorrecao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public FormaCorrecao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getMeses() {
        return this.meses;
    }

    @Generated
    public TipoCorrecao getTipoCorrecao() {
        return this.tipoCorrecao;
    }

    @Generated
    public String getEventoDataCalculo() {
        return this.eventoDataCalculo;
    }

    @Generated
    public String getEventoDepoisCorrigir() {
        return this.eventoDepoisCorrigir;
    }

    @Generated
    public Boolean getConverteMoeda() {
        return this.converteMoeda;
    }

    @Generated
    public Boolean getAgregaAoValorDoPrincipal() {
        return this.agregaAoValorDoPrincipal;
    }

    @Generated
    public Boolean getAgregaAoJuros() {
        return this.agregaAoJuros;
    }

    @Generated
    public List<IndiceComposto> getIndices() {
        return this.indices;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setMeses(Long meses) {
        this.meses = meses;
    }

    @Generated
    public void setTipoCorrecao(TipoCorrecao tipoCorrecao) {
        this.tipoCorrecao = tipoCorrecao;
    }

    @Generated
    public void setEventoDataCalculo(String eventoDataCalculo) {
        this.eventoDataCalculo = eventoDataCalculo;
    }

    @Generated
    public void setEventoDepoisCorrigir(String eventoDepoisCorrigir) {
        this.eventoDepoisCorrigir = eventoDepoisCorrigir;
    }

    @Generated
    public void setConverteMoeda(Boolean converteMoeda) {
        this.converteMoeda = converteMoeda;
    }

    @Generated
    public void setAgregaAoValorDoPrincipal(Boolean agregaAoValorDoPrincipal) {
        this.agregaAoValorDoPrincipal = agregaAoValorDoPrincipal;
    }

    @Generated
    public void setAgregaAoJuros(Boolean agregaAoJuros) {
        this.agregaAoJuros = agregaAoJuros;
    }

    @Generated
    public void setIndices(List<IndiceComposto> indices) {
        this.indices = indices;
    }
}

