/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.EstornoPagamentoId;
import br.com.elotech.tributos.domain.EstornoPagamentoItem;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBESTORNOPAGAMENTO")
public class EstornoPagamento
implements EloEntity<EstornoPagamentoId>,
Serializable {
    @EmbeddedId
    private EstornoPagamentoId id;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exercicioPagamento", referencedColumnName="exercicioPagamento")), @JoinColumnOrFormula(column=@JoinColumn(name="pagamento", referencedColumnName="pagamento"))})
    private Pagamento pagamento;
    @OneToOne
    @JsonIgnore
    @JoinColumn(name="idpagamentocredito", referencedColumnName="id")
    private PagamentoCredito pagamentoCredito;
    @Column(name="data")
    private LocalDate dataEstorno;
    private Boolean reabilitado;
    private LocalDate dataReabilitacao;
    @Length(max=250)
    private @Length(max=250) String usuario;
    @Length(max=600)
    private @Length(max=600) String motivoEstorno;
    @Length(max=600)
    private @Length(max=600) String motivoReabilitacao;
    private Long contaBancariaEstorno;
    private Boolean reabilitacao;
    private Boolean geraCreditoContribuinte;
    private Long exercicioCreditoContribuinte;
    private Long creditoContribuinte;
    private Long idProcesso;
    private Long exercicioProcesso;
    @ManyToOne
    @JoinColumn(name="motivoDesconto", referencedColumnName="motivoDesconto")
    private MotivoDeducao motivoDeducao;
    @OneToMany(mappedBy="estornoPagamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EstornoPagamentoItem> estornoPagamentoItems = new ArrayList();
    @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20")
    private @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20") String processoSei;

    @Generated
    public EstornoPagamento() {
    }

    @Generated
    public EstornoPagamentoId getId() {
        return this.id;
    }

    @Generated
    public Pagamento getPagamento() {
        return this.pagamento;
    }

    @Generated
    public PagamentoCredito getPagamentoCredito() {
        return this.pagamentoCredito;
    }

    @Generated
    public LocalDate getDataEstorno() {
        return this.dataEstorno;
    }

    @Generated
    public Boolean getReabilitado() {
        return this.reabilitado;
    }

    @Generated
    public LocalDate getDataReabilitacao() {
        return this.dataReabilitacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getMotivoEstorno() {
        return this.motivoEstorno;
    }

    @Generated
    public String getMotivoReabilitacao() {
        return this.motivoReabilitacao;
    }

    @Generated
    public Long getContaBancariaEstorno() {
        return this.contaBancariaEstorno;
    }

    @Generated
    public Boolean getReabilitacao() {
        return this.reabilitacao;
    }

    @Generated
    public Boolean getGeraCreditoContribuinte() {
        return this.geraCreditoContribuinte;
    }

    @Generated
    public Long getExercicioCreditoContribuinte() {
        return this.exercicioCreditoContribuinte;
    }

    @Generated
    public Long getCreditoContribuinte() {
        return this.creditoContribuinte;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public MotivoDeducao getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public List<EstornoPagamentoItem> getEstornoPagamentoItems() {
        return this.estornoPagamentoItems;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public void setId(EstornoPagamentoId id) {
        this.id = id;
    }

    @Generated
    public void setPagamento(Pagamento pagamento) {
        this.pagamento = pagamento;
    }

    @JsonIgnore
    @Generated
    public void setPagamentoCredito(PagamentoCredito pagamentoCredito) {
        this.pagamentoCredito = pagamentoCredito;
    }

    @Generated
    public void setDataEstorno(LocalDate dataEstorno) {
        this.dataEstorno = dataEstorno;
    }

    @Generated
    public void setReabilitado(Boolean reabilitado) {
        this.reabilitado = reabilitado;
    }

    @Generated
    public void setDataReabilitacao(LocalDate dataReabilitacao) {
        this.dataReabilitacao = dataReabilitacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setMotivoEstorno(String motivoEstorno) {
        this.motivoEstorno = motivoEstorno;
    }

    @Generated
    public void setMotivoReabilitacao(String motivoReabilitacao) {
        this.motivoReabilitacao = motivoReabilitacao;
    }

    @Generated
    public void setContaBancariaEstorno(Long contaBancariaEstorno) {
        this.contaBancariaEstorno = contaBancariaEstorno;
    }

    @Generated
    public void setReabilitacao(Boolean reabilitacao) {
        this.reabilitacao = reabilitacao;
    }

    @Generated
    public void setGeraCreditoContribuinte(Boolean geraCreditoContribuinte) {
        this.geraCreditoContribuinte = geraCreditoContribuinte;
    }

    @Generated
    public void setExercicioCreditoContribuinte(Long exercicioCreditoContribuinte) {
        this.exercicioCreditoContribuinte = exercicioCreditoContribuinte;
    }

    @Generated
    public void setCreditoContribuinte(Long creditoContribuinte) {
        this.creditoContribuinte = creditoContribuinte;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setMotivoDeducao(MotivoDeducao motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setEstornoPagamentoItems(List<EstornoPagamentoItem> estornoPagamentoItems) {
        this.estornoPagamentoItems = estornoPagamentoItems;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public String toString() {
        return "EstornoPagamento(id=" + String.valueOf(this.getId()) + ", pagamento=" + String.valueOf(this.getPagamento()) + ", pagamentoCredito=" + String.valueOf(this.getPagamentoCredito()) + ", dataEstorno=" + String.valueOf(this.getDataEstorno()) + ", reabilitado=" + this.getReabilitado() + ", dataReabilitacao=" + String.valueOf(this.getDataReabilitacao()) + ", usuario=" + this.getUsuario() + ", motivoEstorno=" + this.getMotivoEstorno() + ", motivoReabilitacao=" + this.getMotivoReabilitacao() + ", contaBancariaEstorno=" + this.getContaBancariaEstorno() + ", reabilitacao=" + this.getReabilitacao() + ", geraCreditoContribuinte=" + this.getGeraCreditoContribuinte() + ", exercicioCreditoContribuinte=" + this.getExercicioCreditoContribuinte() + ", creditoContribuinte=" + this.getCreditoContribuinte() + ", idProcesso=" + this.getIdProcesso() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", motivoDeducao=" + String.valueOf(this.getMotivoDeducao()) + ", estornoPagamentoItems=" + String.valueOf(this.getEstornoPagamentoItems()) + ", processoSei=" + this.getProcessoSei() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstornoPagamento)) {
            return false;
        }
        EstornoPagamento other = (EstornoPagamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EstornoPagamentoId this$id = this.getId();
        EstornoPagamentoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EstornoPagamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EstornoPagamentoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

