/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.tributos.domain.DividaTributo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;

public class DividaTributoSerializer
extends StdSerializer<DividaTributo> {
    public DividaTributoSerializer() {
        this(null);
    }

    public DividaTributoSerializer(Class<DividaTributo> t) {
        super(t);
    }

    public void serialize(DividaTributo dividaTributo, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        this.getJsonDivida(generator, dividaTributo);
        this.getJsonTributo(generator, dividaTributo);
        generator.writeEndObject();
    }

    private void getJsonDivida(JsonGenerator gen, DividaTributo dividaTributo) throws IOException {
        if (!Objects.isNull(dividaTributo.getDivida())) {
            gen.writeObjectFieldStart("divida");
            gen.writeNumberField("id", dividaTributo.getDivida().getId().longValue());
            gen.writeNumberField("entidade", dividaTributo.getDivida().getEntidade().longValue());
            gen.writeNumberField("exercicio", dividaTributo.getDivida().getExercicio().longValue());
            gen.writeNumberField("divida", dividaTributo.getDivida().getDivida().longValue());
            gen.writeStringField("descricao", dividaTributo.getDivida().getDescricao());
            gen.writeEndObject();
        }
    }

    private void getJsonTributo(JsonGenerator gen, DividaTributo dividaTributo) throws IOException {
        if (!Objects.isNull(dividaTributo.getTributo())) {
            gen.writeObjectFieldStart("tributo");
            gen.writeNumberField("id", dividaTributo.getTributo().getId().longValue());
            gen.writeNumberField("entidade", dividaTributo.getTributo().getEntidade().longValue());
            gen.writeNumberField("exercicio", dividaTributo.getTributo().getExercicio().longValue());
            gen.writeStringField("tributo", dividaTributo.getTributo().getTributo());
            gen.writeStringField("descricao", dividaTributo.getTributo().getDescricao());
            gen.writeEndObject();
        }
    }
}

