/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.DividaTributoEspelhoId;
import br.com.elotech.tributos.domain.DividaTributoPK;
import br.com.elotech.tributos.domain.DividaTributoSerializer;
import br.com.elotech.tributos.domain.Tributo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;

@Entity
@Table(name="tribguiareceitaespelho")
public class DividaTributoEspelho
implements EloEntity<DividaTributoEspelhoId>,
Serializable {
    @EmbeddedId
    private DividaTributoEspelhoId id;
    @MapsId(value="entidade,exercicio,dividaOrigem,tributoOrigem")
    @OneToOne
    @MetaModelIgnore
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento", updatable=false), @JoinColumn(name="receita", referencedColumnName="receita", updatable=false)})
    @JsonIgnoreProperties(value={"espelhamentos", "tributo.divida", "divida.tributos", "divida"})
    private DividaTributo dividaOrigem;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(formula=@JoinFormula(value="guiarecolhimentodestino", referencedColumnName="guiarecolhimento")), @JoinColumnOrFormula(formula=@JoinFormula(value="receitadestino", referencedColumnName="receita"))})
    @JsonSerialize(using=DividaTributoSerializer.class)
    @MetaModelIgnore
    private DividaTributo dividaDestino;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="jurosdestino", referencedColumnName="receita"))})
    private Tributo tributoJuros;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="multadestino", referencedColumnName="receita"))})
    private Tributo tributoMulta;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="correcaodestino", referencedColumnName="receita"))})
    private Tributo tributoCorrecao;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="jurosfinandestino", referencedColumnName="receita"))})
    private Tributo tributoJurosFinanciamento;

    public void setDividaDestinoId() {
        if (Objects.isNull(this.dividaDestino.getId())) {
            this.dividaDestino.setId(DividaTributoPK.builder().entidade(this.dividaDestino.getDivida().getEntidade()).exercicio(this.dividaDestino.getDivida().getExercicio()).divida(this.dividaDestino.getDivida().getDivida()).tributo(this.dividaDestino.getTributo().getTributo()).build());
        }
    }

    @Generated
    public DividaTributoEspelho() {
    }

    @Generated
    public DividaTributoEspelhoId getId() {
        return this.id;
    }

    @Generated
    public DividaTributo getDividaOrigem() {
        return this.dividaOrigem;
    }

    @Generated
    public DividaTributo getDividaDestino() {
        return this.dividaDestino;
    }

    @Generated
    public Tributo getTributoJuros() {
        return this.tributoJuros;
    }

    @Generated
    public Tributo getTributoMulta() {
        return this.tributoMulta;
    }

    @Generated
    public Tributo getTributoCorrecao() {
        return this.tributoCorrecao;
    }

    @Generated
    public Tributo getTributoJurosFinanciamento() {
        return this.tributoJurosFinanciamento;
    }

    @Generated
    public void setId(DividaTributoEspelhoId id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"espelhamentos", "tributo.divida", "divida.tributos", "divida"})
    @Generated
    public void setDividaOrigem(DividaTributo dividaOrigem) {
        this.dividaOrigem = dividaOrigem;
    }

    @Generated
    public void setDividaDestino(DividaTributo dividaDestino) {
        this.dividaDestino = dividaDestino;
    }

    @Generated
    public void setTributoJuros(Tributo tributoJuros) {
        this.tributoJuros = tributoJuros;
    }

    @Generated
    public void setTributoMulta(Tributo tributoMulta) {
        this.tributoMulta = tributoMulta;
    }

    @Generated
    public void setTributoCorrecao(Tributo tributoCorrecao) {
        this.tributoCorrecao = tributoCorrecao;
    }

    @Generated
    public void setTributoJurosFinanciamento(Tributo tributoJurosFinanciamento) {
        this.tributoJurosFinanciamento = tributoJurosFinanciamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DividaTributoEspelho)) {
            return false;
        }
        DividaTributoEspelho other = (DividaTributoEspelho)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DividaTributoEspelhoId this$id = this.getId();
        DividaTributoEspelhoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DividaTributoEspelho;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DividaTributoEspelhoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DividaTributoEspelho(id=" + String.valueOf(this.getId()) + ")";
    }
}

