/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributoEspelho;
import br.com.elotech.tributos.domain.DividaTributoEspelhoId;
import br.com.elotech.tributos.domain.DividaTributoPK;
import br.com.elotech.tributos.domain.Tributo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="tribguiarecolhimentoreceita")
public class DividaTributo
implements EloEntity<DividaTributoPK>,
Serializable {
    @EmbeddedId
    @NotAudited
    private DividaTributoPK id;
    private Long ordem;
    @Column(name="movimentoeconomico")
    private Boolean movimentoEconomico;
    private Boolean proporcional;
    @Column(name="taxaexpediente")
    private Boolean taxaExpediente;
    @Column(name="permitedesconto")
    private Boolean permiteDesconto;
    @Column(name="receitapadrao")
    private Boolean receitaPadrao;
    @Column(name="receitasemmovimento")
    private Boolean receitaSemMovimento;
    @MapsId(value="entidade,exercicio,divida")
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento")})
    @JsonIgnoreProperties(value={"tributos"}, allowSetters=true)
    @MetaModelIgnore
    private Divida divida;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receita", referencedColumnName="receita", insertable=false, updatable=false))})
    private Tributo tributo;
    @OneToMany(mappedBy="dividaOrigem", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"dividaOrigem"})
    private List<DividaTributoEspelho> espelhamentos = new ArrayList();

    public void setDividaTributoEspelhoId() {
        this.espelhamentos.forEach(espelhamento -> {
            if (Objects.isNull(espelhamento.getId())) {
                espelhamento.setId(DividaTributoEspelhoId.builder().entidade(this.id.getEntidade()).exercicio(this.id.getExercicio()).dividaOrigem(this.id.getDivida()).tributoOrigem(this.id.getTributo()).dividaDestino(espelhamento.getDividaDestino().getDivida().getDivida()).tributoDestino(espelhamento.getDividaDestino().getTributo().getTributo()).build());
            }
            espelhamento.setDividaOrigem(this);
            espelhamento.setDividaDestinoId();
        });
    }

    @Generated
    public DividaTributo() {
    }

    @Generated
    public DividaTributoPK getId() {
        return this.id;
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public Boolean getMovimentoEconomico() {
        return this.movimentoEconomico;
    }

    @Generated
    public Boolean getProporcional() {
        return this.proporcional;
    }

    @Generated
    public Boolean getTaxaExpediente() {
        return this.taxaExpediente;
    }

    @Generated
    public Boolean getPermiteDesconto() {
        return this.permiteDesconto;
    }

    @Generated
    public Boolean getReceitaPadrao() {
        return this.receitaPadrao;
    }

    @Generated
    public Boolean getReceitaSemMovimento() {
        return this.receitaSemMovimento;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public Tributo getTributo() {
        return this.tributo;
    }

    @Generated
    public List<DividaTributoEspelho> getEspelhamentos() {
        return this.espelhamentos;
    }

    @Generated
    public void setId(DividaTributoPK id) {
        this.id = id;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setMovimentoEconomico(Boolean movimentoEconomico) {
        this.movimentoEconomico = movimentoEconomico;
    }

    @Generated
    public void setProporcional(Boolean proporcional) {
        this.proporcional = proporcional;
    }

    @Generated
    public void setTaxaExpediente(Boolean taxaExpediente) {
        this.taxaExpediente = taxaExpediente;
    }

    @Generated
    public void setPermiteDesconto(Boolean permiteDesconto) {
        this.permiteDesconto = permiteDesconto;
    }

    @Generated
    public void setReceitaPadrao(Boolean receitaPadrao) {
        this.receitaPadrao = receitaPadrao;
    }

    @Generated
    public void setReceitaSemMovimento(Boolean receitaSemMovimento) {
        this.receitaSemMovimento = receitaSemMovimento;
    }

    @JsonIgnoreProperties(value={"tributos"}, allowSetters=true)
    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setTributo(Tributo tributo) {
        this.tributo = tributo;
    }

    @JsonIgnoreProperties(value={"dividaOrigem"})
    @Generated
    public void setEspelhamentos(List<DividaTributoEspelho> espelhamentos) {
        this.espelhamentos = espelhamentos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DividaTributo)) {
            return false;
        }
        DividaTributo other = (DividaTributo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DividaTributoPK this$id = this.getId();
        DividaTributoPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DividaTributo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DividaTributoPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DividaTributo(id=" + String.valueOf(this.getId()) + ")";
    }
}

