/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Tributo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBDEBITOPARCELARECEITA")
public class DebitoParcelaTributo
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="s05debitoparcelareceitaid")
    @Column(unique=true, name="iddebitoparcelareceita")
    private Long id;
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida"), @JoinColumn(name="parcela", referencedColumnName="parcela")})
    private DebitoParcela debitoParcela;
    @Column(updatable=false, insertable=false)
    private Long entidade;
    @Column(updatable=false, insertable=false)
    private Long exercicio;
    @Column(updatable=false, insertable=false)
    private Long tipoCadastro;
    @Column(updatable=false, insertable=false)
    private Long cadastroGeral;
    @Column(name="guiarecolhimento", updatable=false, insertable=false)
    private Long divida;
    @Column(updatable=false, insertable=false)
    private Long subDivida;
    @Column(updatable=false, insertable=false)
    private Long parcela;
    @Column(name="receita")
    private String tributo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(formula=@JoinFormula(value="receita", referencedColumnName="receita"))})
    private Tributo tributoEntity;
    private Long tipoCalculoDebito = 0L;
    private Long calculo = 0L;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorOriginal = BigDecimal.ZERO;
    private BigDecimal valorAtualizacao = BigDecimal.ZERO;

    public Long getIdDebito() {
        return this.debitoParcela.getDebito().getId();
    }

    public BigDecimal getValorJuros() {
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorJuros, (Object)BigDecimal.ZERO);
    }

    public BigDecimal getValorMulta() {
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorMulta, (Object)BigDecimal.ZERO);
    }

    public BigDecimal getValorCorrecao() {
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorCorrecao, (Object)BigDecimal.ZERO);
    }

    public BigDecimal getValorDesconto() {
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorDesconto, (Object)BigDecimal.ZERO);
    }

    public BigDecimal getValorAtualizacao() {
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorAtualizacao, (Object)BigDecimal.ZERO);
    }

    public BigDecimal getValorTotal() {
        return this.valor.add(this.getValorJuros()).add(this.getValorMulta()).add(this.getValorCorrecao()).subtract(this.getValorDesconto());
    }

    public DebitoParcelaTributo copy(CadastroGeral newCadastro, Long newSubDivida, DebitoParcela newDebitoParcela) {
        DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
        BeanUtils.copyProperties((Object)this, (Object)debitoParcelaTributo, (String[])new String[]{"id", "tipoCadastro", "cadastroGeral", "subDivida", "debitoParcela"});
        debitoParcelaTributo.setTipoCadastro(newCadastro.getTipoCadastro().getValue());
        debitoParcelaTributo.setCadastroGeral(newCadastro.getCadastroGeral());
        debitoParcelaTributo.setSubDivida(newSubDivida);
        debitoParcelaTributo.setDebitoParcela(newDebitoParcela);
        return debitoParcelaTributo;
    }

    @Generated
    public DebitoParcelaTributo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public DebitoParcela getDebitoParcela() {
        return this.debitoParcela;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public Tributo getTributoEntity() {
        return this.tributoEntity;
    }

    @Generated
    public Long getTipoCalculoDebito() {
        return this.tipoCalculoDebito;
    }

    @Generated
    public Long getCalculo() {
        return this.calculo;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setDebitoParcela(DebitoParcela debitoParcela) {
        this.debitoParcela = debitoParcela;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setTributoEntity(Tributo tributoEntity) {
        this.tributoEntity = tributoEntity;
    }

    @Generated
    public void setTipoCalculoDebito(Long tipoCalculoDebito) {
        this.tipoCalculoDebito = tipoCalculoDebito;
    }

    @Generated
    public void setCalculo(Long calculo) {
        this.calculo = calculo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    @Generated
    public void setValorAtualizacao(BigDecimal valorAtualizacao) {
        this.valorAtualizacao = valorAtualizacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoParcelaTributo)) {
            return false;
        }
        DebitoParcelaTributo other = (DebitoParcelaTributo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoParcelaTributo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoParcelaTributo(id=" + this.getId() + ")";
    }
}

