/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.FormaPagamento;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBDEBITOAUTOMATICOOPCAO")
public class DebitoAutomaticoOpcao
implements EloEntity<Long> {
    @Id
    @EloSequence
    @Column(name="IDDEBITOAUTOMATICO")
    private Long id;
    private Long tipoDebitoAutomatico;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Autorizado")
    private Boolean autorizado = Boolean.FALSE;
    @Caption(value="Data implanta\u00e7\u00e3o")
    private LocalDate dataImplantacao;
    @Caption(value="Data exclus\u00e3o")
    private LocalDate dataExclusao;
    @Caption(value="Data autoriza\u00e7\u00e3o")
    private LocalDate dataAutorizacao;
    @Caption(value="Identifica\u00e7\u00e3o")
    @Length(max=60)
    private @Length(max=60) String identificacao;
    @Caption(value="Identifica\u00e7\u00e3o origem")
    @Length(max=60)
    private @Length(max=60) String identificacaoOrigem;
    @Caption(value="Usu\u00e1rio exclus\u00e3o")
    @Length(max=250)
    private @Length(max=250) String usuarioExclusao;
    @Caption(value="Usu\u00e1rio")
    @Length(max=250)
    private @Length(max=250) String usuario;
    @Caption(value="Entidade")
    private Long entidade;
    @Caption(value="Exerc\u00edcio")
    private Long exercicio;
    @Caption(value="Tipo cadastro")
    private Long tipoCadastro;
    @Caption(value="Cadastro geral")
    private Long cadastroGeral;
    @Caption(value="Guia recolhimento")
    private Long guiaRecolhimento;
    @Caption(value="Sub d\u00edvida")
    private Long subDivida;
    @NotNull(message="Banco \u00e9 obrigat\u00f3rio")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="banco")
    private @NotNull(message="Banco \u00e9 obrigat\u00f3rio") Banco banco;
    @NotNull(message="Conv\u00eanio \u00e9 obrigat\u00f3rio")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="convenio", referencedColumnName="convenio")
    private @NotNull(message="Conv\u00eanio \u00e9 obrigat\u00f3rio") Convenio convenio;
    @Caption(value="Ag\u00eancia")
    @Length(max=10)
    private @Length(max=10) String agencia;
    @NotNull(message="Forma de pagamento \u00e9 obrigat\u00f3ria")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="formaPagamento")
    private @NotNull(message="Forma de pagamento \u00e9 obrigat\u00f3ria") FormaPagamento formaPagamento;

    @Generated
    public DebitoAutomaticoOpcao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTipoDebitoAutomatico() {
        return this.tipoDebitoAutomatico;
    }

    @Generated
    public Boolean getAutorizado() {
        return this.autorizado;
    }

    @Generated
    public LocalDate getDataImplantacao() {
        return this.dataImplantacao;
    }

    @Generated
    public LocalDate getDataExclusao() {
        return this.dataExclusao;
    }

    @Generated
    public LocalDate getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    @Generated
    public String getIdentificacao() {
        return this.identificacao;
    }

    @Generated
    public String getIdentificacaoOrigem() {
        return this.identificacaoOrigem;
    }

    @Generated
    public String getUsuarioExclusao() {
        return this.usuarioExclusao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Banco getBanco() {
        return this.banco;
    }

    @Generated
    public Convenio getConvenio() {
        return this.convenio;
    }

    @Generated
    public String getAgencia() {
        return this.agencia;
    }

    @Generated
    public FormaPagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoDebitoAutomatico(Long tipoDebitoAutomatico) {
        this.tipoDebitoAutomatico = tipoDebitoAutomatico;
    }

    @Generated
    public void setAutorizado(Boolean autorizado) {
        this.autorizado = autorizado;
    }

    @Generated
    public void setDataImplantacao(LocalDate dataImplantacao) {
        this.dataImplantacao = dataImplantacao;
    }

    @Generated
    public void setDataExclusao(LocalDate dataExclusao) {
        this.dataExclusao = dataExclusao;
    }

    @Generated
    public void setDataAutorizacao(LocalDate dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    @Generated
    public void setIdentificacao(String identificacao) {
        this.identificacao = identificacao;
    }

    @Generated
    public void setIdentificacaoOrigem(String identificacaoOrigem) {
        this.identificacaoOrigem = identificacaoOrigem;
    }

    @Generated
    public void setUsuarioExclusao(String usuarioExclusao) {
        this.usuarioExclusao = usuarioExclusao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    @Generated
    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Generated
    public void setFormaPagamento(FormaPagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public String toString() {
        return "DebitoAutomaticoOpcao(id=" + this.getId() + ", tipoDebitoAutomatico=" + this.getTipoDebitoAutomatico() + ", autorizado=" + this.getAutorizado() + ", dataImplantacao=" + String.valueOf(this.getDataImplantacao()) + ", dataExclusao=" + String.valueOf(this.getDataExclusao()) + ", dataAutorizacao=" + String.valueOf(this.getDataAutorizacao()) + ", identificacao=" + this.getIdentificacao() + ", identificacaoOrigem=" + this.getIdentificacaoOrigem() + ", usuarioExclusao=" + this.getUsuarioExclusao() + ", usuario=" + this.getUsuario() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", subDivida=" + this.getSubDivida() + ", banco=" + String.valueOf(this.getBanco()) + ", convenio=" + String.valueOf(this.getConvenio()) + ", agencia=" + this.getAgencia() + ", formaPagamento=" + String.valueOf(this.getFormaPagamento()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoAutomaticoOpcao)) {
            return false;
        }
        DebitoAutomaticoOpcao other = (DebitoAutomaticoOpcao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoAutomaticoOpcao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

