/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.TipoNotificacaoComunicado;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.SituacaoComunicado;
import br.com.elotech.tributos.enums.OrigemComunicado;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="TribComunicado")
public class Comunicado
implements EloEntity<ComunicadoId>,
Serializable {
    @EmbeddedId
    private ComunicadoId id;
    @EloSequence(sequenceName="S05COMUNICADO")
    private Long comunicado;
    private String descricao;
    @Enumerated(value=EnumType.STRING)
    private OrigemComunicado origem;
    private byte[] texto;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="modulo", referencedColumnName="modulo"), @JoinColumn(name="tiporelatorio", referencedColumnName="tiporelatorio"), @JoinColumn(name="relatorio", referencedColumnName="relatorio")})
    private Relatorio relatorio;
    @ManyToOne
    @JoinColumn(name="tiponotificacao")
    private TipoNotificacaoComunicado tipoNotificacao;
    private UUID idArquivoImpressao;
    private LocalDate dataGeracao;
    private LocalDate dataValidade;
    private String usuario;
    private String filtroUtilizado;
    private Boolean enderecoValidado;
    private SituacaoComunicado situacao;
    @OneToMany(mappedBy="id.comunicado", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ComunicadoCadastro> cadastros = new ArrayList();
    @ManyToOne
    @JoinColumn(name="idJobComunicado", referencedColumnName="job_execution_id")
    private BatchJobExecution batchJobExecutionComunicado;

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Comunicado)) {
            return false;
        }
        Comunicado other = (Comunicado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ComunicadoId this$id = this.getId();
        ComunicadoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Comunicado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComunicadoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Comunicado(id=" + String.valueOf(this.getId()) + ")";
    }

    @Generated
    public Comunicado() {
    }

    @Generated
    public ComunicadoId getId() {
        return this.id;
    }

    @Generated
    public Long getComunicado() {
        return this.comunicado;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public OrigemComunicado getOrigem() {
        return this.origem;
    }

    @Generated
    public byte[] getTexto() {
        return this.texto;
    }

    @Generated
    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    @Generated
    public TipoNotificacaoComunicado getTipoNotificacao() {
        return this.tipoNotificacao;
    }

    @Generated
    public UUID getIdArquivoImpressao() {
        return this.idArquivoImpressao;
    }

    @Generated
    public LocalDate getDataGeracao() {
        return this.dataGeracao;
    }

    @Generated
    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getFiltroUtilizado() {
        return this.filtroUtilizado;
    }

    @Generated
    public Boolean getEnderecoValidado() {
        return this.enderecoValidado;
    }

    @Generated
    public SituacaoComunicado getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<ComunicadoCadastro> getCadastros() {
        return this.cadastros;
    }

    @Generated
    public BatchJobExecution getBatchJobExecutionComunicado() {
        return this.batchJobExecutionComunicado;
    }

    @Generated
    public void setId(ComunicadoId id) {
        this.id = id;
    }

    @Generated
    public void setComunicado(Long comunicado) {
        this.comunicado = comunicado;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setOrigem(OrigemComunicado origem) {
        this.origem = origem;
    }

    @Generated
    public void setTexto(byte[] texto) {
        this.texto = texto;
    }

    @Generated
    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
    }

    @Generated
    public void setTipoNotificacao(TipoNotificacaoComunicado tipoNotificacao) {
        this.tipoNotificacao = tipoNotificacao;
    }

    @Generated
    public void setIdArquivoImpressao(UUID idArquivoImpressao) {
        this.idArquivoImpressao = idArquivoImpressao;
    }

    @Generated
    public void setDataGeracao(LocalDate dataGeracao) {
        this.dataGeracao = dataGeracao;
    }

    @Generated
    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setFiltroUtilizado(String filtroUtilizado) {
        this.filtroUtilizado = filtroUtilizado;
    }

    @Generated
    public void setEnderecoValidado(Boolean enderecoValidado) {
        this.enderecoValidado = enderecoValidado;
    }

    @Generated
    public void setSituacao(SituacaoComunicado situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setCadastros(List<ComunicadoCadastro> cadastros) {
        this.cadastros = cadastros;
    }

    @Generated
    public void setBatchJobExecutionComunicado(BatchJobExecution batchJobExecutionComunicado) {
        this.batchJobExecutionComunicado = batchJobExecutionComunicado;
    }
}

