/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.utils.GeraImagemCodigoBarras;
import br.com.elotech.tributos.converter.OrigemEmissaoConverter;
import br.com.elotech.tributos.converter.TipoBloquetoConverter;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.DocumentoAutenticadoDTO;
import br.com.elotech.tributos.dto.fintel.BloquetoFintelDTO;
import br.com.elotech.tributos.dto.negociacaodebito.GeraBoletoNegociacaoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixUtil;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBBLOQUETO")
@DynamicUpdate
public class Bloqueto
implements EloEntity<Long>,
Serializable {
    private static final Long TIPODOCUMENTO_BLOQUETO = 100L;
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBBLOQUETO_ID")
    private Long id;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicioBloqueto;
    @NotNull
    @EloSequence(sequenceName="s05bloqueto_#{entidade}_#{exercicioBloqueto}")
    private Long bloqueto;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", referencedColumnName="pessoa", updatable=false, nullable=false)
    private Pessoa pessoa;
    @Length(max=20)
    private @Length(max=20) String campo1;
    @Length(max=20)
    private @Length(max=20) String campo2;
    @Length(max=20)
    private @Length(max=20) String campo3;
    @Length(max=20)
    private @Length(max=20) String campo4;
    @Length(max=20)
    private @Length(max=20) String campo5;
    @Column(name="codigo_baixa")
    private BigDecimal codigoBaixa;
    @Length(max=100)
    private @Length(max=100) String codigoBarras;
    @Length(max=100)
    private @Length(max=100) String codigoBarrasExterno;
    @Length(max=60)
    private @Length(max=60) String codigoBarrasFormatado;
    @Length(max=2)
    private @Length(max=2) String modalidadeCarteira;
    @Length(max=1)
    private @Length(max=1) String dvNossoNumero;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Corrigido")
    private Boolean corrigido = Boolean.FALSE;
    private LocalDate dataEmissao;
    private LocalDate dataLimitePagamento;
    private LocalDate dataVencimento;
    private Boolean direitoDescontoCotaUnica = Boolean.FALSE;
    private Long formaPagamento;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Impresso")
    private Boolean impresso = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="modelobloqueto")
    private ModeloBoleto modeloBloqueto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="motivodesconto", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoDeducao;
    @Length(max=40)
    private @Length(max=40) String nossoNumero;
    private Integer numeroImpressao = 0;
    @Length(max=4000)
    private @Length(max=4000) String observacao;
    @Convert(converter=OrigemEmissaoConverter.class)
    private OrigemEmissao origemEmissao;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Pago")
    private Boolean pago = Boolean.FALSE;
    @Column(name="sub_seq_pref")
    private Integer subSeqPref;
    @Convert(converter=TipoBloquetoConverter.class)
    private TipoBloqueto tipoBloqueto;
    @Length(max=250)
    private @Length(max=250) String usuario;
    private Boolean utilizaValorBloqueto = Boolean.FALSE;
    @Column(name="ano_div_pref")
    private Integer anoDivPref;
    private Boolean bloquetoGeradoBaixaAutomatica = Boolean.FALSE;
    private Integer cadastroInvalido;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    @Length(max=100)
    private @Length(max=100) String codigoValidacao;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false, insertable=false), @JoinColumn(name="exercicioBloqueto", referencedColumnName="exercicioBloqueto", updatable=false, insertable=false), @JoinColumn(name="bloqueto", referencedColumnName="bloqueto", updatable=false, insertable=false)})
    private List<BoletoDebito> debitos = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    private Long parcelaCotaUnica = 0L;
    private Long diasAdiadosVencimento = 0L;
    private Boolean registroOnline = Boolean.FALSE;
    @Column(name="textoqrcode")
    private String textoQrCode;
    @Column(name="txidpix")
    private String txidPix;
    @Column(name="anoprocesso")
    private Long anoProcesso;
    @Column(name="numeroprocesso")
    private Long numeroProcesso;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean cancelado = Boolean.FALSE;
    @Column(name="nossonumerogeradobanco")
    private String nossoNumeroGeradoBanco;
    private BigDecimal valorHonorario = BigDecimal.ZERO;
    @Column(name="pgtonegociado")
    private Long pagamentoNegociado;

    public static Bloqueto from(GeraBoletoNegociacaoDTO dto, ModeloBoleto modeloBoleto, CadastroGeral cadastro, Pessoa pessoa, MotivoDeducao motivoDeducao, Long formaPagamentoPadrao) {
        Bloqueto boleto = new Bloqueto();
        boleto.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        boleto.setEntidade(dto.getEntidade());
        boleto.setExercicioBloqueto(dto.getExercicio());
        boleto.setTipoBloqueto(TipoBloqueto.AGRUPADO);
        boleto.setDataEmissao(dto.getDataEmissao());
        boleto.setDireitoDescontoCotaUnica(Boolean.FALSE);
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        boleto.setUsuario(SecurityUtils.getUserAise());
        boleto.setFormaPagamento(formaPagamentoPadrao);
        boleto.setDataVencimento(dto.getDataVencimento());
        boleto.setModeloBloqueto(modeloBoleto);
        boleto.setCadastroGeral(cadastro);
        boleto.setPessoa(pessoa);
        boleto.setObservacao(dto.getObservacao());
        boleto.setMotivoDeducao(motivoDeducao);
        return boleto;
    }

    public static Bloqueto from(BloquetoFintelDTO bloquetoFintel) {
        Bloqueto boleto = new Bloqueto();
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        boleto.setCodigoBarras(bloquetoFintel.getCodigoBarra());
        boleto.setNossoNumero(bloquetoFintel.getCodigoBarra().substring(27));
        boleto.setDvNossoNumero("");
        boleto.setDataVencimento(bloquetoFintel.getDataVencimento());
        boleto.setDataEmissao(bloquetoFintel.getDataEmissao());
        boleto.setDataLimitePagamento(bloquetoFintel.getDataValidade());
        boleto.setCampo1("");
        boleto.setCampo2("");
        boleto.setCampo3("");
        boleto.setCampo4("");
        boleto.setCampo5("");
        boleto.setCodigoBarrasFormatado("");
        bloquetoFintel.getValoresAgrupados().getAgrupados().forEach(valor -> {
            boleto.setValorPrincipal(boleto.getValorPrincipal().add(valor.getValorPrincipal()));
            boleto.setValorJuros(boleto.getValorJuros().add(valor.getValorJuros()));
            boleto.setValorMulta(boleto.getValorMulta().add(valor.getValorMulta()));
            boleto.setValorCorrecao(boleto.getValorCorrecao().add(valor.getValorCorrecao()));
            boleto.setValorDesconto(boleto.getValorDesconto().add(valor.getValorDesconto()));
        });
        return boleto;
    }

    @PrePersist
    public void prePersist() {
        this.codigoValidacao = DigestUtils.md5Hex((String)UUID.randomUUID().toString()).toUpperCase();
    }

    public BigDecimal calculaValorBoleto() {
        return this.debitos.stream().reduce(new BoletoDebito(), BoletoDebito::add).getValorTotal();
    }

    public BigDecimal calculaValorBoletoComAcrescimos() {
        return this.debitos.stream().reduce(new BoletoDebito(), BoletoDebito::add).getValorTotalComAcrescimosAndHonorarios();
    }

    public void atualizaValoresBoleto() {
        BoletoDebito valoresAcumulados = this.debitos.stream().reduce(new BoletoDebito(), BoletoDebito::add);
        this.valorPrincipal = valoresAcumulados.getValorPrincipal();
        this.valorJuros = valoresAcumulados.getValorJuros();
        this.valorMulta = valoresAcumulados.getValorMulta();
        this.valorCorrecao = valoresAcumulados.getValorCorrecao();
        this.valorDesconto = valoresAcumulados.getValorTotalDesconto();
        this.valorHonorario = valoresAcumulados.getValorHonorario();
    }

    public void setCodigoBarras(CodigoBarrasDTO codigoBarrasDTO) {
        this.codigoBarras = codigoBarrasDTO.getCodigoBarras();
        this.campo1 = codigoBarrasDTO.getCampo1();
        this.campo2 = codigoBarrasDTO.getCampo2();
        this.campo3 = codigoBarrasDTO.getCampo3();
        this.campo4 = codigoBarrasDTO.getCampo4();
        this.campo5 = codigoBarrasDTO.getCampo5();
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    public String getLinhaDigitavel() {
        return this.getCampo1().concat(this.getCampo2()).concat(this.getCampo3()).concat(this.getCampo4()).concat(this.getCampo5());
    }

    public byte[] getCodigoBarrasImagem() {
        return GeraImagemCodigoBarras.getImagemAsPNG((String)this.codigoBarras);
    }

    public byte[] getQrCodeImagem() {
        return IntegracaoPixUtil.gerarImagemQrCodePix((String)this.textoQrCode);
    }

    public String getCampo1() {
        return Optional.ofNullable(this.campo1).orElse("");
    }

    public String getCampo2() {
        return Optional.ofNullable(this.campo2).orElse("");
    }

    public String getCampo3() {
        return Optional.ofNullable(this.campo3).orElse("");
    }

    public String getCampo4() {
        return Optional.ofNullable(this.campo4).orElse("");
    }

    public String getCampo5() {
        return Optional.ofNullable(this.campo5).orElse("");
    }

    public BigDecimal getValorBloqueto() {
        return this.getValorPrincipal().add(this.getValorMulta()).add(this.getValorJuros()).add(this.getValorCorrecao()).add(this.getValorHonorario()).subtract(this.getValorDesconto());
    }

    public Boolean getVencido() {
        return DateUtils.isVencido((LocalDate)this.dataVencimento);
    }

    public boolean validaSeBoletoComParcelaPaga() {
        return this.getDebitos().stream().anyMatch(boletoDebito -> boletoDebito.getId().getDebitoParcelaTributo().getDebitoParcela().getSituacaoDebito().getTipoSituacaoParcela().getValue().equals(TipoSituacaoParcela.PAGO.getValue()));
    }

    public DocumentoAutenticadoDTO toDocumentoAutenticadoDTO() {
        DocumentoAutenticadoDTO documentoAutenticado = new DocumentoAutenticadoDTO();
        documentoAutenticado.setExercicio(this.exercicioBloqueto);
        documentoAutenticado.setTipoDocumento(TIPODOCUMENTO_BLOQUETO);
        documentoAutenticado.setDescricao("BLOQUETO");
        documentoAutenticado.setDocumento(this.nossoNumero);
        if (Objects.nonNull(this.pessoa)) {
            documentoAutenticado.setRequerente(this.pessoa.getNome());
            documentoAutenticado.setCpfRequerente(this.pessoa.getCnpjCpf());
        }
        documentoAutenticado.setDataEmissao(this.dataEmissao);
        documentoAutenticado.setDataValidade(this.dataVencimento);
        documentoAutenticado.setCodigoBarras(this.codigoBarras);
        documentoAutenticado.setValorBloqueto(this.getValorBloqueto());
        return documentoAutenticado;
    }

    public boolean validaSePossuiDescontoSemMotivoDeducao() {
        Boolean possuiDesconto = this.getDebitos().stream().anyMatch(boletoDebito -> boletoDebito.getValorTotalDesconto().compareTo(BigDecimal.ZERO) > 0);
        return possuiDesconto != false && Objects.isNull(this.motivoDeducao);
    }

    public boolean isCotaUnica() {
        return TipoBloqueto.COTA_UNICA.equals((Object)this.tipoBloqueto);
    }

    public boolean permitePagamentoAposVencimento() {
        return TipoBloqueto.COTA_UNICA.equals((Object)this.tipoBloqueto) || TipoBloqueto.RESTANTE.equals((Object)this.tipoBloqueto);
    }

    public String generateTxIdPix() {
        return DigestUtils.md5Hex((String)(LocalDateTime.now().toString() + this.getModeloBloqueto().getConvenio().getChavePix()));
    }

    @JsonIgnore
    public BloquetoDTO toBloquetoDTO() {
        BloquetoDTO boletoDTO = new BloquetoDTO();
        boletoDTO.setId(this.getId());
        boletoDTO.setEntidade(this.getEntidade());
        boletoDTO.setExercicioBloqueto(this.getExercicioBloqueto());
        boletoDTO.setBloqueto(this.getBloqueto());
        boletoDTO.setCodigoBarras(this.getCodigoBarras());
        boletoDTO.setDataEmissao(this.getDataEmissao());
        boletoDTO.setDataVencimento(this.getDataVencimento());
        boletoDTO.setValorPrincipal(this.getValorPrincipal());
        boletoDTO.setValorJuros(this.getValorJuros());
        boletoDTO.setValorMulta(this.getValorMulta());
        boletoDTO.setValorCorrecao(this.getValorCorrecao());
        boletoDTO.setValorDesconto(this.getValorDesconto());
        boletoDTO.setCampo1(this.getCampo1());
        boletoDTO.setCampo2(this.getCampo2());
        boletoDTO.setCampo3(this.getCampo3());
        boletoDTO.setCampo4(this.getCampo4());
        boletoDTO.setCampo5(this.getCampo5());
        boletoDTO.setCodigoValidacao(this.getCodigoValidacao());
        boletoDTO.setNossoNumero(this.getNossoNumero());
        boletoDTO.setLinhaDigitavel(this.getLinhaDigitavel());
        boletoDTO.setValorAPagar(this.getValorPrincipal().add(this.getValorJuros()).add(this.getValorMulta()).add(this.getValorCorrecao()).subtract(this.getValorDesconto()));
        boletoDTO.setTextoQrCode(this.getTextoQrCode());
        return boletoDTO;
    }

    public boolean naoVencido(LocalDate dataReferencia) {
        return this.dataVencimento.isAfter(dataReferencia) || this.dataVencimento.isEqual(dataReferencia);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bloqueto)) {
            return false;
        }
        Bloqueto other = (Bloqueto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bloqueto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Bloqueto(id=" + this.getId() + ")";
    }

    @Generated
    public Bloqueto() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicioBloqueto() {
        return this.exercicioBloqueto;
    }

    @Generated
    public Long getBloqueto() {
        return this.bloqueto;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public BigDecimal getCodigoBaixa() {
        return this.codigoBaixa;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getCodigoBarrasExterno() {
        return this.codigoBarrasExterno;
    }

    @Generated
    public String getCodigoBarrasFormatado() {
        return this.codigoBarrasFormatado;
    }

    @Generated
    public String getModalidadeCarteira() {
        return this.modalidadeCarteira;
    }

    @Generated
    public String getDvNossoNumero() {
        return this.dvNossoNumero;
    }

    @Generated
    public Boolean getCorrigido() {
        return this.corrigido;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataLimitePagamento() {
        return this.dataLimitePagamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public Boolean getDireitoDescontoCotaUnica() {
        return this.direitoDescontoCotaUnica;
    }

    @Generated
    public Long getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public Boolean getImpresso() {
        return this.impresso;
    }

    @Generated
    public ModeloBoleto getModeloBloqueto() {
        return this.modeloBloqueto;
    }

    @Generated
    public MotivoDeducao getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public Integer getNumeroImpressao() {
        return this.numeroImpressao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public OrigemEmissao getOrigemEmissao() {
        return this.origemEmissao;
    }

    @Generated
    public Boolean getPago() {
        return this.pago;
    }

    @Generated
    public Integer getSubSeqPref() {
        return this.subSeqPref;
    }

    @Generated
    public TipoBloqueto getTipoBloqueto() {
        return this.tipoBloqueto;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getUtilizaValorBloqueto() {
        return this.utilizaValorBloqueto;
    }

    @Generated
    public Integer getAnoDivPref() {
        return this.anoDivPref;
    }

    @Generated
    public Boolean getBloquetoGeradoBaixaAutomatica() {
        return this.bloquetoGeradoBaixaAutomatica;
    }

    @Generated
    public Integer getCadastroInvalido() {
        return this.cadastroInvalido;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    @Generated
    public List<BoletoDebito> getDebitos() {
        return this.debitos;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getParcelaCotaUnica() {
        return this.parcelaCotaUnica;
    }

    @Generated
    public Long getDiasAdiadosVencimento() {
        return this.diasAdiadosVencimento;
    }

    @Generated
    public Boolean getRegistroOnline() {
        return this.registroOnline;
    }

    @Generated
    public String getTextoQrCode() {
        return this.textoQrCode;
    }

    @Generated
    public String getTxidPix() {
        return this.txidPix;
    }

    @Generated
    public Long getAnoProcesso() {
        return this.anoProcesso;
    }

    @Generated
    public Long getNumeroProcesso() {
        return this.numeroProcesso;
    }

    @Generated
    public Boolean getCancelado() {
        return this.cancelado;
    }

    @Generated
    public String getNossoNumeroGeradoBanco() {
        return this.nossoNumeroGeradoBanco;
    }

    @Generated
    public BigDecimal getValorHonorario() {
        return this.valorHonorario;
    }

    @Generated
    public Long getPagamentoNegociado() {
        return this.pagamentoNegociado;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicioBloqueto(Long exercicioBloqueto) {
        this.exercicioBloqueto = exercicioBloqueto;
    }

    @Generated
    public void setBloqueto(Long bloqueto) {
        this.bloqueto = bloqueto;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setCampo1(String campo1) {
        this.campo1 = campo1;
    }

    @Generated
    public void setCampo2(String campo2) {
        this.campo2 = campo2;
    }

    @Generated
    public void setCampo3(String campo3) {
        this.campo3 = campo3;
    }

    @Generated
    public void setCampo4(String campo4) {
        this.campo4 = campo4;
    }

    @Generated
    public void setCampo5(String campo5) {
        this.campo5 = campo5;
    }

    @Generated
    public void setCodigoBaixa(BigDecimal codigoBaixa) {
        this.codigoBaixa = codigoBaixa;
    }

    @Generated
    public void setCodigoBarrasExterno(String codigoBarrasExterno) {
        this.codigoBarrasExterno = codigoBarrasExterno;
    }

    @Generated
    public void setCodigoBarrasFormatado(String codigoBarrasFormatado) {
        this.codigoBarrasFormatado = codigoBarrasFormatado;
    }

    @Generated
    public void setModalidadeCarteira(String modalidadeCarteira) {
        this.modalidadeCarteira = modalidadeCarteira;
    }

    @Generated
    public void setDvNossoNumero(String dvNossoNumero) {
        this.dvNossoNumero = dvNossoNumero;
    }

    @Generated
    public void setCorrigido(Boolean corrigido) {
        this.corrigido = corrigido;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataLimitePagamento(LocalDate dataLimitePagamento) {
        this.dataLimitePagamento = dataLimitePagamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDireitoDescontoCotaUnica(Boolean direitoDescontoCotaUnica) {
        this.direitoDescontoCotaUnica = direitoDescontoCotaUnica;
    }

    @Generated
    public void setFormaPagamento(Long formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setImpresso(Boolean impresso) {
        this.impresso = impresso;
    }

    @Generated
    public void setModeloBloqueto(ModeloBoleto modeloBloqueto) {
        this.modeloBloqueto = modeloBloqueto;
    }

    @Generated
    public void setMotivoDeducao(MotivoDeducao motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setNumeroImpressao(Integer numeroImpressao) {
        this.numeroImpressao = numeroImpressao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setOrigemEmissao(OrigemEmissao origemEmissao) {
        this.origemEmissao = origemEmissao;
    }

    @Generated
    public void setPago(Boolean pago) {
        this.pago = pago;
    }

    @Generated
    public void setSubSeqPref(Integer subSeqPref) {
        this.subSeqPref = subSeqPref;
    }

    @Generated
    public void setTipoBloqueto(TipoBloqueto tipoBloqueto) {
        this.tipoBloqueto = tipoBloqueto;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUtilizaValorBloqueto(Boolean utilizaValorBloqueto) {
        this.utilizaValorBloqueto = utilizaValorBloqueto;
    }

    @Generated
    public void setAnoDivPref(Integer anoDivPref) {
        this.anoDivPref = anoDivPref;
    }

    @Generated
    public void setBloquetoGeradoBaixaAutomatica(Boolean bloquetoGeradoBaixaAutomatica) {
        this.bloquetoGeradoBaixaAutomatica = bloquetoGeradoBaixaAutomatica;
    }

    @Generated
    public void setCadastroInvalido(Integer cadastroInvalido) {
        this.cadastroInvalido = cadastroInvalido;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    @Generated
    public void setDebitos(List<BoletoDebito> debitos) {
        this.debitos = debitos;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setParcelaCotaUnica(Long parcelaCotaUnica) {
        this.parcelaCotaUnica = parcelaCotaUnica;
    }

    @Generated
    public void setDiasAdiadosVencimento(Long diasAdiadosVencimento) {
        this.diasAdiadosVencimento = diasAdiadosVencimento;
    }

    @Generated
    public void setRegistroOnline(Boolean registroOnline) {
        this.registroOnline = registroOnline;
    }

    @Generated
    public void setTextoQrCode(String textoQrCode) {
        this.textoQrCode = textoQrCode;
    }

    @Generated
    public void setTxidPix(String txidPix) {
        this.txidPix = txidPix;
    }

    @Generated
    public void setAnoProcesso(Long anoProcesso) {
        this.anoProcesso = anoProcesso;
    }

    @Generated
    public void setNumeroProcesso(Long numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Generated
    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    @Generated
    public void setNossoNumeroGeradoBanco(String nossoNumeroGeradoBanco) {
        this.nossoNumeroGeradoBanco = nossoNumeroGeradoBanco;
    }

    @Generated
    public void setValorHonorario(BigDecimal valorHonorario) {
        this.valorHonorario = valorHonorario;
    }

    @Generated
    public void setPagamentoNegociado(Long pagamentoNegociado) {
        this.pagamentoNegociado = pagamentoNegociado;
    }
}

