/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class GatewayRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    public static final String FORWARDED_HEADER = "X-FORWARDED-HOST";
    private final KeycloakResolver keycloakResolver;

    public GatewayRestTemplateInterceptor(KeycloakResolver keycloakResolver) {
        this.keycloakResolver = keycloakResolver;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String token = this.keycloakResolver.getKeycloak().tokenManager().grantToken().getToken();
        request.getHeaders().set("authorization", "Bearer " + token);
        if (TenantUtils.hasTenant()) {
            request.getHeaders().set(FORWARDED_HEADER, TenantUtils.getIdentificadorTenant());
        }
        return execution.execute(request, body);
    }
}

