/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.dto.ReajusteTabelaValorAlteracaoDTO;
import br.com.elotech.tributos.calculo.dto.ReajusteValorSimulacaoDTO;
import br.com.elotech.tributos.calculo.repository.ReajusteValorRepository;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.calculo.ReajusteValor;
import br.com.elotech.tributos.domain.calculo.ReajusteValorItem;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.domain.parcelamento.StatusReajusteValor;
import br.com.elotech.tributos.domain.parcelamento.TipoReajusteValor;
import br.com.elotech.tributos.domain.parcelamento.TipoReajusteValorItem;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.NotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ReajusteValorService
extends CrudService<ReajusteValor, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReajusteValorService.class);
    private final ReajusteValorRepository reajusteValorRepository;
    private final ParametroGeralService parametroGeralService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    protected void beforeSave(ReajusteValor entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.getItens().forEach(valorItem -> valorItem.setReajusteValor(entity));
    }

    public ReajusteValor findOne(Long id) {
        return Optional.ofNullable((ReajusteValor)this.reajusteValorRepository.findOne((Object)id)).orElseThrow(() -> new NotFoundException(String.format("N\u00e3o foi encontrada a simula\u00e7\u00e3o com id %d", id)));
    }

    public ReajusteValor simular(ReajusteValorSimulacaoDTO simulacaoDTO) {
        this.validaSeExisteReajusteEfetivado(simulacaoDTO.getExercicio());
        this.validaSeExisteReajusteEmSimulacao(simulacaoDTO.getId(), simulacaoDTO.getExercicio());
        BigDecimal percentual = simulacaoDTO.getValor().divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        Boolean utilizaTestadaGenerica = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA);
        ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral = this.configuracaoInscricaoCadastralService.getConfiguracao();
        ReajusteValor reajusteValor = this.getReajusteValor(simulacaoDTO);
        reajusteValor.setData(LocalDateTime.now());
        reajusteValor.setValor(simulacaoDTO.getValor());
        reajusteValor.getItens().clear();
        this.alterarTabelaValor(configuracaoInscricaoCadastral, reajusteValor, simulacaoDTO.getExercicio(), percentual);
        if (Boolean.FALSE.equals(utilizaTestadaGenerica)) {
            this.alterarTestada(configuracaoInscricaoCadastral, reajusteValor, simulacaoDTO.getExercicio(), percentual);
        } else {
            this.alterarTestadaGenerica(configuracaoInscricaoCadastral, reajusteValor, simulacaoDTO.getExercicio(), percentual);
        }
        return (ReajusteValor)this.save((EloEntity)reajusteValor, null);
    }

    private void validaSeExisteReajusteEfetivado(Long exercicio) {
        ReajusteValor reajusteValorExistente = this.reajusteValorRepository.findByExercicioAndStatus(exercicio, StatusReajusteValor.EFETIVADO);
        if (Objects.nonNull(reajusteValorExistente)) {
            throw new EloValidationException(String.format("J\u00e1 existe um reajuste para o exerc\u00edc\u00edo %d com status Efetivado", exercicio));
        }
    }

    private void validaSeExisteReajusteEmSimulacao(Long id, Long exercicio) {
        ReajusteValor reajusteValorExistente = this.reajusteValorRepository.findByExercicioAndStatus(exercicio, StatusReajusteValor.SIMULACAO);
        if (Objects.nonNull(reajusteValorExistente) && (Objects.isNull(id) || id.compareTo(reajusteValorExistente.getId()) != 0)) {
            throw new EloValidationException(String.format("J\u00e1 existe um reajuste para o exerc\u00edc\u00edo %d com status Simula\u00e7\u00e3o", exercicio));
        }
    }

    private ReajusteValor getReajusteValor(ReajusteValorSimulacaoDTO simulacaoDTO) {
        if (Objects.nonNull(simulacaoDTO.getId())) {
            return this.findOne(simulacaoDTO.getId());
        }
        ReajusteValor reajusteValor = new ReajusteValor();
        reajusteValor.setTipo(TipoReajusteValor.ANUAL);
        reajusteValor.setUsuario(SecurityUtils.getUserAise());
        reajusteValor.setExercicio(simulacaoDTO.getExercicio());
        reajusteValor.setStatus(StatusReajusteValor.SIMULACAO);
        return reajusteValor;
    }

    public void alterarTabelaValor(ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral, ReajusteValor reajusteValor, Long exercicio, BigDecimal reajuste) {
        List<ReajusteTabelaValorAlteracaoDTO> valores = this.reajusteValorRepository.loadItensTabelaValor(exercicio).stream().filter(vl -> BigDecimal.ZERO.compareTo(vl.getValor()) != 0).toList();
        for (ReajusteTabelaValorAlteracaoDTO dto : valores) {
            ReajusteValorItem rvi = ReajusteValorItem.of((ReajusteTabelaValorAlteracaoDTO)dto);
            rvi.setTipo(TipoReajusteValorItem.TABELA_VALOR);
            rvi.setReajusteValor(reajusteValor);
            rvi.setDescricao(dto.getDescricaoCompleta(configuracaoInscricaoCadastral, TipoReajusteValorItem.TABELA_VALOR));
            rvi.setValorAtualizado(rvi.getValor().add(rvi.getValor().multiply(reajuste)).setScale(2, RoundingMode.HALF_EVEN));
            reajusteValor.getItens().add(rvi);
        }
    }

    public void alterarTestada(ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral, ReajusteValor reajusteValor, Long exercicio, BigDecimal reajuste) {
        List valores = this.reajusteValorRepository.loadItensTabelaTestada(exercicio);
        for (ReajusteTabelaValorAlteracaoDTO dto : valores) {
            ReajusteValorItem rvi = ReajusteValorItem.of((ReajusteTabelaValorAlteracaoDTO)dto);
            rvi.setTipo(TipoReajusteValorItem.TABELA_TESTADA);
            rvi.setReajusteValor(reajusteValor);
            rvi.setDescricao(dto.getDescricaoCompleta(configuracaoInscricaoCadastral, TipoReajusteValorItem.TABELA_TESTADA));
            if (dto.getValor().compareTo(BigDecimal.ZERO) != 0) {
                rvi.setValorAtualizado(dto.getValor().add(dto.getValor().multiply(reajuste)).setScale(2, RoundingMode.HALF_EVEN));
            }
            rvi.setValorItbi(dto.getValorItbi());
            if (dto.getValorItbi().compareTo(BigDecimal.ZERO) != 0) {
                rvi.setValorItbiAtualizado(dto.getValorItbi().add(dto.getValorItbi().multiply(reajuste)).setScale(2, RoundingMode.HALF_EVEN));
            }
            reajusteValor.getItens().add(rvi);
        }
    }

    public void alterarTestadaGenerica(ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral, ReajusteValor reajusteValor, Long exercicio, BigDecimal reajuste) {
        List valores = this.reajusteValorRepository.loadItensTabelaTestadaGenerica(exercicio);
        for (ReajusteTabelaValorAlteracaoDTO dto : valores) {
            ReajusteValorItem rvi = ReajusteValorItem.of((ReajusteTabelaValorAlteracaoDTO)dto);
            rvi.setTipo(TipoReajusteValorItem.TABELA_TESTADA_GENERICA);
            rvi.setReajusteValor(reajusteValor);
            rvi.setDescricao(dto.getDescricaoCompleta(configuracaoInscricaoCadastral, TipoReajusteValorItem.TABELA_TESTADA_GENERICA));
            if (dto.getValor().compareTo(BigDecimal.ZERO) != 0) {
                rvi.setValorAtualizado(dto.getValor().add(dto.getValor().multiply(reajuste)));
            }
            reajusteValor.getItens().add(rvi);
        }
    }

    public void apagarSimulacao(Long id) {
        this.reajusteValorRepository.deleteById((Object)id);
    }

    private void aplicarAlteracoesValor(ReajusteValor reajusteValor, Boolean estornar) {
        Boolean utilizaTestadaGenerica = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA);
        this.reajusteValorRepository.atualizarTabelaValorByReajuste(reajusteValor.getId(), estornar);
        if (Boolean.FALSE.equals(utilizaTestadaGenerica)) {
            this.reajusteValorRepository.atualizarTestadasByReajuste(reajusteValor.getId(), estornar);
        } else {
            this.reajusteValorRepository.atualizarTestadasGenericasByReajuste(reajusteValor.getId(), estornar);
        }
    }

    public ReajusteValor efetivar(ReajusteValor reajusteValor) {
        ReajusteValor reajuste = this.findOne(reajusteValor.getId());
        reajuste.setUsuario(SecurityUtils.getUserAise());
        reajuste.setData(LocalDateTime.now());
        reajuste.setStatus(StatusReajusteValor.EFETIVADO);
        reajuste = (ReajusteValor)this.save((EloEntity)reajuste, null);
        this.aplicarAlteracoesValor(reajuste, Boolean.FALSE);
        return reajuste;
    }

    public ReajusteValor estornar(Long id) {
        ReajusteValor reajuste = this.findOne(id);
        reajuste.setUsuarioEstorno(SecurityUtils.getUserAise());
        reajuste.setDataEstorno(LocalDateTime.now());
        reajuste.setStatus(StatusReajusteValor.ESTORNADO);
        reajuste = (ReajusteValor)this.save((EloEntity)reajuste, null);
        this.aplicarAlteracoesValor(reajuste, Boolean.TRUE);
        return reajuste;
    }

    @Generated
    public ReajusteValorService(ReajusteValorRepository reajusteValorRepository, ParametroGeralService parametroGeralService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.reajusteValorRepository = reajusteValorRepository;
        this.parametroGeralService = parametroGeralService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }
}

