/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.domain.TabelaValorCelula;
import br.com.elotech.tributos.calculo.domain.TabelaValorColuna;
import br.com.elotech.tributos.calculo.dto.EspelhamentoCalculoDTO;
import br.com.elotech.tributos.calculo.repository.CalculoAvaliacaoRepository;
import br.com.elotech.tributos.calculo.repository.CalculoProjetoRepository;
import br.com.elotech.tributos.calculo.repository.CalculoTributoRepository;
import br.com.elotech.tributos.calculo.repository.TabelaValorRepository;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacaoScript;
import br.com.elotech.tributos.domain.calculo.CalculoProjeto;
import br.com.elotech.tributos.domain.calculo.CalculoProjetoScript;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.CalculoTributoScript;
import br.com.elotech.tributos.dto.ExistsDTO;
import br.com.elotech.tributos.repository.DividaRepository;
import br.com.elotech.tributos.repository.TributoRepository;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EspelhamentoCalculoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EspelhamentoCalculoService.class);
    private final TabelaValorRepository tabelaValorRepository;
    private final CalculoTributoRepository calculoTributoRepository;
    private final CalculoAvaliacaoRepository calculoAvaliacaoRepository;
    private final CalculoProjetoRepository calculoProjetoRepository;
    private final DividaRepository dividaRepository;
    private final TributoRepository tributoRepository;

    public ExistsDTO existsByExercicioDestino(EspelhamentoCalculoDTO request) {
        Long exercicio = request.getExercicioDestino();
        ArrayList formulas = new ArrayList();
        ExistsDTO exists = new ExistsDTO();
        this.existsCalculoTributoByExercicioDestino(request, exercicio, exists, formulas);
        this.existsTabelaValorByExercicioDestino(request, exercicio, exists, formulas);
        this.existsCalculoAvaliacaoByExercicioDestino(request, exercicio, exists, formulas);
        this.existsCalculoProjetoByExercicioDestino(request, exercicio, exists, formulas);
        if (exists.isExists()) {
            exists.setMessage(String.format("J\u00e1 existe registros para '%s' no exerc\u00edcio de destino %d", String.join((CharSequence)", ", formulas), exercicio));
        }
        return exists;
    }

    public void espelhar(EspelhamentoCalculoDTO request) {
        if (request.isEspelharCalculoTributo()) {
            this.cloneTableCalculoTributo(request);
        }
        if (request.isEspelharTabelaValor()) {
            this.cloneTableTabelaValor(request);
        }
        if (request.isEspelharCalculoAvaliacao()) {
            this.cloneTableCalculoAvaliacao(request);
        }
        if (request.isEspelharCalculoProjeto()) {
            this.cloneCalculoProjeto(request);
        }
    }

    private void existsCalculoTributoByExercicioDestino(EspelhamentoCalculoDTO request, Long exercicio, ExistsDTO exists, ArrayList<String> formulas) {
        if (request.isEspelharCalculoTributo() && this.calculoTributoRepository.existsByExercicio(exercicio)) {
            exists.setExists(Boolean.TRUE.booleanValue());
            formulas.add("F\u00f3rmulas de C\u00e1lculo Tributos");
        }
    }

    private void existsTabelaValorByExercicioDestino(EspelhamentoCalculoDTO request, Long exercicio, ExistsDTO exists, ArrayList<String> formulas) {
        if (request.isEspelharTabelaValor() && this.tabelaValorRepository.existsByExercicio(exercicio)) {
            exists.setExists(Boolean.TRUE.booleanValue());
            formulas.add("Tabela de Valores");
        }
    }

    private void existsCalculoAvaliacaoByExercicioDestino(EspelhamentoCalculoDTO request, Long exercicio, ExistsDTO exists, ArrayList<String> formulas) {
        if (request.isEspelharCalculoAvaliacao() && this.calculoAvaliacaoRepository.existsByExercicio(exercicio)) {
            exists.setExists(Boolean.TRUE.booleanValue());
            formulas.add("F\u00f3rmulas de Avalia\u00e7\u00e3o");
        }
    }

    private void existsCalculoProjetoByExercicioDestino(EspelhamentoCalculoDTO request, Long exercicio, ExistsDTO exists, ArrayList<String> formulas) {
        if (request.isEspelharCalculoProjeto() && this.calculoProjetoRepository.existsByExercicio(exercicio)) {
            exists.setExists(Boolean.TRUE.booleanValue());
            formulas.add("F\u00f3rmulas de Projetos");
        }
    }

    private void validateCalculoTributo(EspelhamentoCalculoDTO request) {
        if (!this.calculoTributoRepository.existsByExercicio(request.getExercicioOrigem())) {
            throw new EloValidationException(String.format("N\u00e3o existe f\u00f3rmulas de c\u00e1lculo de tributos para o exerc\u00edcio de origem %d", request.getExercicioOrigem()));
        }
    }

    private void validateTabelaValor(EspelhamentoCalculoDTO request) {
        if (!this.tabelaValorRepository.existsByExercicio(request.getExercicioOrigem())) {
            throw new EloValidationException(String.format("N\u00e3o existe tabela de valor para o exerc\u00edcio de origem %d", request.getExercicioOrigem()));
        }
    }

    private void validateCalculoAvaliacao(EspelhamentoCalculoDTO request) {
        if (!this.calculoAvaliacaoRepository.existsByExercicio(request.getExercicioOrigem())) {
            throw new EloValidationException(String.format("N\u00e3o existe f\u00f3rmulas de c\u00e1lculo de avalia\u00e7\u00e3o para o exerc\u00edcio de origem %d", request.getExercicioOrigem()));
        }
    }

    private void validateCalculoProjeto(EspelhamentoCalculoDTO request) {
        if (!this.calculoProjetoRepository.existsByExercicio(request.getExercicioOrigem())) {
            throw new EloValidationException(String.format("N\u00e3o existe f\u00f3rmulas de c\u00e1lculo de projeto para o exerc\u00edcio de origem %d", request.getExercicioOrigem()));
        }
    }

    private Object cloneEntity(Object entityToClone) {
        try {
            return BeanUtils.cloneBean((Object)entityToClone);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Erro ao clonar a entidade {}. {}", entityToClone, (Object)e.getMessage());
            throw new EloValidationException(String.format("Erro ao clonar a entidade %s", entityToClone));
        }
    }

    private void cloneTableCalculoTributo(EspelhamentoCalculoDTO request) {
        this.validateCalculoTributo(request);
        this.clearCalculoTributoByExercicioDestinoIfExists(request);
        List<CalculoTributo> calculosTributos = this.calculoTributoRepository.findAllByExercicio(request.getExercicioOrigem()).stream().map(ct -> {
            CalculoTributo newCalculoTributo = (CalculoTributo)this.cloneEntity(ct);
            ArrayList newScripts = new ArrayList();
            Divida divida = ct.getDivida();
            Tributo tributo = ct.getTributo();
            newCalculoTributo.setId(null);
            newCalculoTributo.setExercicio(request.getExercicioDestino());
            newCalculoTributo.setDivida(this.findOrCloneDivida(request, divida));
            newCalculoTributo.setTributo(this.findOrCloneTributo(request, tributo));
            ct.getScript().forEach(script -> this.cloneAndAddCalculoTributoScript(script, newCalculoTributo, newScripts));
            newCalculoTributo.setScript(newScripts);
            return newCalculoTributo;
        }).toList();
        this.calculoTributoRepository.saveAll(calculosTributos);
    }

    private void cloneAndAddCalculoTributoScript(CalculoTributoScript script, CalculoTributo newCalculoTributo, ArrayList<CalculoTributoScript> newScripts) {
        CalculoTributoScript calculoTributoScript = (CalculoTributoScript)this.cloneEntity((Object)script);
        calculoTributoScript.setId(null);
        calculoTributoScript.setCalculoTributo(newCalculoTributo);
        newScripts.add(calculoTributoScript);
    }

    private void cloneTableTabelaValor(EspelhamentoCalculoDTO request) {
        this.validateTabelaValor(request);
        this.clearTabelaValorByExercicioDestinoIfExists(request);
        List<TabelaValor> tabelasValores = this.tabelaValorRepository.findAllByExercicio(request.getExercicioOrigem()).stream().map(tv -> {
            TabelaValor newTabelaValor = (TabelaValor)this.cloneEntity(tv);
            ArrayList newColunas = new ArrayList();
            newTabelaValor.setId(null);
            newTabelaValor.setExercicio(request.getExercicioDestino());
            tv.getColunas().forEach(coluna -> this.cloneAndAddTabelaValorColuna(coluna, newTabelaValor, newColunas));
            newTabelaValor.setColunas(newColunas);
            return newTabelaValor;
        }).toList();
        this.tabelaValorRepository.saveAll(tabelasValores);
    }

    private void cloneAndAddTabelaValorColuna(TabelaValorColuna coluna, TabelaValor newTabelaValor, ArrayList<TabelaValorColuna> newColunas) {
        ArrayList newCelulaList = new ArrayList();
        TabelaValorColuna newTabelaValorColuna = (TabelaValorColuna)this.cloneEntity((Object)coluna);
        newTabelaValorColuna.setId(null);
        newTabelaValorColuna.setTabelaValor(newTabelaValor);
        newTabelaValorColuna.getCelulas().forEach(celula -> this.cloneAndAddTabelaValorCelula(celula, newTabelaValorColuna, newCelulaList));
        newTabelaValorColuna.setCelulas(newCelulaList);
        newColunas.add(newTabelaValorColuna);
    }

    private void cloneAndAddTabelaValorCelula(TabelaValorCelula celula, TabelaValorColuna newTabelaValorColuna, ArrayList<TabelaValorCelula> newCelulaList) {
        TabelaValorCelula newTabelaValorCelula = (TabelaValorCelula)this.cloneEntity((Object)celula);
        newTabelaValorCelula.setId(null);
        newTabelaValorCelula.setColuna(newTabelaValorColuna);
        newCelulaList.add(newTabelaValorCelula);
    }

    private void cloneTableCalculoAvaliacao(EspelhamentoCalculoDTO request) {
        this.validateCalculoAvaliacao(request);
        this.clearCalculoAvaliacaoByExercicioDestinoIfExists(request);
        List<CalculoAvaliacao> calculosAvaliacoes = this.calculoAvaliacaoRepository.findAllByExercicio(request.getExercicioOrigem()).stream().map(ca -> {
            CalculoAvaliacao newCalculoAvaliacao = (CalculoAvaliacao)this.cloneEntity(ca);
            ArrayList newScripts = new ArrayList();
            newCalculoAvaliacao.setId(null);
            newCalculoAvaliacao.setExercicio(request.getExercicioDestino());
            newCalculoAvaliacao.getScript().forEach(script -> this.cloneAndAddCalculoAvaliacaoScript(script, newCalculoAvaliacao, newScripts));
            newCalculoAvaliacao.setScript(newScripts);
            return newCalculoAvaliacao;
        }).toList();
        this.calculoAvaliacaoRepository.saveAll(calculosAvaliacoes);
    }

    private void cloneAndAddCalculoAvaliacaoScript(CalculoAvaliacaoScript script, CalculoAvaliacao newCalculoAvaliacao, ArrayList<CalculoAvaliacaoScript> newScripts) {
        CalculoAvaliacaoScript calculoAvaliacaoScript = (CalculoAvaliacaoScript)this.cloneEntity((Object)script);
        calculoAvaliacaoScript.setId(null);
        calculoAvaliacaoScript.setCalculoAvaliacao(newCalculoAvaliacao);
        newScripts.add(calculoAvaliacaoScript);
    }

    private void cloneCalculoProjeto(EspelhamentoCalculoDTO request) {
        this.validateCalculoProjeto(request);
        this.clearCalculoProjetoByExercicioDestinoIfExists(request);
        List<CalculoProjeto> calculosProjetos = this.calculoProjetoRepository.findAllByExercicio(request.getExercicioOrigem()).stream().map(cp -> {
            CalculoProjeto newCalculoProjeto = (CalculoProjeto)this.cloneEntity(cp);
            ArrayList newScripts = new ArrayList();
            Divida divida = cp.getDivida();
            Tributo tributo = cp.getTributo();
            newCalculoProjeto.setId(null);
            newCalculoProjeto.setExercicio(request.getExercicioDestino());
            newCalculoProjeto.setDivida(this.findOrCloneDivida(request, divida));
            newCalculoProjeto.setTributo(this.findOrCloneTributo(request, tributo));
            cp.getScript().forEach(script -> this.cloneAndAddCalculoProjetoScript(script, newCalculoProjeto, newScripts));
            newCalculoProjeto.setScript(newScripts);
            return newCalculoProjeto;
        }).toList();
        this.calculoProjetoRepository.saveAll(calculosProjetos);
    }

    private void cloneAndAddCalculoProjetoScript(CalculoProjetoScript script, CalculoProjeto newCalculoProjeto, ArrayList<CalculoProjetoScript> newScripts) {
        CalculoProjetoScript calculoProjetoScript = (CalculoProjetoScript)this.cloneEntity((Object)script);
        calculoProjetoScript.setId(null);
        calculoProjetoScript.setCalculoProjeto(newCalculoProjeto);
        newScripts.add(calculoProjetoScript);
    }

    private void clearCalculoTributoByExercicioDestinoIfExists(EspelhamentoCalculoDTO request) {
        if (this.calculoTributoRepository.existsByExercicio(request.getExercicioDestino())) {
            List calculosTributos = this.calculoTributoRepository.findAllByExercicio(request.getExercicioDestino());
            this.calculoTributoRepository.deleteAll((Iterable)calculosTributos);
        }
    }

    private void clearTabelaValorByExercicioDestinoIfExists(EspelhamentoCalculoDTO request) {
        if (this.tabelaValorRepository.existsByExercicio(request.getExercicioDestino())) {
            List tabelasValores = this.tabelaValorRepository.findAllByExercicio(request.getExercicioDestino());
            this.tabelaValorRepository.deleteAll((Iterable)tabelasValores);
        }
    }

    private void clearCalculoAvaliacaoByExercicioDestinoIfExists(EspelhamentoCalculoDTO request) {
        if (this.calculoAvaliacaoRepository.existsByExercicio(request.getExercicioDestino())) {
            List calculosAvaliacoes = this.calculoAvaliacaoRepository.findAllByExercicio(request.getExercicioDestino());
            this.calculoAvaliacaoRepository.deleteAll((Iterable)calculosAvaliacoes);
        }
    }

    private void clearCalculoProjetoByExercicioDestinoIfExists(EspelhamentoCalculoDTO request) {
        if (this.calculoProjetoRepository.existsByExercicio(request.getExercicioDestino())) {
            List calculosProjetos = this.calculoProjetoRepository.findAllByExercicio(request.getExercicioDestino());
            this.calculoProjetoRepository.deleteAll((Iterable)calculosProjetos);
        }
    }

    private Divida findOrCloneDivida(EspelhamentoCalculoDTO request, Divida divida) {
        return this.dividaRepository.findByEntidadeAndExercicioAndDivida(divida.getEntidade(), request.getExercicioDestino(), divida.getDivida()).orElseGet(() -> this.cloneDivida(request, divida));
    }

    private Divida cloneDivida(EspelhamentoCalculoDTO request, Divida divida) {
        Divida newDivida = (Divida)this.cloneEntity((Object)divida);
        newDivida.setId(null);
        newDivida.setExercicio(request.getExercicioDestino());
        return newDivida;
    }

    private Tributo findOrCloneTributo(EspelhamentoCalculoDTO request, Tributo tributo) {
        Tributo found = this.tributoRepository.findByEntidadeAndExercicioAndTributo(tributo.getEntidade(), request.getExercicioDestino(), tributo.getTributo());
        if (Objects.nonNull(found)) {
            return found;
        }
        return this.cloneTributo(request, tributo);
    }

    private Tributo cloneTributo(EspelhamentoCalculoDTO request, Tributo tributo) {
        Tributo newTributo = (Tributo)this.cloneEntity((Object)tributo);
        newTributo.setId(null);
        newTributo.setExercicio(request.getExercicioDestino());
        return newTributo;
    }

    @Generated
    public EspelhamentoCalculoService(TabelaValorRepository tabelaValorRepository, CalculoTributoRepository calculoTributoRepository, CalculoAvaliacaoRepository calculoAvaliacaoRepository, CalculoProjetoRepository calculoProjetoRepository, DividaRepository dividaRepository, TributoRepository tributoRepository) {
        this.tabelaValorRepository = tabelaValorRepository;
        this.calculoTributoRepository = calculoTributoRepository;
        this.calculoAvaliacaoRepository = calculoAvaliacaoRepository;
        this.calculoProjetoRepository = calculoProjetoRepository;
        this.dividaRepository = dividaRepository;
        this.tributoRepository = tributoRepository;
    }
}

