/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.domain.TabelaValorCelula;
import br.com.elotech.tributos.calculo.domain.TabelaValorColuna;
import br.com.elotech.tributos.calculo.exception.TabelaValorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.SimpleRulesTableBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElotechRulesTableBuilder
extends SimpleRulesTableBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElotechRulesTableBuilder.class);

    public ElotechRulesTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    public void createTabelaValor(TabelaValor tabelaValor) {
        Integer maximoDeLinhas = tabelaValor.getColunas().stream().map(c -> c.getCelulas().size()).max(Integer::compare).orElse(0);
        try {
            this.beginTable(tabelaValor.getColunas().size(), maximoDeLinhas.intValue());
        }
        catch (CreateTableException ex) {
            LOGGER.error("N\u00e3o foi poss\u00edvel inicializar a cria\u00e7\u00e3o da tabela de valor: {}. Detalhes: {}.", (Object)tabelaValor.getNome(), (Object)ex.getMessage());
            throw new TabelaValorException(String.format("N\u00e3o foi poss\u00edvel inicializar a cria\u00e7\u00e3o da tabela de valor: %s.", tabelaValor.getNome()), (Throwable)ex);
        }
        this.writeHeader(tabelaValor.geraAssinaturaTabelaValor(), null);
        List rowParametros = this.createRow(tabelaValor.getColunasOrdenadas().stream().map(TabelaValorColuna::getDescricao).collect(Collectors.toList()));
        this.writeTableBodyRow(rowParametros);
        int contadorColuna = 0;
        for (TabelaValorColuna coluna : tabelaValor.getColunasOrdenadas()) {
            int contadorLinha = this.getCurrentRow();
            for (TabelaValorCelula celula : coluna.getCelulas()) {
                this.writeCell(contadorColuna, contadorLinha++, 1, 1, (Object)celula.getValor(), null);
            }
            ++contadorColuna;
        }
        this.incCurrentRow(maximoDeLinhas.intValue());
        try {
            this.endTable();
        }
        catch (CreateTableException ex) {
            LOGGER.error("Ocorreu um erro ao finalizar a cria\u00e7\u00e3o da tabela de valor: {}. Detalhes: {}.", (Object)tabelaValor.getNome(), (Object)ex.getMessage());
            throw new TabelaValorException(String.format("Ocorreu um erro ao finalizar a cria\u00e7\u00e3o da tabela de valor: %s.", tabelaValor.getNome()), (Throwable)ex);
        }
    }

    private List<Map<String, Object>> createRow(List<Object> cells) {
        ArrayList<Map<String, Object>> row = new ArrayList<Map<String, Object>>();
        cells.forEach(cell -> row.add(this.createCell(cell)));
        return row;
    }

    private Map<String, Object> createCell(Object value) {
        String keyDefault = "value";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", value);
        return map;
    }
}

