/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CadastroGeralCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroImobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroMobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroRuralCalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoExecucaoBaseService;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.calculo.service.CalculoTributoExecucaoService;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.OrigemDadosCalculo;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class CalculoTributoExecucaoService
extends CalculoExecucaoBaseService<CalculoTributo, Long> {
    private final CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository;
    private final CadastroRuralCalculoRepository cadastroRuralCalculoRepository;
    private final CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository;
    private final CadastroGeralCalculoRepository cadastroGeralCalculoRepository;

    public CalculoTributoExecucaoService(TabelaValorService tabelaValorService, ConversionService conversionService, CadastroGeralCalculoRepository cadastroGeralCalculoRepository, CadastroRuralCalculoRepository cadastroRuralCalculoRepository, CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository, CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository) {
        super(conversionService, tabelaValorService);
        this.cadastroGeralCalculoRepository = cadastroGeralCalculoRepository;
        this.cadastroMobiliarioCalculoRepository = cadastroMobiliarioCalculoRepository;
        this.cadastroRuralCalculoRepository = cadastroRuralCalculoRepository;
        this.cadastroImobiliarioCalculoRepository = cadastroImobiliarioCalculoRepository;
    }

    public List<CadastroCalculoRoot<Long>> calcularSemCompilarFormulas(List<CalculoTributo> tributos, Long exercicio, String filtro, LocalDate dataReferencia, CalculoTabelaValores calculoTabelaValores) {
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(tributos);
        List cadastrosRoots = this.loadCadastros(tributos, filtro, null, exercicio, camposDinamicos, dataReferencia);
        if (cadastrosRoots.isEmpty()) {
            throw new CalculoException(String.format("N\u00e3o foram encontrados cadastros para o filtro informado: %s.", filtro));
        }
        for (CalculoTributo tributo : tributos) {
            tributo.getCalculoBuildDTO().getContext().setCalculoTabelaValores(calculoTabelaValores);
            tributo.getCalculoBuildDTO().getContext().setExercicioCalculo(Integer.valueOf(tributo.getExercicio().intValue()));
        }
        cadastrosRoots.forEach(cadastro -> this.executeCalculo(tributos, cadastro));
        return cadastrosRoots;
    }

    public void verifyFiltroTemUmCadastroGeralPeloMenos(String filtro) {
        if (!this.cadastroGeralCalculoRepository.temUmCadastroGeralPeloMenos(filtro).booleanValue()) {
            throw new CalculoException("N\u00e3o foram encontrados cadastros para o filtro informado.");
        }
    }

    public List<CadastroCalculoRoot<Long>> testarScript(ParametroTesteScriptDTO parametroTestScriptDTO) {
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorResultado(parametroTestScriptDTO.getIdentificador());
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorBaseCalculo(null);
        CalculoBuild.buildCalculoDebugMode((List)parametroTestScriptDTO.getCalculoTributo().getScript(), CalculoParser::parseLinhaDebugMode, (OrigemDadosCalculo)parametroTestScriptDTO.getCalculoTributo().getOrigemDadosCalculo());
        return this.calcular(Collections.singletonList(parametroTestScriptDTO.getCalculoTributo()), parametroTestScriptDTO.getCalculoTributo().getExercicio(), parametroTestScriptDTO.buildFiltro(), parametroTestScriptDTO.getSegmento(), Boolean.TRUE, LocalDate.now());
    }

    protected List<CadastroCalculoRoot<Long>> loadCadastros(List<CalculoTributo> configs, String filtro, Long segmento, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos, LocalDate dataReferencia) {
        super.beforeLoadCadastros(configs);
        CalculoTributo config = configs.get(0);
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$calculo$OrigemDadosCalculo[config.getOrigemDadosCalculo().ordinal()]) {
            case 1: {
                Boolean isFuncaoTotalCadastroPorSegmento = Boolean.FALSE;
                if (this.isFuncaoBuscaTotalCadastroPorSegmento(configs)) {
                    isFuncaoTotalCadastroPorSegmento = this.isFuncaoBuscaTotalCadastroPorSegmento(configs);
                }
                return this.cadastroImobiliarioCalculoRepository.loadCadastros(filtro, segmento, exercicio, camposDinamicos, isFuncaoTotalCadastroPorSegmento, Boolean.TRUE);
            }
            case 2: {
                return this.cadastroMobiliarioCalculoRepository.loadCadastros(filtro, exercicio, camposDinamicos, dataReferencia);
            }
            case 3: {
                return this.cadastroRuralCalculoRepository.loadCadastros(filtro, exercicio, camposDinamicos);
            }
        }
        throw new EloValidationException(String.format("N\u00e3o h\u00e1 implementa\u00e7\u00e3o de c\u00e1lculo para a os dados de origem  %s.", config.getOrigemDadosCalculo()));
    }
}

