/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.exception.TabelaValorException;
import br.com.elotech.tributos.calculo.service.ElotechRulesTableBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.load.SimpleWorkbookLoader;
import org.openl.rules.lang.xls.load.WorkbookLoader;
import org.openl.rules.runtime.RulesEngineFactory;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.ModuleFileSourceCodeModule;
import org.openl.syntax.exception.CompositeOpenlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculoTabelaValores {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoTabelaValores.class);
    private static final String PREFIXO_ARQUIVO = "openL_tabela_valor";
    private static final String TIPO_ARQUIVO = ".xlsx";
    private final ConversionService conversionService;
    private final ModuleFileSourceCodeModule source;
    private final ElotechRulesTableBuilder builder;
    private RulesEngineFactory<Object> rulesEngineFactory;
    private Object service;
    private Map<String, Method> metodosDisponiveis;

    private static File createTempFile() {
        try {
            File openl = File.createTempFile("openL_tabela_valor", ".xlsx");
            openl.deleteOnExit();
            return openl;
        }
        catch (IOException ex) {
            LOGGER.error("N\u00e3o foi poss\u00edvel criar o arquivo tempor\u00e1rio para as tabelas de valores. {}", (Object)ex.getMessage());
            throw new TabelaValorException("N\u00e3o foi poss\u00edvel criar o arquivo tempor\u00e1rio para as tabelas de valores.", (Throwable)ex);
        }
    }

    public CalculoTabelaValores(ConversionService conversionService, List<TabelaValor> tabelasValores) {
        File file = CalculoTabelaValores.createTempFile();
        this.conversionService = conversionService;
        try {
            this.source = new ModuleFileSourceCodeModule(file.toURI().toURL(), "openL_tabela_valor");
        }
        catch (MalformedURLException ex) {
            LOGGER.error("N\u00e3o foi poss\u00edvel encontrar o arquivo das tabelas de valores. {}", (Object)ex.getMessage());
            throw new TabelaValorException("N\u00e3o foi poss\u00edvel encontrar o arquivo das tabelas de valores.", (Throwable)ex);
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        workbook.createSheet("openL_tabela_valor");
        SimpleWorkbookLoader loader = new SimpleWorkbookLoader((Workbook)workbook);
        XlsWorkbookSourceCodeModule workbookSource = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)this.source, (WorkbookLoader)loader);
        XlsSheetSourceCodeModule sheetSource = new XlsSheetSourceCodeModule(0, workbookSource);
        XlsSheetGridModel gridModel = new XlsSheetGridModel(sheetSource);
        this.builder = new ElotechRulesTableBuilder(gridModel);
        this.addTabelaValor(tabelasValores);
        this.build();
    }

    private void addTabelaValor(List<TabelaValor> tabelasValores) {
        tabelasValores.forEach(arg_0 -> ((ElotechRulesTableBuilder)this.builder).createTabelaValor(arg_0));
        try {
            this.builder.save();
        }
        catch (CreateTableException ex) {
            LOGGER.error("N\u00e3o foi poss\u00edvel salvar o arquivo tempor\u00e1rio das tabelas de valores. {}", (Object)ex.getMessage());
            throw new TabelaValorException("N\u00e3o foi poss\u00edvel salvar o arquivo tempor\u00e1rio das tabelas de valores.", (Throwable)ex);
        }
    }

    private void build() {
        this.rulesEngineFactory = new RulesEngineFactory((IOpenSourceCodeModule)this.source);
        try {
            this.service = this.rulesEngineFactory.newInstance();
        }
        catch (CompositeOpenlException ex) {
            String message = "N\u00e3o foi poss\u00edvel construir as tabelas de valores. H\u00e1 c\u00e9lulas com valores incompat\u00edveis aos tipos dos par\u00e2metros.";
            LOGGER.error(message, (Object)ex.getMessage());
            throw new TabelaValorException(message, (Throwable)ex);
        }
        Class interfaceClass = this.rulesEngineFactory.getInterfaceClass();
        this.metodosDisponiveis = Stream.of(interfaceClass.getMethods()).collect(Collectors.toMap(Method::getName, m -> m));
    }

    public Double calculaTabelaValores(String nomeTabela, Object ... parametros) {
        String nomeTabelaNormalizada = StringUtils.lowerCase((String)nomeTabela);
        Method method = (Method)this.metodosDisponiveis.get(nomeTabelaNormalizada);
        if (Objects.isNull(method)) {
            throw this.logError(this.createMessageError("N\u00e3o foi poss\u00edvel encontrar a tabela de valor.", nomeTabelaNormalizada));
        }
        Class<?>[] tiposParametros = method.getParameterTypes();
        if (parametros.length != tiposParametros.length) {
            String messageParametros = String.format("%s Par\u00e2metros: \"%s\" - Tipos Esperados: \"%s\".", "A quantidade de par\u00e2metros n\u00e3o confere com a quantidade cadastrada.", Stream.of(parametros).map(Object::toString).collect(Collectors.joining(", ")), Stream.of(tiposParametros).map(Class::getSimpleName).collect(Collectors.joining(",")));
            throw this.logError(this.createMessageError(messageParametros, nomeTabelaNormalizada));
        }
        Object[] parametrosTipados = new Object[tiposParametros.length];
        for (int i = 0; i < tiposParametros.length; ++i) {
            Object parametro = parametros[i];
            Class<?> tipoParametro = tiposParametros[i];
            try {
                parametrosTipados[i] = this.conversionService.convert(parametro, tipoParametro);
                continue;
            }
            catch (ConversionException ex) {
                String message = this.createMessageError(String.format("Par\u00e2metro \"%s\" incompat\u00edvel ao tipo \"%s\".", parametro, tipoParametro.getSimpleName()), nomeTabelaNormalizada);
                LOGGER.error(message, (Object)ex.getMessage());
                throw new TabelaValorException(message, (Throwable)ex);
            }
        }
        return (Double)ReflectionUtils.invokeMethod((Method)method, (Object)this.service, (Object[])parametrosTipados);
    }

    private String createMessageError(String message, String nomeTabela) {
        return String.format("Erro ao buscar os valores da tabela de valor \"%s\": %s", nomeTabela, message);
    }

    private TabelaValorException logError(String message) {
        LOGGER.error(message);
        return new TabelaValorException(message);
    }
}

