/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroImobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroMobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoImobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoMobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoProjetoContext;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.ProjetoCalculoDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoProjeto;
import br.com.elotech.tributos.domain.calculo.CalculoScriptBase;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.OrigemDadosCalculo;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import com.google.common.base.Stopwatch;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;

public abstract class CalculoExecucaoBaseService<T extends CalculoConfigBase, ID> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoExecucaoBaseService.class);
    private final ConversionService conversionService;
    private final TabelaValorService tabelaValorService;
    private final String BUSCA_TOTAL_CADASTRO_SEGMENTO = "buscatotalcadastroporsegmento";

    protected List<CadastroCalculoRoot<ID>> calcular(List<T> configs, Long exercicio, String filtro, Long segmento, Boolean traceAtivo, LocalDate dataReferencia, UnaryOperator<List<CadastroCalculoRoot<ID>>> customizer) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(configs);
        List root = this.loadCadastros(configs, filtro, segmento, exercicio, camposDinamicos, dataReferencia);
        if (Objects.nonNull(customizer)) {
            root = (List)customizer.apply(root);
        }
        stopwatch.stop();
        log.debug("Carregando {} cadastros - {} m {} s {} ms - {} ns", new Object[]{root.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        if (root.isEmpty()) {
            throw new CalculoException("N\u00e3o foram encontrados cadastros para o filtro informado.");
        }
        return this.calcular(root, configs, traceAtivo, exercicio);
    }

    public List<CadastroCalculoRoot<ID>> calcular(List<T> configs, Long exercicio, String filtro, Long segmento, Boolean traceAtivo, LocalDate dataReferencia) {
        return this.calcular(configs, exercicio, filtro, segmento, traceAtivo, dataReferencia, null);
    }

    public List<CadastroCalculoRoot<ID>> calcular(List<T> configs, Long exercicio, String filtro, Boolean traceAtivo, LocalDate dataReferencia) {
        return this.calcular(configs, exercicio, filtro, null, traceAtivo, dataReferencia);
    }

    public List<CadastroCalculoRoot<ID>> calcular(List<CadastroCalculoRoot<ID>> cadastros, List<T> configs, Boolean traceAtivo, Long exercicio) {
        CalculoTabelaValores calculoTabelaValores = this.carregaTabelaValores(exercicio);
        for (CalculoConfigBase config : configs) {
            CalculoBuildDTO calculoBuildDTO = this.getFormulaCompilada(config, traceAtivo);
            config.setCalculoBuildDTO(calculoBuildDTO);
            config.getCalculoBuildDTO().getContext().setCalculoTabelaValores(calculoTabelaValores);
            config.getCalculoBuildDTO().getContext().setExercicioCalculo(Integer.valueOf(exercicio.intValue()));
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        cadastros.forEach(cadastro -> this.executeCalculo(configs, cadastro));
        stopwatch.stop();
        log.debug("Execution time: {} cadastros -  {} ms  - {} ns", new Object[]{cadastros.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return cadastros;
    }

    protected CalculoTabelaValores carregaTabelaValores(Long exercicio) {
        return new CalculoTabelaValores(this.conversionService, this.tabelaValorService.findByExercicio(exercicio));
    }

    public CalculoBuildDTO getFormulaCompilada(T config, Boolean traceAtivo) {
        try {
            String scriptParsed = CalculoParser.parseLinhas((List)config.getScript(), (String)config.getIdentificadorResultado(), (String)config.getIdentificadorBaseCalculo(), (String)config.getIdentificadorCondicao(), (String)"", (String)config.getIdentificadorAliquota(), (String)"", (String)"", (String)config.getIdentificadorRenuncia(), (String)config.getIdentificadorIsencao());
            Stopwatch stopwatch = Stopwatch.createStarted();
            CalculoBuildDTO calculoBuildDTO = CalculoBuild.buildCalculo((String)scriptParsed, (Boolean)traceAtivo, (OrigemDadosCalculo)config.getOrigemDadosCalculo());
            stopwatch.stop();
            log.debug("Build time {}: {} ms - {} ns ", new Object[]{config.getIdentificadorLog(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
            return calculoBuildDTO;
        }
        catch (Exception e) {
            throw new CalculoException(String.format("Erro ao compilar o c\u00e1lculo %s", config.getIdentificadorLog()), (Throwable)e);
        }
    }

    protected void executeCalculo(List<T> configs, CadastroCalculoRoot<?> root) {
        for (CalculoConfigBase config : configs) {
            try {
                if (config instanceof CalculoTributo) {
                    config.getCalculoBuildDTO().getContext().setAceitaCampoNulo(((CalculoTributo)config).getAceitaCampoNulo());
                }
                if (config instanceof CalculoAvaliacao) {
                    config.getCalculoBuildDTO().getContext().setAceitaCampoNulo(((CalculoAvaliacao)config).getAceitaCampoNulo());
                }
                if (config instanceof CalculoProjeto) {
                    config.getCalculoBuildDTO().getContext().setAceitaCampoNulo(((CalculoProjeto)config).getAceitaCampoNulo());
                }
                if (TipoCalculoConfig.GERAL.equals((Object)config.getTipo())) {
                    this.executeCalculoGeral(root, config);
                    continue;
                }
                this.executeCalculoPorSegmento(root, config);
            }
            catch (InvocationTargetException e) {
                log.error("Erro ao calcular {} do cadastro {}-{}: {}", new Object[]{config.getIdentificadorLog(), root.getTipoCadastro(), root.getCadastroGeral(), e});
                root.addInconsistencia(config, e.getTargetException().getMessage());
            }
            catch (Exception e) {
                log.error("Erro ao calcular {} do cadastro {}-{}: {}", new Object[]{config.getIdentificadorLog(), root.getTipoCadastro(), root.getCadastroGeral(), e});
                root.addInconsistencia(config, e.getMessage());
            }
        }
        root.getEnglobados().forEach(englobado -> this.executeCalculo(configs, englobado));
    }

    private void executeCalculoPorSegmento(CadastroCalculoRoot<?> root, T config) throws InvocationTargetException, IllegalAccessException {
        this.executeTotalAcumuladoCadastroPorSegmentos(root, config);
        for (CadastroCalculoDTO cadastro : root.getChildren()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.setVariaveisCadastro(config.getCalculoBuildDTO().getContext(), cadastro);
            config.getCalculoBuildDTO().getContext().setAcumula(Boolean.FALSE);
            CalculoContext context = CalculoBuild.evaluate((CalculoBuildDTO)config.getCalculoBuildDTO());
            cadastro.addResultado(config, context);
            stopwatch.stop();
            log.trace("Cadastro: {}-{} - {} - Evaluation time: {} ms  - {} ns", new Object[]{root.getTipoCadastro(), root.getCadastroGeral(), config.getIdentificadorLog(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        }
    }

    public void executeTotalAcumuladoCadastroPorSegmentos(CadastroCalculoRoot root, T config) throws InvocationTargetException, IllegalAccessException {
        if (!this.isFuncaoBuscaTotalCadastroPorSegmento(List.of(config)) || root.getCadastroCalculoDTO().isEmpty()) {
            return;
        }
        CalculoContext context = config.getCalculoBuildDTO().getContext();
        context.getCache().remove("buscatotalporcadastro");
        List cadastrosParaProcessar = this.getCadastrosParaProcessar(root);
        for (CadastroCalculoDTO cadastro : cadastrosParaProcessar) {
            this.processarCadastro(context, cadastro, config);
        }
    }

    public List<CadastroCalculoDTO> getCadastrosParaProcessar(CadastroCalculoRoot root) {
        if (root.getCadastroCalculoDTO() == null || root.getCadastroCalculoDTO().isEmpty()) {
            return root.getChildren();
        }
        return root.getCadastroCalculoDTO();
    }

    public void processarCadastro(CalculoContext context, CadastroCalculoDTO cadastro, T config) throws InvocationTargetException, IllegalAccessException {
        this.setVariaveisCadastro(context, cadastro);
        context.setAcumula(Boolean.TRUE);
        if (config instanceof CalculoTributo) {
            config.getCalculoBuildDTO().getContext().setAceitaCampoNulo(((CalculoTributo)config).getAceitaCampoNulo());
        }
        if (config instanceof CalculoAvaliacao) {
            config.getCalculoBuildDTO().getContext().setAceitaCampoNulo(((CalculoAvaliacao)config).getAceitaCampoNulo());
        }
        if (config instanceof CalculoProjeto) {
            config.getCalculoBuildDTO().getContext().setAceitaCampoNulo(((CalculoProjeto)config).getAceitaCampoNulo());
        }
        CalculoBuild.evaluate((CalculoBuildDTO)config.getCalculoBuildDTO());
    }

    private void executeCalculoGeral(CadastroCalculoRoot<?> root, T config) throws InvocationTargetException, IllegalAccessException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.setVariaveisCadastro(config.getCalculoBuildDTO().getContext(), (CadastroCalculoDTO)root.getChildren().get(0));
        CalculoContext context = CalculoBuild.evaluate((CalculoBuildDTO)config.getCalculoBuildDTO());
        root.addResultado(config, context);
        stopwatch.stop();
        log.trace("Cadastro: {}-{} - {} - Evaluation time: {} ms  - {} ns", new Object[]{root.getTipoCadastro(), root.getCadastroGeral(), config.getIdentificadorLog(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
    }

    private void setVariaveisCadastro(CalculoContext context, CadastroCalculoDTO cadastro) {
        if (context instanceof CalculoImobiliarioContext) {
            ((CalculoImobiliarioContext)context).setCadastro(((CadastroImobiliarioCalculoDTO)cadastro).getCadastro());
            ((CalculoImobiliarioContext)context).setSegmento(((CadastroImobiliarioCalculoDTO)cadastro).getSegmento());
            ((CalculoImobiliarioContext)context).setTestada(((CadastroImobiliarioCalculoDTO)cadastro).getTestada());
            ((CalculoImobiliarioContext)context).setTestadagenerica(((CadastroImobiliarioCalculoDTO)cadastro).getTestadaGenerica());
        } else if (context instanceof CalculoMobiliarioContext) {
            ((CalculoMobiliarioContext)context).setCadastro(((CadastroMobiliarioCalculoDTO)cadastro).getCadastro());
            ((CalculoMobiliarioContext)context).setAtividade(((CadastroMobiliarioCalculoDTO)cadastro).getAtividade());
            ((CalculoMobiliarioContext)context).setCnae(((CadastroMobiliarioCalculoDTO)cadastro).getCnae());
            ((CalculoMobiliarioContext)context).setServico(((CadastroMobiliarioCalculoDTO)cadastro).getServico());
        } else if (context instanceof CalculoProjetoContext) {
            ((CalculoProjetoContext)context).setProjeto(((ProjetoCalculoDTO)cadastro).getProjeto());
            ((CalculoProjetoContext)context).setProjetoitem(((ProjetoCalculoDTO)cadastro).getItem());
            ((CalculoProjetoContext)context).setCadastro(((ProjetoCalculoDTO)cadastro).getCadastro());
            ((CalculoProjetoContext)context).setTestada(((ProjetoCalculoDTO)cadastro).getTestada());
            ((CalculoProjetoContext)context).setTestadaGenerica(((ProjetoCalculoDTO)cadastro).getTestadaGenerica());
        }
    }

    protected void beforeLoadCadastros(List<T> configs) {
        if (configs.isEmpty()) {
            throw new CalculoException("N\u00e3o foi informado script para execu\u00e7\u00e3o do c\u00e1lculo.");
        }
    }

    protected abstract List<CadastroCalculoRoot<ID>> loadCadastros(List<T> var1, String var2, Long var3, Long var4, Set<CampoDinamicoScriptDTO> var5, LocalDate var6);

    protected boolean isFuncaoBuscaTotalCadastroPorSegmento(List<T> configs) {
        return configs.stream().map(CalculoConfigBase::getScript).flatMap(Collection::stream).map(CalculoScriptBase::getExpressao).filter(expressao -> expressao != null).map(expressao -> expressao.replaceAll("\\s+", "").toLowerCase()).anyMatch(normalizedExpressao -> normalizedExpressao.contains("buscatotalcadastroporsegmento"));
    }

    @Generated
    public CalculoExecucaoBaseService(ConversionService conversionService, TabelaValorService tabelaValorService) {
        this.conversionService = conversionService;
        this.tabelaValorService = tabelaValorService;
    }
}

