/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CadastroImobiliarioMemoriaCalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoExecucaoBaseService;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.OrigemDadosCalculo;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class CalculoContenciosoRecalculoService
extends CalculoExecucaoBaseService<CalculoTributo, Long> {
    private final CadastroImobiliarioMemoriaCalculoRepository cadastroImobiliarioMemoriaCalculoRepository;

    public CalculoContenciosoRecalculoService(TabelaValorService tabelaValorService, ConversionService conversionService, CadastroImobiliarioMemoriaCalculoRepository cadastroImobiliarioMemoriaCalculoRepository) {
        super(conversionService, tabelaValorService);
        this.cadastroImobiliarioMemoriaCalculoRepository = cadastroImobiliarioMemoriaCalculoRepository;
    }

    public List<CadastroCalculoRoot<Long>> calcularSemCompilarFormulas(List<CalculoTributo> tributos, Long exercicio, String filtro, LocalDate dataReferencia, CalculoTabelaValores calculoTabelaValores) {
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(tributos);
        List cadastrosRoots = this.loadCadastros(tributos, filtro, null, exercicio, camposDinamicos, dataReferencia);
        if (cadastrosRoots.isEmpty()) {
            throw new CalculoException(String.format("N\u00e3o foram encontrados cadastros para o filtro informado: %s.", filtro));
        }
        for (CalculoTributo tributo : tributos) {
            tributo.getCalculoBuildDTO().getContext().setCalculoTabelaValores(calculoTabelaValores);
            tributo.getCalculoBuildDTO().getContext().setExercicioCalculo(Integer.valueOf(tributo.getExercicio().intValue()));
        }
        cadastrosRoots.forEach(cadastro -> this.executeCalculo(tributos, cadastro));
        return cadastrosRoots;
    }

    protected List<CadastroCalculoRoot<Long>> loadCadastros(List<CalculoTributo> configs, String filtro, Long segmento, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos, LocalDate dataReferencia) {
        super.beforeLoadCadastros(configs);
        Boolean isFuncaoTotalCadastroPorSegmento = Boolean.FALSE;
        if (this.isFuncaoBuscaTotalCadastroPorSegmento(configs)) {
            isFuncaoTotalCadastroPorSegmento = this.isFuncaoBuscaTotalCadastroPorSegmento(configs);
        }
        return this.cadastroImobiliarioMemoriaCalculoRepository.loadCadastros(filtro, segmento, exercicio, camposDinamicos, isFuncaoTotalCadastroPorSegmento);
    }

    public List<CadastroCalculoRoot<Long>> testarScript(ParametroTesteScriptDTO parametroTestScriptDTO) {
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorResultado(parametroTestScriptDTO.getIdentificador());
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorBaseCalculo(null);
        CalculoBuild.buildCalculoDebugMode((List)parametroTestScriptDTO.getCalculoTributo().getScript(), CalculoParser::parseLinhaDebugMode, (OrigemDadosCalculo)parametroTestScriptDTO.getCalculoTributo().getOrigemDadosCalculo());
        return this.calcular(Collections.singletonList(parametroTestScriptDTO.getCalculoTributo()), parametroTestScriptDTO.getCalculoTributo().getExercicio(), parametroTestScriptDTO.buildFiltro(), parametroTestScriptDTO.getSegmento(), Boolean.TRUE, LocalDate.now());
    }
}

